package cn.com.duiba.udf;

import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * Created by clemac on 19/7/15.
 */
public class MtDecrypt extends UDF {

    /**
     * AES加密时的秘钥
     */
    private final static String AES_KEY = "waimaiad_aes_key";
    /**
     * AES专用秘钥
     */
    private static SecretKeySpec KEY = null;

    /**
     * key因为在没改变AES_KEY时是不变的，所以进行一次初始化操作
     */
    static {
        // 创建AES的秘钥生成器
        KEY = new SecretKeySpec(AES_KEY.getBytes(), "AES");
    }

    /**
     * 加密文本
     */
    public static String encrypt(String content) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        byte[] byteContent = content.getBytes(StandardCharsets.UTF_8);
        cipher.init(Cipher.ENCRYPT_MODE, KEY);
        // 进行AES加密
        byte[] result = cipher.doFinal(byteContent);
        // 将byte数组转为十六进制的字符串
        return parseByte2HexStr(result);

    }

    /**
     * 解码文本
     */
    public static String decrypt(String encryptContent) throws Exception {
        // 将十六进制的加密文本转换为byte数组
        byte[] content = parseHexStr2Byte(encryptContent);
        if (content == null) {
            return null;
        }
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.DECRYPT_MODE, KEY);
        byte[] result = cipher.doFinal(content);
        // 将二进制转为字符串
        return new String(result);
    }

    /**
     * 将byte数组转换成16进制的字符串
     *
     * @param buf
     * @return 16进制的字符串
     */
    public static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.length; i++) {
            //将每个字节都转成16进制的
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                //为保证格式统一，用两位16进制的表示一个字节
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    /**
     * 将16进制的字符串转换为byte数组
     *
     * @param hexStr
     * @return byte数组
     */
    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int num = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 2), 16);
            result[i] = (byte) num;
        }
        return result;
    }

    /**
     * 解析美团的参数
     */
    public static Map<String, Object> analysisMeituanParams(String params) throws Exception {
        if (StringUtils.isBlank(params)) {
            return null;
        }
        String dectypt = decrypt(params);

        String[] split = dectypt.split("\\|");
        Map<String, Object> map = Maps.newHashMap();
        for (String pa : split) {
            String[] split1 = pa.split("=");
            map.put(split1[0], split1[1]);
        }
        return map;
    }

    public String evaluate(String code) {
        if(StringUtils.isBlank(code)){
            return code;
        }else{
            try {
                return decrypt(code);
            }catch (Exception e){
                return null;
            }
        }
    }


}
