package cn.com.duiba.udf;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;

/**
 * Created by clemac on 17/1/6.
 */
public class IsImei extends UDF {

    public Boolean evaluate(String str) {
        if(StringUtils.isBlank(str) || str.length() != 15 || !StringUtils.isNumeric(str)){
            return false;
        }else{
            String data = str.substring(0,14);
            int sum1=0;
            int sum2=0;
            for (int i = 0; i < data.length(); i++) {
                int num = data.charAt(i) - '0';     // ascii to num
                //System.out.println(num);
                    /*(1)将奇数位数字相加(从1开始计数)*/
                if (i%2==0) {
                    sum1 = sum1 + num;
                }else{
                        /*(2)将偶数位数字分别乘以2,分别计算个位数和十位数之和(从1开始计数)*/
                    int temp = num * 2 ;
                    if (temp < 10) {
                        sum2=sum2+temp;
                    }else{
                        sum2 = sum2 + temp + 1 -10;
                    }
                }
            }
            int total = sum1+sum2;
                /*如果得出的数个位是0则校验位为0,否则为10减去个位数 */
            String resultStr;
            if (total % 10 ==0) {
                resultStr=data+"0";
            }else{
                resultStr=data+ (10 - (total %10))+"";
            }
            if (str.equals(resultStr)){
                return true;
            } else {
                return false;
            }
        }
    }

}