package cn.com.duiba.udf;

import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.json.JSONObject;


import java.util.HashMap;
import java.util.Map;


public class ParseUaUDF extends UDF {

    private static UserAgentAnalyzer userAgentAnalyzer ;
    static {
        // 置于静态代码块初始化，要不然每次初始化，很影响性能
         userAgentAnalyzer = UserAgentAnalyzer
                .newBuilder()
                .hideMatcherLoadStats()
                .delayInitialization()
                .build();
    }
    public String evaluate(String strUa) {
        try{

            int UaLengthLimit = 5;
            if (StringUtils.isBlank(strUa) && strUa.length() <= UaLengthLimit && StringUtils.isEmpty(strUa)) {
                return null;
            }

            UserAgent userAgent = userAgentAnalyzer.parse(strUa);
            String DeviceClass = userAgent.getValue("DeviceClass");
            String DeviceBrand = userAgent.getValue("DeviceBrand");
            String DeviceName = userAgent.getValue("DeviceName");
            String OperatingSystemClass = userAgent.getValue("OperatingSystemClass");
            String OperatingSystemName = userAgent.getValue("OperatingSystemName");
            String OperatingSystemVersion = userAgent.getValue("OperatingSystemVersion");
//            基本网络类型解析不出来
//            String NETWORK_TYPE = userAgent.getValue("NETWORK_TYPE");

            Map map = new HashMap();
            map.put("device_class", DeviceClass);
            map.put("device_brand", DeviceBrand);
            map.put("device_name", DeviceName);
            map.put("operating_system_class", OperatingSystemClass);
            map.put("operating_system_name", OperatingSystemName);
            map.put("operating_system_version", OperatingSystemVersion);
//            map.put("network_type", NETWORK_TYPE);

            JSONObject json = new JSONObject(map);
            return json.toString();
        }catch (Exception e){
            e.printStackTrace();
            return null ;
        }
    }

}
