package cn.com.duiba.udf;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.UDF;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Created by clemac on 17/3/7.
 */
public class DuplicateRemove extends UDF {

    public String evaluate(String str1,String str2,String split) {
        if((StringUtils.isBlank(split))){
            return null;
        }
        if (StringUtils.isBlank(str1) && StringUtils.isBlank(str2)) {
            return null;
        } else if (StringUtils.isBlank(str1) && StringUtils.isNotBlank(str2)) {
            return str2;
        } else if (StringUtils.isNotBlank(str1) && StringUtils.isBlank(str2)) {
            return str1;
        } else {
            Set<String> mySet = new HashSet<>(Arrays.asList(str1.split(split)));
            mySet.addAll(Arrays.asList(str2.split(split)));
            StringBuilder csvBuilder = new StringBuilder();
            for (String str : mySet) {
                csvBuilder.append(str);
                csvBuilder.append(split);
            }
            String csv = csvBuilder.toString();
            if(csv.length() - split.length() < 0){
                return csv;
            }
            csv = csv.substring(0, csv.length() - split.length());
            return csv;
        }
    }

}
