/*
 * Request.ts
 * Created by 还有醋v on 2020/11/10.
 * Copyright © 2020 haiyoucuv. All rights reserved.
 */

import {AxiosResponse} from "axios";
import {apiUrl, mockUrl} from "./apiList";

const axios = require('axios');

export default class Request {
    constructor() {

    }

    /**
     * 请求个接口
     * @param url
     * @param params
     * @param method
     */
    public static api(
        url: string,
        params: any = {},
        method: 'get' | 'post' = 'get'
    ) {
        return new Promise((resolve, reject) => {
            const uri = (window.location.port == '3000') ? mockUrl : apiUrl;
            Request[method](uri + url, params)
                .then((res) => {
                    resolve(res.data);
                    /* 打印参数和返回 */
                    console.log(
                        `\n%c[ request ]\n`
                        + `URL   : ${uri + url} \n`
                        + `METHOD: ${method} \n`
                        + `PARAM : %o \n`
                        + `DATA  : %o \n`
                        , 'color:green'
                        , params
                        , res.data
                    );
                })
                .catch((err) => {
                    resolve(null);
                });
        });
    }


    public static async fetchAsync(url: string) {
        let response = await fetch(url);
        return await response.text();
    }

    public static get<T = any, R = AxiosResponse<T>>(
        url: string,
        params: any = {}
    ): Promise<R> {
        return axios.get(url, {
            params: {
                __timestamp__: Date.now(),
                ...params
            }
        });
    }

    public static post<T = any, R = AxiosResponse<T>>(
        url: string,
        params: any = {}
    ): Promise<R> {
        return axios.post(url, {
            __timestamp__: Date.now(),
            ...params
        });
    }


    // public static file(
    //     url: string,
    //     params: any = {},
    // ) {
    //
    // }

}