/*
 * Tools.ts
 * Created by 还有醋v on 2020/11/10.
 * Copyright © 2020 haiyoucuv. All rights reserved.
 */

import Request from "./request/Request";
import {apiList} from "./request/apiList";
import {history} from "./BaseRouter";

export class Tools {
    constructor() {
    }

    public static getQueryParams() {
        const queryParams: any = {};
        for (let item of history.location.search.replace('?', '').split('&')) {
            let arr = item.split('=');
            queryParams[arr[0]] = arr.length === 1 ? true : arr[1] || '';
        }
        return queryParams;
    }

    public static async packageQuery(
        params: {
            keyword?: string,
            searchType?: 'id' | 'name' | 'remark',
            pkgType?: 1 | 2 | 3,
            pageNum?: number,
            pageSize?: number,
        } = {}
    ): Promise<any> {
        const res: any = await Request.api(apiList.packageQuery, params);
        if (!res || +res.code != 0) {
            return null;
        }
        return res;
    }
}