/*
 * SearchList.tsx
 * Created by 还有醋v on 2020/11/6.
 * Copyright © 2020 haiyoucuv. All rights reserved.
 */


import React, {ReactNode} from 'react';

import './SearchList.less';
import {Card, List, Pagination, Spin} from "antd";
import SearchListItem from "../../Component/SearchListItem/SearchListItem";
import {Tools} from "../../Tools";

export default class SearchList extends React.Component<any> {

    public state: any = {
        showData: [],
        total: 0,
        pageSize: 10,
        pageNum: 1,
        current: 1,
        loading: false,
    }

    constructor(props: any, context: any) {
        super(props, context);
    }

    public async componentDidMount() {
        this.queryParams = Tools.getQueryParams();
        await this.queryPackage();
    }

    private queryParams: any = {};

    public componentWillReceiveProps(nextProps: Readonly<any>, nextContext: any) {
        this.queryParams = Tools.getQueryParams();
        this.queryPackage();
    }

    public async queryPackage(pageNum: number = 1, pageSize: number = this.state.pageSize) {
        console.log(decodeURI(this.queryParams.keyword));
        this.setState({loading: true});
        const res = await Tools.packageQuery({
            keyword: decodeURI(this.queryParams.keyword),
            pageNum: pageNum,
            pageSize: pageSize,
        });
        this.setState({loading: false});
        if (!res) return;

        this.setState({
            pageNum,
            pageSize,
            showData: res.data.packages,
            total: res.data.total
        });
    }

    private onPageChange = (pageNum: number, pageSize?: number) => {
        this.queryPackage(pageNum, pageSize);
    }

    // private onShowSizeChange = (pageNum: number, pageSize?: number) => {
    //     this.queryPackage(pageNum, pageSize);
    // }

    public render(): ReactNode {
        const {showData, total, pageSize, pageNum, loading} = this.state;

        const getPagination = () => {
            return (
                <div className='search-list-pagination-top'>
                    <div className='search-list-pagination-cont'>
                        <div>
                            <h2 className="search-list-num">{`${total} packages found`}</h2>
                        </div>
                        <Pagination
                            className='search-list-pagination'
                            current={pageNum}
                            total={total}
                            pageSize={pageSize}
                            hideOnSinglePage={false}
                            showSizeChanger
                            onChange={this.onPageChange}
                            // onShowSizeChange={this.onShowSizeChange}
                        />
                    </div>
                </div>
            );
        }

        return (
            <div className='search-list'>
                {/*{getPagination()}*/}
                <div className='search-list-pagination-top'
                     style={{
                         position: "sticky",
                         top: 0
                     }}>
                    <div className='search-list-pagination-cont'>
                        <div>
                            <h2 className="search-list-num">{`${total} packages found`}</h2>
                        </div>
                        <Pagination
                            className='search-list-pagination'
                            current={pageNum}
                            total={total}
                            pageSize={pageSize}
                            hideOnSinglePage={false}
                            showSizeChanger
                            onChange={this.onPageChange}
                            // onShowSizeChange={this.onShowSizeChange}
                        />
                    </div>
                </div>

                <Card className='search-list-card'>
                    <List className='search-list-list'
                          itemLayout="horizontal"
                          dataSource={showData}
                          renderItem={(item) => (
                              <List.Item>
                                  <SearchListItem data={item}/>
                              </List.Item>
                          )}
                    >
                        {loading && <Spin
                            className='search-list-spin'
                            size="large"
                            tip="Loading..."
                        />}
                    </List>
                </Card>
                {getPagination()}
            </div>
        );
    }
}