/*
 * Index.tsx
 * Created by 还有醋v on 2020/11/6.
 * Copyright © 2020 haiyoucuv. All rights reserved.
 */


import React, {ReactNode} from 'react';
import ReactDOM from 'react-dom';

import './Index.less';
import AppHeader from "../../Element/AppHeader/AppHeader";
import {history} from "../../BaseRouter";

export default class Index extends React.Component<any> {

    public state: any = {}

    constructor(props: any, context: any) {
        super(props, context);
    }

    public componentDidMount(): void {
        const indexTxt = ReactDOM.findDOMNode(this.refs.indexTxt) as HTMLDivElement;

        indexTxt.style.setProperty('--percentage', `${0}%`);
        document.addEventListener('scroll', () => {
            let scrolled = document.documentElement.scrollTop / (document.documentElement.scrollHeight - document.documentElement.clientHeight);
            indexTxt.style.setProperty('--percentage', `${scrolled * 100}%`);
        })
    }

    public componentWillUnmount(): void {

    }

    public render(): ReactNode {
        return (
            <div className='index'>
                <div className='index-bg' ref='indexTxt'>
                    <div className="index-txt">
                        <h1 className="index-txt-h1">
                            Build amazing things
                        </h1>

                        <div className="index-txt-cont">
                            <div>
                                We're npm, Inc., the company behind Node package manager, the npm
                                Registry, and npm CLI. We offer those to the community for free, but
                                our day job is building and selling useful tools for developers like you.
                            </div>

                            <h2 className="index-txt-cont-center">
                                Take your JavaScript development up a notch
                            </h2>

                            <div>
                                Get started today for free, or step up to npm Pro to enjoy a premium
                                JavaScript development experience, with features like private packages.
                            </div>

                            <div className="index-btn">
                                <a href="#">
                                    Let's Get To Start
                                    <div>____________________</div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        );
    }
}