/*
 * Details.tsx
 * Created by 还有醋v on 2020/11/7.
 * Copyright © 2020 haiyoucuv. All rights reserved.
 */


import React, {ReactNode} from 'react';

import './Details.less';
import ReactDOM from "react-dom";

const ClipboardJS = require('clipboard');

const marked = require('marked');
const rendererMD = new marked.Renderer();
marked.setOptions({
    renderer: rendererMD,
    gfm: true,
    tables: true,
    breaks: false,
    pedantic: false,
    sanitize: false,
    smartLists: true,
    smartypants: false
});//基本设置

export default class Details extends React.Component<any> {

    public state: any = {}

    constructor(props: any, context: any) {
        super(props, context);
    }

    public componentDidMount(): void {
        const clipboard = new ClipboardJS('.click-copy', {
            text: () => {
                return 'npm i react'
            }
        });

        clipboard.on('success', (e: any) => {
            console.log(e);
        });

        clipboard.on('error', (e: any) => {
            console.log(e);
        });

        const div = ReactDOM.findDOMNode(this.refs.mdDiv) as HTMLDivElement;
        div.innerHTML = marked('# Getting Started with Create React App\n' +
            '\n' +
            'This project was bootstrapped with [Create React App](https://github.com/facebook/create-react-app).\n' +
            '\n' +
            '## Available Scripts\n' +
            '\n' +
            'In the project directory, you can run:\n' +
            '\n' +
            '### `yarn start`\n' +
            '```javascript\n' +
            '    var a = 1;\n' +
            '```\n' +
            'Runs the app in the development mode.\\\n' +
            'Open [http://localhost:3000](http://localhost:3000) to view it in the browser.\n' +
            '\n' +
            'The page will reload if you make edits.\\\n' +
            'You will also see any lint errors in the console.\n' +
            '\n' +
            '### `yarn test`\n' +
            '\n' +
            'Launches the test runner in the interactive watch mode.\\\n' +
            'See the section about [running tests](https://facebook.github.io/create-react-app/docs/running-tests) for more information.\n' +
            '\n' +
            '### `yarn build`\n' +
            '\n' +
            'Builds the app for production to the `build` folder.\\\n' +
            'It correctly bundles React in production mode and optimizes the build for the best performance.\n' +
            '\n' +
            'The build is minified and the filenames include the hashes.\\\n' +
            'Your app is ready to be deployed!\n' +
            '\n' +
            'See the section about [deployment](https://facebook.github.io/create-react-app/docs/deployment) for more information.\n' +
            '\n' +
            '### `yarn eject`\n' +
            '\n' +
            '**Note: this is a one-way operation. Once you `eject`, you can’t go back!**\n' +
            '\n' +
            'If you aren’t satisfied with the build tool and configuration choices, you can `eject` at any time. This command will remove the single build dependency from your project.\n' +
            '\n' +
            'Instead, it will copy all the configuration files and the transitive dependencies (webpack, Babel, ESLint, etc) right into your project so you have full control over them. All of the commands except `eject` will still work, but they will point to the copied scripts so you can tweak them. At this point you’re on your own.\n' +
            '\n' +
            'You don’t have to ever use `eject`. The curated feature set is suitable for small and middle deployments, and you shouldn’t feel obligated to use this feature. However we understand that this tool wouldn’t be useful if you couldn’t customize it when you are ready for it.\n' +
            '\n' +
            '## Learn More\n' +
            '\n' +
            'You can learn more in the [Create React App documentation](https://facebook.github.io/create-react-app/docs/getting-started).\n' +
            '\n' +
            'To learn React, check out the [React documentation](https://reactjs.org/).\n');
    }

    public componentWillUnmount(): void {

    }

    public render(): ReactNode {
        return (
            <div className='details'>
                <div className="details-title">
                    <div className='details-title-div'>
                        <h2><span>react</span></h2>
                        <span className="details-version">17.0.1&nbsp;•&nbsp;</span>
                        <span className="details-date">Published&nbsp;•&nbsp;
                        <time>18 days ago</time>
                    </span>
                    </div>

                    <div className='details-install-div'>
                        <h3>Install</h3>
                        <p className="details-install-cmd click-copy">
                            <svg viewBox="0 0 12.32 9.33">
                                <g>
                                    <line x1="7.6" y1="8.9" x2="7.6" y2="6.9"/>
                                    <rect width="1.9" height="1.9"/>
                                    <rect x="1.9" y="1.9" width="1.9" height="1.9"/>
                                    <rect x="3.7" y="3.7" width="1.9" height="1.9"/>
                                    <rect x="1.9" y="5.6" width="1.9" height="1.9"/>
                                    <rect y="7.5" width="1.9" height="1.9"/>
                                </g>
                            </svg>
                            <code title="Copy Command to Clipboard">npm i react</code>

                            <svg className='svg-copy'
                                 xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
                                <path
                                    d="M433.941 65.941l-51.882-51.882A48 48 0 0 0 348.118 0H176c-26.51 0-48 21.49-48 48v48H48c-26.51 0-48 21.49-48 48v320c0 26.51 21.49 48 48 48h224c26.51 0 48-21.49 48-48v-48h80c26.51 0 48-21.49 48-48V99.882a48 48 0 0 0-14.059-33.941zM266 464H54a6 6 0 0 1-6-6V150a6 6 0 0 1 6-6h74v224c0 26.51 21.49 48 48 48h96v42a6 6 0 0 1-6 6zm128-96H182a6 6 0 0 1-6-6V54a6 6 0 0 1 6-6h106v88c0 13.255 10.745 24 24 24h88v202a6 6 0 0 1-6 6zm6-256h-64V48h9.632c1.591 0 3.117.632 4.243 1.757l48.368 48.368a6 6 0 0 1 1.757 4.243V112z"/>
                            </svg>
                        </p>
                    </div>

                </div>

                <div className='md-cont' ref='mdDiv'/>

                <div className='right-cont'>
                    aaaaaaaaa
                </div>

            </div>
        );
    }
}