/*
 * AppFooter.tsx
 * Created by 还有醋v on 2020/11/6.
 * Copyright © 2020 haiyoucuv. All rights reserved.
 */


import React, {ReactNode} from 'react';
import logo from "../../logo.svg";
import {Menu} from "antd";

import './AppHeader.less';
import AppSearch from "../../Component/AppSearch/AppSearch";
import ReactDOM from "react-dom";

export default class AppHeader extends React.Component<any> {

    public state: any = {}

    constructor(props: any, context: any) {
        super(props, context);
    }

    public componentDidMount(): void {
        const searchDiv = ReactDOM.findDOMNode(this.refs.searchDiv) as HTMLDivElement;
        document.addEventListener('scroll', (e) => {
            let scrolled = document.documentElement.scrollTop / (searchDiv.clientHeight + 30);
            searchDiv.style.opacity = (1 - scrolled) + '';
            searchDiv.style.zIndex = (scrolled >= 1) ? '-1' : '2';  // 不用display，否则会导致页面高度改变
        });
    }

    public componentWillUnmount(): void {

    }

    public render(): ReactNode {
        return (
            <div className='header' ref='searchDiv'>
                <div className='app-header'>
                    <img src={logo} className="app-logo" alt="logo"/>
                    <Menu theme="light" mode="horizontal" defaultSelectedKeys={['1']}>
                        <Menu.Item key="1">nav 1</Menu.Item>
                        <Menu.Item key="2">nav 2</Menu.Item>
                        <Menu.Item key="3">nav 3</Menu.Item>
                    </Menu>
                </div>
                <div className='search'>
                    <AppSearch
                        ref={'appSearch'}
                        packageQuery={'this.packageQuery'}
                    />
                </div>
            </div>
        );
    }
}