/*
 * AppSearch.tsx
 * Created by 还有醋v on 2020/11/6.
 * Copyright © 2020 haiyoucuv. All rights reserved.
 */


import React, {ChangeEvent, ReactNode} from 'react';
import './AppSearch.less';

import {Button, Input} from 'antd';
import logo from "../../logo.svg";

import {SearchOutlined} from '@ant-design/icons';
import {Tools} from "../../Tools";
import {history} from "../../BaseRouter";


export default class AppSearch extends React.Component<any> {

    public state: any = {}
    public value: string = '';
    private input: Input | undefined;

    constructor(props: any, context: any) {
        super(props, context);
    }

    public componentDidMount(): void {
        this.input = this.refs.input as Input;

        const queryParams: any = {};
        for (let item of history.location.search.replace('?', '').split('&')) {
            let arr = item.split('=');
            queryParams[arr[0]] = arr.length === 1 ? true : arr[1] || '';
        }

        console.log(queryParams);
        this.input.setState({value: decodeURI(queryParams.keyword || '')});
    }

    public componentWillUnmount(): void {

    }

    /**
     * 点击搜索按钮查询包
     */
    private clickSearch = async () => {
        const keyword = this.input!.state.value;
        history.push(`search?keyword=${keyword || ''}`);
    }

    private async updateTempList() {
        const res = await Tools.packageQuery();
        console.log(res);
    }

    private onInputChange = (event: ChangeEvent<HTMLInputElement>) => {
        this.value = event.target.value;
    }

    public render(): ReactNode {

        return (
            <div className='app-search'>
                <div className="app-search-cont">
                    <img src={logo} className="app-search-logo" alt="logo"/>
                    <div className='app-search-div'>
                        <Input className='app-search-input'
                               ref='input'
                               size="large"
                               onChange={this.onInputChange}
                               onPressEnter={this.clickSearch}
                               placeholder="Search packages"
                               prefix={
                                   <SearchOutlined className='app-search-input-icon'/>
                               }
                        />
                        <Button
                            onClick={this.clickSearch}
                            className='app-search-btn'
                            type="primary"
                        >
                            Search
                        </Button>
                    </div>

                </div>
            </div>
        );
    }
}