import React, {Component} from 'react';
import {Router, Route, Switch} from 'react-router';
import Index from "./Pages/Index/Index";
import SearchList from "./Pages/SearchLIst/SearchList";
import Details from "./Pages/Details/Details";
import {createBrowserHistory} from 'history';
import App from "./App";

import './App.less'
import AppHeader from "./Element/AppHeader/AppHeader";
import AppFooter from "./Element/AppFooter/AppFooter";
import {BackTop} from "antd";
import {VerticalAlignTopOutlined} from "@ant-design/icons";

export const history = createBrowserHistory();

export class BaseRouter extends Component {
    render() {
        return (
            <div className='app'>
                {/* AppHeader */}
                <AppHeader/>

                {/* main */}
                <Router history={history}>
                    <Switch>
                        <Route path="/" component={App} exact children={() => {
                            return <Index/>
                        }}/>
                        <Route path="/index" exact component={Index}/>
                        <Route path="/search" exact component={SearchList}/>
                        <Route path="/details" exact component={Details}/>
                    </Switch>
                </Router>

                {/* footer */}
                <div className='footer'>
                    <AppFooter/>
                </div>

                {/* BackTop */}
                <BackTop visibilityHeight={100}>
                    <VerticalAlignTopOutlined
                        style={{
                            height: 50,
                            width: 50,
                            display: "flex",
                            alignItems: "center",
                            justifyContent: "center",
                            borderRadius: 4,
                            backgroundColor: '#101010',
                            color: '#fff',
                            fontSize: 30,
                        }}/>
                </BackTop>
            </div>
        );
    }
}

export default BaseRouter;
