/*
 * server.js
 * Created by 还有醋v on 2021/6/10.
 * Copyright © 2021 haiyoucuv. All rights reserved.
 */

const ws = require("nodejs-websocket");
console.log("开始建立连接...");

const server = ws.createServer((conn) => {

	console.log(conn.key + "建立连接");

	conn.on("text", (str) => {
		console.log("收到的信息为:" + str);
		conn.sendText("收到消息：" + str);
	});

	// 关闭连接
	conn.on("close", (code, reason) => {
		console.log(conn.key + "关闭连接");
		const msg = JSON.stringify({
			connectedCount: server.connections.length
		});
		broadcast(msg);
	});

	// 异常关闭
	conn.on("error", (code, reason) => {
		console.log(conn.key + "异常关闭");
		const msg = JSON.stringify({
			connectedCount: server.connections.length
		});
		broadcast(msg);
	});

});

/**
 * 广播
 * @param {string} msg
 */
function broadcast(msg) {
	server.connections.forEach(function (conn) {
		conn.sendText(msg);
	});
}

server.listen(3001, "0.0.0.0", () => {
	console.log("WebSocket建立完毕");
});
