package {groupId}.{artifactIdPackage};

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableDuibaFeignClients;

@EnableDiscoveryClient
@EnableCircuitBreaker
@EnableDuibaFeignClients(basePackages = { "{groupId}" })
@SpringBootApplication(exclude = DataSourceAutoConfiguration.class)
public class Application {

    public static void main(String[] args) {
    	System.setProperty("spring.devtools.restart.enabled", "false");
        SpringApplication sa = new SpringApplication(Application.class);
        sa.run(args);
    }

}
