package com.oto.utils;

import com.oto.config.BasicConfig;
import com.oto.sql.KjyUserDB;
import com.oto.sql.UserSqlFactory;
import io.restassured.response.Response;
import org.testng.Assert;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JmeterAccountFile {
    private static final NetworkUtils network = NetworkUtils.getInstance();

    public static void main(String[] args) {
//        String path = String.valueOf(JmeterAccountFile.class.getResource("/"));
//        accountFile(path);
        otoCookieMaker();
    }

    /**
     * 生成otoCookie，仅用于压力测试文件
     */
    public static void otoCookieMaker() {

    }

    //仅用于生成直播账号Authkey文件
    public static void accountFile(String path) {
        BaseUtils.ssoLogin();
        // 保存路径
        String file = path + "AccountFile.txt";
        // 防止文件建立或读取失败，用catch捕捉错误并打印，也可以throw

        try {
            File accountFile = new File("AccountFile.txt");// 相对路径，如果没有则要建立一个新的output。txt文件
            // 判断文件是否存在，不存在即新建
            if(!accountFile.exists()) {
                accountFile.createNewFile(); // 创建新文件
            }
            // 如果是在原有基础上写入则append属性为true，默认为false
            BufferedWriter out = new BufferedWriter(new FileWriter(accountFile,true));
            //获取直播用户id
            List<Map<String, Object>> result = KjyUserDB.getInstance().findModeResult(UserSqlFactory.selectUserIdForJmeter);
            for (Map<String, Object> item:result
                 ) {
                System.out.println(item.get("id"));
                Map<String, Object> subscribeParam = new HashMap<>();
                subscribeParam.put("liveUserId", item.get("id"));
                subscribeParam.put("validDays", 365);
                Response subscribeRes = network.getResponse(subscribeParam, BasicConfig.MANAGER_encryptAuthKey);
                String data = subscribeRes.jsonPath().getString("data");
                Assert.assertNotNull(data, network.message(subscribeParam, BasicConfig.MANAGER_encryptAuthKey, "增加测试用户失败", subscribeRes.body().asString()));
                System.out.println(data);
                out.write(data+"\t\n"); // 写入TXT
                out.flush(); // 把缓存区内容压入文件
            }
            out.close(); // 最后记得关闭文件
        } catch (SQLException throwables) {
            throwables.printStackTrace();
        }catch (IOException e) {
            e.printStackTrace();
        }
    }
}
