package com.oto.utils;
import io.restassured.response.Response;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

import static com.oto.config.BasicConfig.isPushReport;

public class DingTalkUtils {

    private static final NetworkUtils network = NetworkUtils.getInstance();

    private static final AtomicBoolean hasSend = new AtomicBoolean(true);

    // 通过钉钉机器人发送消息到钉钉群中
    public static void sendVal(String context)throws Exception{

        if (!hasSend.compareAndSet(true, false)){
            return;
        }

        //测试结果
        context = "【接口自动化测试结果反馈】\n"
                + context
                + "报告地址: http://10.172.58.199/view/kkk/job/kejiji_interface/HTML_20Report\n";
        System.out.println(context);

        Map<String, Object> contentParams = new HashMap<String, Object>();
        contentParams.put("content",context);
        Map<String, Object> atParams = new HashMap<String, Object>();
        atParams.put("atMobiles","17830855590");

        //钉钉机器人消息体
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("msgtype","text");
        params.put("text",contentParams);
        params.put("at", atParams);

        //发起dingding机器人通知
        if (isPushReport){
            Response response = network.dingTalkRobot(params);
            System.out.println("钉钉 response:"+response.asString());
        }
    }

    // 流程走不通，发送错误信息到钉钉
    public static void sendError(String errorMessage){

        Map<String, Object> contentParams = new HashMap<String, Object>();
        contentParams.put("content","【测试结果】\n" + errorMessage);

        //钉钉机器人消息体
       Map<String, Object> params = new HashMap<String, Object>();
        params.put("msgtype","text");
        params.put("text",contentParams);
        System.out.println(params);

        //发起dingding机器人通知
        if (isPushReport){
            Response response = network.dingTalkRobot(params);
            response.body().prettyPrint();
        }
    }

    public static void main(String[] args) {

    }
}
