package com.oto.utils;

import com.oto.config.BasicConfig;
import io.restassured.response.Response;
import org.testng.Assert;

import java.util.*;

import static com.oto.config.BasicConfig.*;

public class BaseUtils {
    private static final NetworkUtils network = NetworkUtils.getInstance();

    public static String tku1;

    public static String tku2;
    public static String superCookieKey;
    public static String superCookieValue;
    public static String companyCookieKey;
    public static String companyCookieValue;
    public static String officeCookieKey;
    public static String officeCookieValue;
    public static String otoSellerCookieKey;
    public static String otoSellerCookieValue;
    public static String otoLeaderCookieKey;
    public static String otoLeaderCookieValue;
    public static String otoManagerCookieKey;
    public static String otoManagerCookieValue;
    public static String JJBManagerCookieKey;
    public static String JJBManagerCookieValue;

    /**
     * 登录管理后台
     */
    public static void ssoLogin(){
        // 请求下后台的管理员信息接口
        Response response = network.getResponse(MANAGER_adminInfo);
        String actualType = "application/json;charset=UTF-8";
        String exceptType = response.headers().getValue("Content-Type"); //如果返回的是html的contentType，说明token已经失效

        // 判断请求接口后 后台的Csrf-Token是否失效，若两个值相等则有效，反之
        if (actualType.equals(exceptType)){
            return;
        }

        // 1.先进入SSO登录框 登入管理后台
        Map<String, Object> loginParams = new HashMap<String, Object>();
        loginParams.put("email","test@duiba.com.cn");
        loginParams.put("password","d83HjbsJY76UJH");
        loginParams.put("loginTimeout",1);
        loginParams.put("redirect",MANAGER_HOST);
        loginParams.put("systemId",201);
        response = network.postResponse(loginParams,SSO_doLogin);
        Map<String, String> ssoCookies = response.getCookies();
        network.agentCookies.putAll(ssoCookies); //存入cookies
        ssoCookies = response.getCookies();
        network.agentCookies.putAll(ssoCookies);
        network.agentHeaders.put("X-Csrf-Token",ssoCookies.get("csrf_token"));
        // 免登
        network.agentCookies.put("sso_ticket", "autotest");
    }


    /**
     * 普通销售员登录销售工作台
     */
    public static void otoSellerLogin(){
//        ThreadSleepUtils.sleep(2000);
//        // 调用登录接口
//        Map<String, Object> params = new HashMap<String, Object>();
//        params.put("phoneNumber","18248405155");
//        Response response = network.getResponse(params,BasicConfig.WORK_getCaptcha);
//        boolean data = response.jsonPath().getBoolean("data");
//        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_getCaptcha,"获取验证码失败",response.body().asString()));
//
//        //专用于自动化获取验证码
//        params.clear();
//        params.put("phoneNumber","18248405155");
//        Response autoTestRes = network.getResponse(params,BasicConfig.WORK_verifyCode);
//        String captcha = autoTestRes.jsonPath().getString("data");
//        System.out.println(captcha);
//
//        //登录接口
//        ThreadSleepUtils.sleep(2000);
//        params.clear();
//        params.put("phoneNumber","18248405155");
//        params.put("captcha",captcha);
//        Response loginRes = network.postResponse(params,BasicConfig.WORK_login);
//        boolean success = loginRes.jsonPath().getBoolean("success");
//        Assert.assertTrue(success, network.message(params,BasicConfig.WORK_login,"登录失败",loginRes.body().asString()));
//
//        //获取cookie
//        String header = loginRes.getHeader("Set-Cookie");
//        String cookieStr = header.split(";")[0];
//        String[] cookieKeyValue = cookieStr.split("=");
//        otoSellerCookieKey = cookieKeyValue[0];
//        otoSellerCookieValue = cookieKeyValue[1];

        otoSellerCookieKey = "otoToken";
        otoSellerCookieValue = "64e83LYGbaXYX9EkHumCho2UoHa4LLngpoj9ksrdj5vUiAndSwpeHVxc45qhsXT8a8niiL6oifhdXYR2BvYntaAoj4zRqmExv6eEuMsTfiN";

        network.agentCookies.put(otoSellerCookieKey, otoSellerCookieValue); //存入cookies
        System.out.println("销售Cookie中key："+ otoSellerCookieKey +" ，values："+ otoSellerCookieValue);
    }

    /**
     * 总监登录销售工作台
     */
    public static void otoLeaderLogin(){
//        ThreadSleepUtils.sleep(2000);
//        // 调用登录接口
//        Map<String, Object> params = new HashMap<String, Object>();
//        params.put("phoneNumber","13454131091");
//        Response response = network.getResponse(params,BasicConfig.WORK_getCaptcha);
//        boolean data = response.jsonPath().getBoolean("data");
//        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_getCaptcha,"获取验证码失败",response.body().asString()));
//
//        //专用于自动化获取验证码
//        params.clear();
//        params.put("phoneNumber","13454131091");
//        Response autoTestRes = network.getResponse(params,BasicConfig.WORK_verifyCode);
//        String captcha = autoTestRes.jsonPath().getString("data");
//        System.out.println(captcha);
//
//        //登录接口
//        ThreadSleepUtils.sleep(2000);
//        params.clear();
//        params.put("phoneNumber","13454131091");
//        params.put("captcha",captcha);
//        Response loginRes = network.postResponse(params,BasicConfig.WORK_login);
//        boolean success = loginRes.jsonPath().getBoolean("success");
//        Assert.assertTrue(success, network.message(params,BasicConfig.WORK_login,"登录失败",loginRes.body().asString()));
//
//        //获取cookie
//        String header = loginRes.getHeader("Set-Cookie");
//        String cookieStr = header.split(";")[0];
//        String[] cookieKeyValue = cookieStr.split("=");
//        otoLeaderCookieKey = cookieKeyValue[0];
//        otoLeaderCookieValue = cookieKeyValue[1];

        otoLeaderCookieKey = "otoToken";
        otoLeaderCookieValue = "64e83LYGbaXYX9EkHumCho2UoHa4LLngtEH3qdP4vZcgziRKzqpEScM6Ea5UdYNEMDstTteXF6yrygqLEsBVdZJ1mKGyZ4cD5dZVM2RqyrK";

        network.agentCookies.put(otoLeaderCookieKey, otoLeaderCookieValue); //存入cookies
        System.out.println("总监Cookie中key："+ otoLeaderCookieKey +" ，values："+ otoLeaderCookieValue);
    }

    /**
     * 管理员登录销售工作台
     */
    public static void otoManagerLogin(){
//        ThreadSleepUtils.sleep(2000);
//        // 调用登录接口
//        Map<String, Object> params = new HashMap<String, Object>();
//        params.put("phoneNumber","13900651198");
//        Response response = network.getResponse(params,BasicConfig.WORK_getCaptcha);
//        boolean data = response.jsonPath().getBoolean("data");
//        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_getCaptcha,"获取验证码失败",response.body().asString()));
//
//        //专用于自动化获取验证码
//        params.clear();
//        params.put("phoneNumber","15673990207");
//        Response autoTestRes = network.getResponse(params,BasicConfig.WORK_verifyCode);
//        String captcha = autoTestRes.jsonPath().getString("data");
//        System.out.println(captcha);
//
//        //登录接口
//        ThreadSleepUtils.sleep(2000);
//        params.clear();
//        params.put("phoneNumber","15673990207");
//        params.put("captcha",captcha);
//        Response loginRes = network.postResponse(params,BasicConfig.WORK_login);
//        boolean success = loginRes.jsonPath().getBoolean("success");
//        Assert.assertTrue(success, network.message(params,BasicConfig.WORK_login,"登录失败",loginRes.body().asString()));
//
//        //获取cookie
//        String header = loginRes.getHeader("Set-Cookie");
//        String cookieStr = header.split(";")[0];
//        String[] cookieKeyValue = cookieStr.split("=");
//        otoManagerCookieKey = cookieKeyValue[0];
//        otoManagerCookieValue = cookieKeyValue[1];

        otoManagerCookieKey = "otoToken";
        otoManagerCookieValue = "2hdZyc3Wrhbokz5QFVTnXxxteUrg4U3szFLLQhKruh4Q6eZAVEBcYAKcwDfN5vGk9MNkshTkxpyidEtujMzGw5X5EsNfV1h7kn2bzap2P8baGi";

//        network.agentCookies.put(otoManagerCookieKey, otoManagerCookieValue); //存入cookies
//        System.out.println("销售Cookie中key："+ otoManagerCookieKey +" ，values："+ otoManagerCookieValue);
    }

    /**
     * 登录久久保系统（目前账号及登录密码是写死的）
     */
    public static void JJBLogin(){
        Map<String,Object> params = new HashMap<>();
        params.put("userName","adminzc");
        params.put("userPwd","oto88888888");
        Response response = network.postResponse(params,JiuJiuBao_login);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data, network.message(params, BasicConfig.JiuJiuBao_login,"久久保登录失败",response.body().asString()));

        //获取cookie
        String header = response.getHeader("Set-Cookie");
        String cookieStr = header.split(";")[0];
        String[] cookieKeyValue = cookieStr.split("=");
        JJBManagerCookieKey = cookieKeyValue[0];
        JJBManagerCookieValue = cookieKeyValue[1];
        network.agentCookies.put(JJBManagerCookieKey,JJBManagerCookieValue);
        System.out.println("久久保cookie中的key："+JJBManagerCookieKey +"，values："+JJBManagerCookieValue);
    }

}
