package com.oto.cases.otoseller;

import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.sql.KjyLiveNormalDB;
import com.oto.sql.UserSqlFactory;
import com.oto.utils.IdMakeUtil;
import com.oto.utils.NetworkUtils;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import static com.oto.cases.otoseller.Work.phone;
import static com.oto.utils.BaseUtils.*;
import static com.oto.utils.ThreadSleepUtils.sleep;
//手机端

public class Phone implements Authorization {
    private static final NetworkUtils network = NetworkUtils.getInstance();
    private String cust_id;//加密的客户ID
    private String custName;
    private String introduceCustomer_id;
    private String myselfCustomer_id;
    private long productId = 19;
    private int businessId;
    private ArrayList ids;
    private ArrayList<String> interviewIds;
    private Object scanCodeId;
    @BeforeTest
    public void setUp(){
        //登录销售工作台手机端
        otoSellerTku();
        ids = new ArrayList<>();
        interviewIds = new ArrayList<>();
    }

    @Test(description = "查看我的客户",priority = 1)
    public void 查看我的客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_customerList);
        int size = response.jsonPath().getInt("data.myCustomerVos.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.PHONE_customerList,"客户列表为空",response.body().asString()));
    }

    @Test(description = "不可创建重复手机号的客户",priority = 2)
    public void 不可创建重复手机号的客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "重复客户");
        params.put("custPhoneNum", phone);
        params.put("custSource", 1);
        Response response = network.postResponse(params, BasicConfig.PHONE_customerSave);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.PHONE_customerSave,"手机号重复创建客户成功",response.body().asString()));
    }

    @Test(description = "创建缘故客户",priority = 3)
    public void 创建缘故客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化缘故客户");
        params.put("custPhoneNum", "13410000001");
        params.put("custSource", 1);
        Response response = network.postResponse(params, BasicConfig.PHONE_customerSave);
        myselfCustomer_id = response.jsonPath().getString("data");
        Assert.assertNotNull(myselfCustomer_id,network.message(params,BasicConfig.PHONE_customerSave,"创建缘故客户失败",response.body().asString()));
    }

    @Test(description = "创建转介绍客户",priority = 4)
    public void 创建转介绍客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化转介绍客户");
        params.put("custPhoneNum", "13410000002");
        params.put("introducerId", myselfCustomer_id);
        params.put("custSource", 2);
        Response response = network.postResponse(params, BasicConfig.PHONE_customerSave);
        introduceCustomer_id = response.jsonPath().getString("data");
        Assert.assertNotNull(introduceCustomer_id,network.message(params,BasicConfig.PHONE_customerSave,"创建转介绍客户失败",response.body().asString()));
    }

    @Test(description = "姓名搜索客户",priority = 5)
    public void 姓名搜索客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化测试用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_customerList);
        int size = response.jsonPath().getInt("data.myCustomerVos.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.PHONE_customerList,"查找不到该客户",response.body().asString()));

        cust_id = response.jsonPath().getString("data.myCustomerVos[0].id");
        custName = response.jsonPath().getString("data.myCustomerVos[0].custName");
    }

    @Test(description = "姓名模糊关联客户",priority = 6)
    public void 姓名模糊查找客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化");
        Response response = network.getResponse(params, BasicConfig.PHONE_fuzzyList);
        int size = response.jsonPath().getInt("data.myCustomerVos.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.PHONE_fuzzyList,"创建缘故客户失败",response.body().asString()));
    }

    @Test(description = "创建社区面访并关联转介绍和缘故客户",priority = 7)
    public void 创建社区面访并关联转介绍和缘故客户(){
        HashMap<String,Object> params = new HashMap<>();
        ids = new ArrayList();
        ids.add(cust_id);
        ids.add(myselfCustomer_id);
        ids.add(introduceCustomer_id);
        params.put("custIds", ids);
        params.put("interviewType", 2);
        params.put("appointmentTime", System.currentTimeMillis()+3600000);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewSave);
        int size = response.jsonPath().getJsonObject("data.size()");
        Assert.assertEquals(size,3,network.message(params,BasicConfig.PHONE_interviewSave,"创建普通面访失败",response.body().asString()));
        interviewIds.add(response.jsonPath().getString("data[0]"));
        interviewIds.add(response.jsonPath().getString("data[1]"));
        interviewIds.add(response.jsonPath().getString("data[2]"));
    }

    @Test(description = "查询面访二维码",priority = 8)
    public void 查询面访二维码(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("ids", interviewIds.get(0)+","+interviewIds.get(1)+","+interviewIds.get(2));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewCode);
        int size = response.jsonPath().getInt("data.size()");
        int statusCount = response.jsonPath().getInt("data.findAll{it.interviewStatus == 1}.size()");
        Assert.assertEquals(size,3,network.message(params,BasicConfig.PHONE_interviewCode,"面访码数量错误",response.body().asString()));
        Assert.assertEquals(statusCount,3,network.message(params,BasicConfig.PHONE_interviewCode,"面访码数量错误",response.body().asString()));
    }

    @Test(description = "上传地理位置",priority = 9)
    public void 上传地理位置(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("latitude", 30.287816);
        params.put("longitude", 120.111991);
        params.put("id", interviewIds.get(0));
        Response response = network.postResponse(params, BasicConfig.PHONE_address);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.PHONE_customerSave,"上传地理位置失败",response.body().asString()));
    }

    @Test(description = "销售查询面访状态",priority = 10)
    public void 销售查询面访状态() {
        sleep(1000);

        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewStatus);
        int interviewStatus = response.jsonPath().getInt("data.interviewStatus");
        Assert.assertEquals(interviewStatus,1,network.message(params,BasicConfig.PHONE_interviewStatus,"面访状态错误：非未授权",response.body().asString()));
    }

    @Test(description = "已存在未结束的普通面访后创建普通面访失败",priority = 11)
    public void 已存在未结束的社区面访后创建社区面访失败(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custIds", ids);
        params.put("interviewType", 2);
        params.put("appointmentTime", System.currentTimeMillis()+3600000);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewSave);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.PHONE_interviewSave,"存在未结束普通面访时创建普通面访成功",response.body().asString()));
    }

    @Test(description = "发起面访时查询面访详情",priority = 12)
    public void 发起面访时查询面访详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("interviewType", 2);
        Response response = network.getResponse(params, BasicConfig.PHONE_appointmentDetail);
        String customerName = response.jsonPath().getString("data.custName");
        String id = response.jsonPath().getString("data.id");
        Assert.assertEquals(customerName,custName,network.message(params,BasicConfig.PHONE_appointmentDetail,"查询面访详情的客户姓名错误",response.body().asString()));
        Assert.assertEquals(id, interviewIds.get(0),network.message(params,BasicConfig.PHONE_appointmentDetail,"查询面访详情的id错误",response.body().asString()));
    }

    @Test(description = "修改面访时查询面访详情",priority = 13)
    public void 修改面访时查询面访详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewDetail);
        String customerName = response.jsonPath().getString("data.custName");
        Assert.assertEquals(customerName,custName,network.message(params,BasicConfig.PHONE_interviewDetail,"查询面访详情的客户姓名错误",response.body().asString()));
    }

    @Test(description = "修改面访时间",priority = 14)
    public void 修改面访时间(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        params.put("appointmentTime", System.currentTimeMillis()+7200000);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewUpdate);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.PHONE_interviewUpdate,"修改社区时间失败",response.body().asString()));
    }

    @Test(description = "授权失败",priority = 15)
    public void 授权失败() throws SQLException {
        agentTku();

        Map<String, Object> result = KjyLiveNormalDB.getInstance().findSimpleResult(UserSqlFactory.selectCodeIdByCustomerId, IdMakeUtil.decodingId(cust_id));
        scanCodeId = result.get("scan_code_id");

        HashMap<String,Object> params = new HashMap<>();
        params.put("scanCodeId", IdMakeUtil.encodingId((Long) scanCodeId));
        params.put("scanCodeType", 1048);
        Response response = network.postResponse(params, BasicConfig.PHONE_fail);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.PHONE_fail,"授权失败接口错误",response.body().asString()));
    }

    @Test(description = "销售查询面访状态更新为授权失败",priority = 16)
    public void 销售查询面访状态更新为授权失败() {
        sleep(1000);
        otoSellerTku();

        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewStatus);
        int interviewStatus = response.jsonPath().getInt("data.interviewStatus");
        Assert.assertEquals(interviewStatus,5,network.message(params,BasicConfig.PHONE_interviewStatus,"面访状态错误：非未授权",response.body().asString()));
    }

    @Test(description = "非面对面扫码并评价",priority = 17)
    public void 扫码绑定微信用户(){
        agentTku();
        scanCode(IdMakeUtil.encodingId((Long) scanCodeId),1048);
    }

    @Test(description = "销售查询面访状态更新为待上传",priority = 18)
    public void 销售查询面访状态更新为待上传() {
        sleep(2000);
        otoSellerTku();

        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewStatus);
        int interviewStatus = response.jsonPath().getInt("data.interviewStatus");
        Assert.assertEquals(interviewStatus,3,network.message(params,BasicConfig.PHONE_interviewStatus,"扫码评价失败",response.body().asString()));
    }

    @Test(description = "查询面访异常类型",priority = 19)
    public void 查询面访异常类型(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_getUnusualTypes);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2,network.message(params,BasicConfig.PHONE_getUnusualTypes,"面访异常错误",response.body().asString()));
    }

    @Test(description = "查询面访回填信息",priority = 20)
    public void 查询面访回填信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_custExtDetail);
        String interviewAddress = response.jsonPath().getString("data.interviewAddress");
        int commitPlanFlag = response.jsonPath().getInt("data.commitPlanFlag");
        Assert.assertNotNull(interviewAddress,network.message(params,BasicConfig.PHONE_custExtDetail,"面访列表为空",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,0,network.message(params,BasicConfig.PHONE_custExtDetail,"面访列表为空",response.body().asString()));
    }

    @Test(description = "上传社区面访详情",priority = 21)
    public void 上传社区面访详情(){
        HashMap<String,Object> params = new HashMap<>();
        ArrayList unusualTypes = new ArrayList();
        unusualTypes.add(1);
        unusualTypes.add(2);
        ArrayList unusualProofs = new ArrayList();
        unusualProofs.add("https://yun.dui88.com/kjy/image/20220506/ecf1d585e2e040ad97ec7996ce5bf2a3.jpg");
        unusualProofs.add("https://yun.dui88.com/kjy/image/20220505/62cc0df86ed7430ea67d5015ee3fcc2b.jpg");
        params.put("id", interviewIds.get(0));
        params.put("interviewRemark", "第一次社区参观");
        params.put("coreMaker", 2);
        params.put("followWeight", 1);
        params.put("commitPlanFlag", 0);
        params.put("commitInsure", 0);
        params.put("commitCustStatus", 2);
        params.put("isNormal", false);
        params.put("insureReason", "未确认投保要素说明");
        params.put("unusualTypes", unusualTypes);
        params.put("unusualExplain", "手机号不一致且非面对面扫码的情况说明");
        params.put("unusualProofs", unusualProofs);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewFeedback);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(params,BasicConfig.PHONE_interviewFeedback,"上传面访失败",response.body().asString()));
    }

    @Test(description = "查看面访详情",priority = 22)
    public void 查看面访详情(){
        sleep(1000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_feedbackDetail);
        int followWeight = response.jsonPath().getInt("data.followWeight");
        int commitPlanFlag = response.jsonPath().getInt("data.commitPlanFlag");
        int size = response.jsonPath().getInt("data.unusualTypes.size()");
        String unusualExplain = response.jsonPath().getString("data.unusualExplain");
        Assert.assertEquals(followWeight,1,network.message(params,BasicConfig.PHONE_feedbackDetail,"关注度显示错误",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,0,network.message(params,BasicConfig.PHONE_feedbackDetail,"是否提交计划书显示错误",response.body().asString()));
        Assert.assertEquals(size,2,network.message(params,BasicConfig.PHONE_feedbackDetail,"面访异常类型显示错误",response.body().asString()));
        Assert.assertEquals(unusualExplain,"手机号不一致且非面对面扫码的情况说明",network.message(params,BasicConfig.PHONE_feedbackDetail,"异常情况说明显示错误",response.body().asString()));
    }

    @Test(description = "查看我的面访状态更新为审批中",priority = 23)
    public void 查看我的面访状态更新为审批中(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化测试用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewList);
        int size = response.jsonPath().getInt("data.customerInterviewVos.size()");
        int interviewStatus = response.jsonPath().getInt("data.customerInterviewVos.find{it.id == '"+  interviewIds.get(0) +"'}.interviewStatus");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.PHONE_interviewList,"面访列表为空",response.body().asString()));
        Assert.assertEquals(interviewStatus,6,network.message(params,BasicConfig.PHONE_interviewList,"面访状态错误",response.body().asString()));
    }

    @Test(description = "总监查看审批列表",priority = 24)
    public void 总监查看审批列表(){
        otoLeaderAuth();

        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        params.put("auditState",1);
        Response response =network.getResponse(params,BasicConfig.WORK_interviewAuditList);
        int size = response.jsonPath().getInt("data.list.size()");
        int unusualTypes = response.jsonPath().getInt("data.list[0].unusualTypes.size()");
        String sellerName = response.jsonPath().getString("data.list[0].sellerName");
        Assert.assertTrue(size>0,network.message(BasicConfig.WORK_interviewAuditList,"待审批列表为空",response.body().asString()));
        Assert.assertEquals(unusualTypes,2,network.message(BasicConfig.WORK_interviewAuditList,"面访异常错误",response.body().asString()));
        Assert.assertEquals(sellerName,"勿动-自动化测试销售",network.message(BasicConfig.WORK_interviewAuditList,"销售名称错误",response.body().asString()));
        businessId = response.jsonPath().getInt("data.list[0].businessId");
    }

    @Test(description = "总监驳回审批",priority = 25)
    public void 总监驳回审批(){
        otoLeaderAuth();

        HashMap<String,Object> params = new HashMap<>();
        params.put("businessId",businessId);
        Response response =network.postResponse(params,BasicConfig.WORK_interviewAuditReject);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_interviewAuditReject,"驳回审批失败",response.body().asString()));
    }

    @Test(description = "查询客户信息未更新",priority = 26)
    public void 查询客户信息未更新(){
        otosellerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", IdMakeUtil.decodingId(cust_id));
        Response response = network.getResponse(params,BasicConfig.WORK_detail);
        int custFlow = response.jsonPath().getInt("data.custInfo.custFlow");
        int commitPlanFlag = response.jsonPath().getInt("data.custInfo.commitPlanFlag");
        Assert.assertEquals(custFlow,1,network.message(params,BasicConfig.WORK_detail,"新客户流程组状态错误非1",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,0,network.message(params,BasicConfig.WORK_detail,"新客户投保要素确认状态错误非0",response.body().asString()));
    }

    @Test(description = "查看我的面访状态更新为已失效",priority = 27)
    public void 查看我的面访状态更新为已失效(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化测试用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewList);
        int interviewStatus = response.jsonPath().getInt("data.customerInterviewVos.find{it.id == '"+  interviewIds.get(0) +"'}.interviewStatus");
        Assert.assertEquals(interviewStatus,7,network.message(params,BasicConfig.PHONE_interviewList,"面访状态错误",response.body().asString()));
    }

    @Test(description = "取消面访",priority = 28)
    public void 取消面访(){
        interviewCancle(interviewIds.get(1));
        interviewCancle(interviewIds.get(2));
    }

    @Test(description = "客户再次创建面访并扫码评价",priority = 29)
    public void 客户再次创建面访并扫码评价() throws SQLException {
        otoSellerTku();
        HashMap<String,Object> params = new HashMap<>();
        ids = new ArrayList();
        ids.add(cust_id);
        params.put("custIds", ids);
        params.put("interviewType", 2);
        params.put("appointmentTime", System.currentTimeMillis()+3600000);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewSave);
        interviewIds.clear();
        interviewIds.add(response.jsonPath().getString("data[0]"));

        agentTku();
        Map<String, Object> result = KjyLiveNormalDB.getInstance().findSimpleResult(UserSqlFactory.selectCodeIdByCustomerId, IdMakeUtil.decodingId(cust_id));
        scanCodeId = result.get("scan_code_id");
        System.out.println(scanCodeId);
        scanCode(IdMakeUtil.encodingId((Long) scanCodeId),1047);
    }

    @Test(description = "销售上传社区面访",priority = 30)
    public void 销售上传社区面访(){
        otoSellerTku();
        HashMap<String,Object> params = new HashMap<>();
        ArrayList unusualTypes = new ArrayList();
        unusualTypes.add(2);
        ArrayList unusualProofs = new ArrayList();
        unusualProofs.add("https://yun.dui88.com/kjy/image/20220506/ecf1d585e2e040ad97ec7996ce5bf2a3.jpg");
        params.put("id", interviewIds.get(0));
        params.put("interviewRemark", "第一次社区参观");
        params.put("coreMaker", 2);
        params.put("followWeight", 1);
        params.put("commitPlanFlag", 0);
        params.put("isNormal", false);
        params.put("unusualTypes", unusualTypes);
        params.put("unusualExplain", "手机号不一致的情况说明");
        params.put("unusualProofs", unusualProofs);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewFeedback);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(params,BasicConfig.PHONE_interviewFeedback,"上传面访失败",response.body().asString()));
    }

    @Test(description = "总监通过审批",priority = 31)
    public void 总监通过审批(){
        otoLeaderAuth();

        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        params.put("auditState",1);
        Response response =network.getResponse(params,BasicConfig.WORK_interviewAuditList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.WORK_interviewAuditList,"待审批列表为空",response.body().asString()));
        businessId = response.jsonPath().getInt("data.list[0].businessId");

        params.clear();
        params.put("businessId",businessId);
        response =network.postResponse(params,BasicConfig.WORK_interviewAuditPass);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_interviewAuditPass,"通过审批失败",response.body().asString()));
    }

    @Test(description = "查询客户信息已更新",priority = 32)
    public void 查询客户信息已更新(){
        otosellerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", IdMakeUtil.decodingId(cust_id));
        Response response = network.getResponse(params,BasicConfig.WORK_detail);
        int custFlow = response.jsonPath().getInt("data.custInfo.custFlow");
        int commitPlanFlag = response.jsonPath().getInt("data.custInfo.commitPlanFlag");
        Assert.assertEquals(custFlow,2,network.message(params,BasicConfig.WORK_detail,"新客户流程组状态错误非1",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,0,network.message(params,BasicConfig.WORK_detail,"新客户投保要素确认状态错误非0",response.body().asString()));
    }

    @Test(description = "查看我的面访状态更新为已完成",priority =33)
    public void 查看我的面访状态更新为已完成(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化测试用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewList);
        int interviewStatus = response.jsonPath().getInt("data.customerInterviewVos.find{it.id == '"+  interviewIds.get(0) +"'}.interviewStatus");
        Assert.assertEquals(interviewStatus,4,network.message(params,BasicConfig.PHONE_interviewList,"面访状态错误",response.body().asString()));
    }

    @Test(description = "客户流程组_表格总览",priority = 34)
    public void 客户流程组_表格总览(){
        otosellerAuth();
        Response response = network.getResponse(BasicConfig.WORK_staticChart);
        int ondStep = response.jsonPath().getInt("data[0].custNum");
        int twoStep = response.jsonPath().getInt("data[1].custNum");
        Assert.assertEquals(ondStep,Work.chart.get("ondStep")+1,network.message(BasicConfig.WORK_staticChart,"创建的转介绍和缘故客户的流程组非1",response.body().asString()));
        Assert.assertEquals(twoStep,Work.chart.get("twoStep")+1,network.message(BasicConfig.WORK_staticChart,"客户社区参观后未提交计划书流程组状态未变为2",response.body().asString()));
    }

    @Test(description = "创建普通面访",priority = 35)
    public void 创建普通面访(){
        otoSellerTku();
        HashMap<String,Object> params = new HashMap<>();
        ids = new ArrayList();
        ids.add(cust_id);
        params.put("custIds", ids);
        params.put("interviewType", 1);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewSave);
        int size = response.jsonPath().getJsonObject("data.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.PHONE_interviewSave,"创建普通面访失败",response.body().asString()));
        interviewIds.clear();
        interviewIds.add(response.jsonPath().getString("data[0]"));
    }

    @Test(description = "客户完成普通面访并扫码",priority = 36)
    public void 客户完成普通面访并扫码() throws SQLException {
        agentTku();
        Map<String, Object> result = KjyLiveNormalDB.getInstance().findSimpleResult(UserSqlFactory.selectCodeIdByCustomerId, IdMakeUtil.decodingId(cust_id));
        scanCodeId = result.get("scan_code_id");
        System.out.println(scanCodeId);
        scanCode(IdMakeUtil.encodingId((Long) scanCodeId),1047);
    }


    @Test(description = "二次正常扫码面访异常类型为空",priority = 37)
    public void 二次正常扫码面访异常类型为空(){
        otoSellerTku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_getUnusualTypes);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,0,network.message(params,BasicConfig.PHONE_getUnusualTypes,"面访异常错误",response.body().asString()));
    }

    @Test(description = "查看公司产品列表",priority = 38)
    public void 查看公司产品列表() {
        String encodeProductId = IdMakeUtil.encodingId(productId);
        Response response = network.getResponse(BasicConfig.PHONE_listBysellComp);
        int size = response.jsonPath().getInt("data.findAll{it.id == '"+encodeProductId+"'}.size()");
        Assert.assertEquals(size,1,network.message(BasicConfig.PHONE_listBysellComp,"产品列表未包含已上架产品",response.body().asString()));
    }

    @Test(description = "下架公司产品",priority = 39)
    public void 下架公司产品() {
        ssoLogin();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", productId);
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_productUpdateStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_productUpdateStatus,"下架公司产品失败",response.body().asString()));
    }

    @Test(description = "产品下架后公司产品列表不显示",priority = 40)
    public void 产品下架后公司产品列表不显示() {
        otoSellerTku();

        String encodeProductId = IdMakeUtil.encodingId(productId);
        Response response = network.postResponse(BasicConfig.PHONE_listBysellComp);
        int size = response.jsonPath().getJsonObject("data.findAll{it.id == "+encodeProductId+"}.size()");
        Assert.assertEquals(size,0,network.message(BasicConfig.PHONE_listBysellComp,"产品列表未包含已上架产品",response.body().asString()));

        HashMap<String,Object> params = new HashMap<>();
        params.put("id", productId);
        response = network.postResponse(params, BasicConfig.MANAGER_oto_productUpdateStatus);
        boolean data = response.jsonPath().getBoolean("data");
    }

    @Test(description = "上传普通面访详情",priority = 41)
    public void 上传普通面访详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        params.put("interviewRemark", "第一次普通参观");
        params.put("coreMaker", 1);
        params.put("followWeight", 2);
        params.put("commitPlanFlag", 1);
        params.put("commitCustStatus", 1);
        params.put("commitInsure", 1);
        params.put("productId", IdMakeUtil.encodingId(productId));
        params.put("insApplicant", 1);
        params.put("insByApplicant", 1);
        params.put("insPeriod", 3);
        params.put("insMoney", 3);
        params.put("isNormal", true);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewFeedback);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(params,BasicConfig.WORK_delCust,"上传面访失败",response.body().asString()));
    }

    @Test(description = "客户流程组_表格总览更新为当下成交",priority = 42)
    public void 客户流程组_表格总览更新为当下成交(){
        otosellerAuth();
        sleep(2000);
        Response response = network.getResponse(BasicConfig.WORK_staticChart);
        int fourStep = response.jsonPath().getInt("data[3].custNum");
        Assert.assertEquals(fourStep,Work.chart.get("fourStep")+1,network.message(BasicConfig.WORK_staticChart,"客户社区参观后已确认投保要素流程组状态未变为4",response.body().asString()));

        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", IdMakeUtil.decodingId(cust_id));
        response = network.getResponse(params,BasicConfig.WORK_detail);
        int custFlow = response.jsonPath().getInt("data.custInfo.custFlow");
        int commitInsure = response.jsonPath().getInt("data.custInfo.commitInsure");
        int commitPlanFlag = response.jsonPath().getInt("data.custInfo.commitPlanFlag");
        Assert.assertEquals(custFlow,4,network.message(params,BasicConfig.WORK_detail,"新客户流程组状态错误非0",response.body().asString()));
        Assert.assertEquals(commitInsure,1,network.message(params,BasicConfig.WORK_detail,"新客户提交计划书状态错误非0",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,1,network.message(params,BasicConfig.WORK_detail,"新客户投保要素确认状态错误非0",response.body().asString()));
    }

    @Test(description = "修改客户基础信息",priority = 43)
    public void 修改客户基础信息(){
        HashMap<String,Object> params = new HashMap<>();
        ArrayList<Integer> array = new ArrayList<>();
        params.put("custId", IdMakeUtil.decodingId(cust_id));
        params.put("dealFlag", 1);
        params.put("dealNumber", "ZDHCSBD000001");
        params.put("custName", "自动化测试用户");
        Response response = network.postResponse(params,BasicConfig.WORK_edit);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_edit,"修改客户基础信息失败",response.body().asString()));
    }

    @Test(description = "客户流程组_表格总览更新为已成单",priority = 44)
    public void 客户流程组_表格总览更新为已成单(){
        sleep(2000);
        Response response = network.getResponse(BasicConfig.WORK_staticChart);
        int fiveStep = response.jsonPath().getInt("data[4].custNum");
        Assert.assertEquals(fiveStep,Work.chart.get("fiveStep")+1,network.message(BasicConfig.WORK_staticChart,"修改已成交后流程组状态未变为5",response.body().asString()));

        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", IdMakeUtil.decodingId(cust_id));
        response = network.getResponse(params,BasicConfig.WORK_detail);
        int custFlow = response.jsonPath().getInt("data.custInfo.custFlow");
        int dealFlag = response.jsonPath().getInt("data.custInfo.dealFlag");
        String dealNumber = response.jsonPath().getString("data.custInfo.dealNumber");
        Assert.assertEquals(custFlow,5,network.message(params,BasicConfig.WORK_detail,"新客户流程组状态错误非0",response.body().asString()));
        Assert.assertEquals(dealFlag,1,network.message(params,BasicConfig.WORK_detail,"新客户提交计划书状态错误非0",response.body().asString()));
        Assert.assertEquals(dealNumber,"ZDHCSBD000001",network.message(params,BasicConfig.WORK_detail,"新客户投保要素确认状态错误非0",response.body().asString()));
    }

    @Test(description = "销售任务_销售完成任务",priority = 45)
    public void 销售任务_销售完成任务(){
        //销售完成面访，跟进时间更新，联系新客户任务完成
        HashMap<String,Object> params = new HashMap<>();
        params.put("taskConfId",4); //任务配置id，4:联系未跟进的客户，5:复拨未接通的客户，6:超过N天未跟进的客户
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response = network.getResponse(params,BasicConfig.WORK_taskDetailsList);
        int finishCustNum = response.jsonPath().getInt("data.finishCustNum");
        Assert.assertTrue(finishCustNum>0,network.message(params,BasicConfig.WORK_taskDetailsList,"已完成数量记录错误",response.body().asString()));
    }

    @Test(description = "查看我的预约列表",priority = 46)
    public void 查看我的预约列表(){
        agent2Tku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response =network.getResponse(params,BasicConfig.PHONE_getReservationList);
        int bookingStatus = response.jsonPath().getInt("data[0].bookingStatus");
        Assert.assertEquals(bookingStatus,1,network.message(BasicConfig.PHONE_getReservationList,"订单状态未更新为已参观",response.body().asString()));
    }

    @Test(description = "删除客户",priority = 79)
    public void 删除客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", IdMakeUtil.decodingId(cust_id));
        Response response = network.postResponse(params,BasicConfig.WORK_delCust);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_delCust,"删除客户失败",response.body().asString()));

        params.put("custId", IdMakeUtil.decodingId(introduceCustomer_id));
        response = network.postResponse(params,BasicConfig.WORK_delCust);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_delCust,"删除客户失败",response.body().asString()));

        params.put("custId", IdMakeUtil.decodingId(myselfCustomer_id));
        response = network.postResponse(params,BasicConfig.WORK_delCust);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_delCust,"删除客户失败",response.body().asString()));
    }

    @Test(description = "删除客户填写的表单记录",priority = 80)
    public void 删除客户填写的表单记录(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("phoneNum", phone);
        Response response = network.postResponse(params,BasicConfig.WORK_delPubFormRecord);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_delPubFormRecord,"删除客户表单记录失败",response.body().asString()));
    }

    @Test(description = "退出登录",priority = 81)
    public void 退出登录(){
        Response response = network.postResponse(BasicConfig.WORK_logout);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.WORK_logout,"退出登录失败",response.body().asString()));
    }

    public void scanCode(String scanCodeId,int scanCodeType) {
        HashMap<String,Object> params = new HashMap<>();
        params.put("scanCodeId", scanCodeId);
        params.put("scanCodeType", scanCodeType);
        Response response = network.postResponse(params, BasicConfig.PHONE_bindWxUser);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.PHONE_bindWxUser,"扫码绑定失败",response.body().asString()));
    }

    public void interviewCancle(String interviewId){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewId);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewCancel);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_delCust,"取消面访失败",response.body().asString()));
    }
}
