package com.oto.cases.admin;
import com.oto.utils.NetworkUtils;

import static com.oto.config.BasicConfig.*;
import static com.oto.utils.BaseUtils.*;


/**
 * 管理员授权
 * @author 吉吉，ID：907
 */
public interface Authorization {

    NetworkUtils network = NetworkUtils.getInstance();

    //oto销售工作台-销售
    default void otosellerAuth() {
        network.agentCookies.put(otoSellerCookieKey, otoSellerCookieValue);
    }

    //oto销售工作台-总监
    default void otoLeaderAuth() {
        network.agentCookies.put(otoLeaderCookieKey, otoLeaderCookieValue);
    }
    //oto销售工作台手机端-销售
    default void otoSellerTku() {
        network.agentCookies.put("tku", OTO_TKU);
    }

    //oto销售工作台-管理员
    default void otoManagerAuth() {
        network.agentCookies.put(otoManagerCookieKey, otoManagerCookieValue);
    }

    //久久保管理员-正常权限模式
    default void jjbManagerAuth() {network.agentCookies.put(JJBManagerCookieKey,JJBManagerCookieValue);}


    /**
     * 集客助手相关授权
     */
    //代理人吉吉 sid：2991
    default void agentTku() {
        network.agentCookies.put(TKU_COOKIE_NAME, AGENT_TKU);
        System.out.println("代理人吉吉tku：" + AGENT_TKU);

    }

    //代理人xxx
    default void agent2Tku() {
        network.agentCookies.put(TKU_COOKIE_NAME, AGENT2_TKU);
        System.out.println("代理人梦晨tku：" + AGENT2_TKU);

    }

}
