package com.oto.cases.otoseller;

import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;

import static com.oto.cases.otoseller.Manager.*;
import static com.oto.cases.otoseller.Work.assignSeller;
import static com.oto.config.BasicConfig.*;
import static com.oto.utils.ThreadSleepUtils.sleep;

public class Depts implements Authorization {

    private ArrayList<Integer> custids;
    private int autoDeptId;//自动化销售部的部门id
    private int autoTeamId;//自动化团队的部门id

    @BeforeTest
    public void setUp(){
        otoManagerAuth();
        custids = new ArrayList<Integer>();
        custids.add(cust_id+3);
        custids.add(cust_id+4);
    }

    @Test(description = "新建部门",priority = 1)
    public void 新建部门(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("deptName", "勿动-自动化团队");
        params.put("parentId", 30);
        Response response = network.postResponse(params, BasicConfig.WORK_deptSave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_deptSave,"新增部门失败",response.body().asString()));
    }

    @Test(description = "查询部门树",priority = 2)
    public void 查询部门树(){
        Response response = network.getResponse(BasicConfig.WORK_deptList);
        autoTeamId = response.jsonPath().getInt("data[0].children.find{it.id == 29}.children[0].children[0].id");
        autoDeptId = response.jsonPath().getInt("data[0].children.find{it.id == 29}.children[0].id");
        Assert.assertNotNull(autoDeptId,network.message(BasicConfig.WORK_deptList,"自动化销售部的部门id为空",response.body().asString()));
        Assert.assertNotNull(autoTeamId,network.message(BasicConfig.WORK_deptList,"自动化团队的部门id为空",response.body().asString()));
    }

    @Test(description = "部门存在子部门不可被删除",priority = 3)
    public void 部门存在子部门不可被删除(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", autoDeptId);
        Response response = network.postResponse(params, BasicConfig.WORK_deptDel);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_deptDel,"部门存在子部门删除成功",response.body().asString()));
    }

    @Test(description = "批量设置成员部门",priority = 4)
    public void 批量设置成员部门(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("deptIds", new int[]{autoTeamId});
        params.put("sellerIds", new int[]{290,457});
        Response response = network.postResponse(params, BasicConfig.WORK_batchAddSeller);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_batchAddSeller,"批量设置成员部门失败",response.body().asString()));
    }

    @Test(description = "部门存在成员不可被删除",priority = 5)
    public void 部门存在成员不可被删除(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", autoTeamId);
        Response response = network.postResponse(params, BasicConfig.WORK_deptDel);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_deptDel,"部门存在成员删除成功",response.body().asString()));
    }

    @Test(description = "修改部门名称",priority = 6)
    public void 修改部门名称(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("deptName", "勿动-自动化测试团队");
        params.put("id", autoTeamId);
        Response response = network.postResponse(params, BasicConfig.WORK_deptUpdate);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_deptUpdate,"修改部门名称失败",response.body().asString()));
    }

    @Test(description = "查看部门成员",priority = 7)
    public void 查看部门成员(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", autoTeamId);
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.postResponse(params, BasicConfig.WORK_listSellerByDeptId);
        String deptName = response.jsonPath().getString("data.deptName");
        int size = response.jsonPath().getInt("data.page.list.size()");
        Assert.assertEquals(deptName,"勿动-自动化测试团队",network.message(params,BasicConfig.WORK_listSellerByDeptId,"修改部门名称失败",response.body().asString()));
        Assert.assertEquals(size,2,network.message(params,BasicConfig.WORK_listSellerByDeptId,"批量设置成员部门失败",response.body().asString()));

        //还原
        params.clear();
        params.put("deptIds", new int[]{30});
        params.put("sellerIds", new int[]{290,457});
        response = network.postResponse(params, BasicConfig.WORK_batchAddSeller);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_batchAddSeller,"批量设置成员部门失败",response.body().asString()));
    }

    @Test(description = "部门无子部门和成员删除成功",priority = 8)
    public void 部门无子部门和成员删除成功(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", autoTeamId);
        Response response = network.postResponse(params, BasicConfig.WORK_deptDel);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_deptDel,"部门无子部门和成员删除失败",response.body().asString()));
    }


    @Test(description = "搜索角色列表",priority = 9)
    public void 搜索角色列表(){
        //邀约角色成功搜索到邀约成员
        searchRole("勿动-自动化测试邀约",1,1,"crm");
        //邀约角色不可搜索到销售成员
        searchRole("勿动-自动化测试带看",1,0,"crm");
        //邀约角色不可搜索到专家成员
        searchRole("勿动-自动化测试专家",1,0,"crm");

        //销售角色不可搜索到邀约成员
        searchRole("勿动-自动化测试邀约",2,0,"crm");
        //销售角色成功搜索到销售成员
        searchRole("勿动-自动化测试带看",2,1,"crm");
        //销售角色不可搜索到专家成员
        searchRole("勿动-自动化测试专家",2,0,"crm");

        //专家角色不可搜索到邀约成员
        searchRole("勿动-自动化测试邀约",3,0,"crm");
        //专家角色不可搜索到销售成员
        searchRole("勿动-自动化测试带看",3,0,"crm");
        //专家角色成功搜索到专家成员
        searchRole("勿动-自动化测试专家",3,1,"crm");

        //搜索不区分组织架构
        searchRole("专家",3,5,"crm");

    }

    @Test(description = "查看所有产品组列表",priority = 10)
    public void 查看所有公司列表(){
        Response response = network.getResponse(BasicConfig.WORK_MNG_companyAll);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.WORK_MNG_companyAll,"查看所有公司列表为空",response.body().asString()));
    }

    @Test(description = "修改客户的产品组",priority = 11)
    public void 修改客户产品组(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",custids.get(0));
        params.put("companyIds",new int[]{119,5,6});
        Response response =network.postResponse(params,BasicConfig.WORK_MNG_updateCompany);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_MNG_updateCompany,"修改客户的产品组失败",response.body().asString()));

        params.clear();
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        params.put("phoneNum", "15136361304");
        response = network.getResponse(params,BasicConfig.WORK_MNG_customerList);
        int companySize = response.jsonPath().getInt("data.list[0].companyIds.size()");
        Assert.assertEquals(companySize,3,network.message(params,BasicConfig.WORK_MNG_customerList,"客户的产品组错误",response.body().asString()));
    }

    @Test(description = "通过销售名称查找销售",priority = 12)
    public void 通过销售名称查找销售(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerName", "勿动-自动化测试邀约");
        Response response = network.getResponse(params, BasicConfig.WORK_MNG_searchSeller);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.WORK_MNG_searchSeller,"查找结果为空",response.body().asString()));
    }

    @Test(description = "获取客户来源对应关系列表",priority =13)
    public void 获取客户来源对应关系列表(){
        Response response = network.getResponse(BasicConfig.WORK_MNG_custSourceList);
        String custFromSource = response.jsonPath().getString("data[0].custFromSource");
        String desc = response.jsonPath().getString("data[0].desc");
        Assert.assertEquals(custFromSource,"01_01-01",network.message(BasicConfig.WORK_MNG_custSourceList,"客户来源枚举值错误",response.body().asString()));
        Assert.assertEquals(desc,"投放客户-自建落地页-表单",network.message(BasicConfig.WORK_MNG_custSourceList,"对应的来源描述错误",response.body().asString()));
    }

    @Test(description = "标签列表",priority = 14)
    public void 标签列表(){
        Response response = network.getResponse(BasicConfig.WORK_MNG_tagList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size > 10,network.message(BasicConfig.WORK_MNG_tagList, "标签列表为空", response.body().asString()));
    }

    @Test(description = "批量分配客户",priority = 15)
    public void 批量分配客户(){
        batchAssignSeller(2,SELLER_ID,custids,"crm");  //批量分配给带看
        batchAssignSeller(1,INVITE_ID,custids,"crm");  //批量分配给邀约
        batchAssignSeller(3,EXPERT_ID,custids,"crm");  //批量分配给专家
    }

    @Test(description = "单个分配客户",priority = 16)
    public void 单个分配客户(){
        assignSeller(cust_id,23,false,1,"crm");

        sleep(1000);
        assignSeller(cust_id,INVITE_ID,true,1,"crm");

    }

    @Test(description = "修改客户标签",priority = 17)
    public void 修改客户标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custids.get(0));
        params.put("tagIds", new int[]{22});
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_updateTag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data, network.message(params, BasicConfig.WORK_MNG_updateTag, "修改客户标签失败", response.body().asString()));

    }

    @Test(description = "标记成单",priority = 18)
    public void 标记成单(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custids.get(0));
        params.put("applicantName", "测试投保人");
        params.put("comeIntoFacetime", "2023-03-23");
        params.put("costOption", 3);
        params.put("dealFlag", 1);
        params.put("expertId", EXPERT_ID);
        params.put("guaranteeSlipNo", "ZDHCS202303230001_01");
        params.put("insuranceAmount", "100000000");
        params.put("insureTime", "2023-03-24");
        params.put("insuredName", "测试被保人");
        params.put("productId", 19);
        params.put("sellerId", SELLER_ID);
        params.put("supplierId", 21);
        params.put("writtenPremium", "100000000");
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_updateDealFlag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data, network.message(params, BasicConfig.WORK_MNG_updateDealFlag, "标记成单失败", response.body().asString()));

        HashMap<String,Object> selectParams = new HashMap<String,Object>();
        selectParams.put("pageIndex", 1);
        selectParams.put("pageSize", 10);
        selectParams.put("phoneNum", "15136361304");
        response = network.getResponse(selectParams,BasicConfig.WORK_MNG_customerList);
        int tagSize = response.jsonPath().getInt("data.list[0].tagNames.size()");
        int dealFlag = response.jsonPath().getInt("data.list[0].dealFlag");
        String inviteName = response.jsonPath().getString("data.list[0].inviteVo.sellerName");
        String sellerName = response.jsonPath().getString("data.list[0].sellerVo.sellerName");
        String expertName = response.jsonPath().getString("data.list[0].expertVo.sellerName");
        Assert.assertEquals(tagSize,1 ,network.message(selectParams, BasicConfig.WORK_MNG_customerList, "修改客户标签失败", response.body().asString()));
        Assert.assertEquals(dealFlag,1 ,network.message(selectParams, BasicConfig.WORK_MNG_customerList, "标记客户成单失败", response.body().asString()));
        Assert.assertEquals(inviteName,"勿动-自动化测试邀约" ,network.message(selectParams, BasicConfig.WORK_MNG_customerList, "当前跟进邀约错误", response.body().asString()));
        Assert.assertEquals(sellerName,"勿动-自动化测试带看" ,network.message(selectParams, BasicConfig.WORK_MNG_customerList, "当前跟进销售错误", response.body().asString()));
        Assert.assertEquals(expertName,"勿动-自动化测试专家" ,network.message(selectParams, BasicConfig.WORK_MNG_customerList, "当前跟进专家错误", response.body().asString()));
    }

    @Test(description = "批量给客户打标签",priority = 19)
    public void 批量给客户打标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custIds", custids);
        params.put("tagIds", new int[]{20,24});
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_batchUpdateTag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data, network.message(params, BasicConfig.WORK_MNG_batchUpdateTag, "批量修改客户标签失败", response.body().asString()));
    }

    @Test(description = "取消成单",priority = 20)
    public void 取消成单(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custids.get(0));
        params.put("dealFlag", 0);
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_cancelDealFlag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data, network.message(params, BasicConfig.WORK_MNG_cancelDealFlag, "取消成单失败", response.body().asString()));

        HashMap<String,Object> selectParams = new HashMap<String,Object>();
        selectParams.put("pageIndex", 1);
        selectParams.put("pageSize", 10);
        selectParams.put("phoneNum", "15136361304");
        response = network.getResponse(selectParams,BasicConfig.WORK_MNG_customerList);
        int tagSize = response.jsonPath().getInt("data.list[0].tagNames.size()");
        int dealFlag = response.jsonPath().getInt("data.list[0].dealFlag");
        Assert.assertEquals(tagSize,3 ,network.message(selectParams, BasicConfig.WORK_MNG_customerList, "批量打客户标签失败", response.body().asString()));
        Assert.assertEquals(dealFlag,0 ,network.message(selectParams, BasicConfig.WORK_MNG_customerList, "取消客户成单失败", response.body().asString()));
    }

    @Test(description = "跟进人筛选客户",priority = 21)
    public void 跟进人筛选客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        params.put("otoSidList", 42);
        Response response = network.getResponse(params, BasicConfig.WORK_MNG_customerList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size, 6,network.message(params, BasicConfig.WORK_MNG_customerList, "邀约人筛选结果错误", response.body().asString()));

        params.put("otoSidList", 284);
        response = network.getResponse(params, BasicConfig.WORK_MNG_customerList);
        size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size, 4,network.message(params, BasicConfig.WORK_MNG_customerList, "专家筛选结果错误", response.body().asString()));

        params.put("otoSidList", 290);
        response = network.getResponse(params, BasicConfig.WORK_MNG_customerList);
        size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size, 5,network.message(params, BasicConfig.WORK_MNG_customerList, "带看人筛选结果错误", response.body().asString()));
    }

    @Test(description = "查询可导入的客户来源列表",priority = 21)
    public void 查询可导入的客户来源列表(){
        Response response =network.getResponse(BasicConfig.WORK_MNG_getCustSourceEnum);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,3 ,network.message(BasicConfig.WORK_MNG_getCustSourceEnum,"查看可导入的客户来源列表",response.body().asString()));
    }

    @Test(description = "导入客户文件并成功",priority = 22)
    public void 导入客户文件(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("companyIds", new int[]{5});
        params.put("source", 1);
        params.put("fileName", "自动化导入客户.xlsx");
        params.put("excelUrl", "https://yun.dui88.com/kjy/media/file/20221114/1499deb6eb5222f02ab88facaa0db316.xlsx");
        Response response =network.postResponse(params,BasicConfig.WORK_MNG_importOtoCustomer);
        int result = response.jsonPath().getInt("data");
        Assert.assertNotNull(result,network.message(params,BasicConfig.WORK_MNG_importOtoCustomer,"启动导入客户程序失败",response.body().asString()));

        params.clear();
        boolean succecss = false;
        params.put("taskId",result);
        for (int i = 0;i<10;i++){
            sleep(1000);
            response =network.getResponse(params,BasicConfig.WORK_MNG_importResult);
            boolean hasFinish = response.jsonPath().getBoolean("data.hasFinish");
            if(hasFinish) {
                String failureExcelUrl = response.jsonPath().getString("data.failureExcelUrl");
                int successCount = response.jsonPath().getInt("data.successCount");
                Assert.assertNotNull(failureExcelUrl, network.message(params, BasicConfig.WORK_MNG_importResult, "失败原因链接不为空", response.body().asString()));
                Assert.assertEquals(successCount, 1,network.message(params, BasicConfig.WORK_MNG_importResult, "导入成功数量不为1", response.body().asString()));
                succecss = true;
                break;
            }
        }
        Assert.assertTrue(succecss,network.message(params,BasicConfig.WORK_MNG_importResult,"导入客户结果失败",response.body().asString()));

    }

    @Test(description = "查询导入的文件上传记录",priority = 23)
    public void 查询导入的文件上传记录(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("taskType", 34);
        params.put("pageIndex", 1);
        params.put("pageSize", 5);
        Response response =network.getResponse(params,BasicConfig.WORK_MNG_listForType);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0 ,network.message(BasicConfig.WORK_MNG_listForType,"查看导入文件上传记录为空",response.body().asString()));
    }

    @Test(description = "分页查看销售列表",priority = 24)
    public void 分页查看销售列表(){
        otoLeaderAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize", "20");
        Response response = network.getResponse(params,BasicConfig.WORK_MNG_sellerList);
        int size = response.jsonPath().getInt("data.list.size()");
        int workStatus = response.jsonPath().getInt("data.list.find{it.id == "+ INVITE_ID +"}.workStatus");
        int assignNewCustPermission = response.jsonPath().getInt("data.list.find{it.id == "+ INVITE_ID +"}.assignNewCustPermission");
        int assignRecycleCustPermission = response.jsonPath().getInt("data.list.find{it.id == "+ INVITE_ID +"}.assignRecycleCustPermission");
        int callPermission = response.jsonPath().getInt("data.list.find{it.id == "+ INVITE_ID +"}.callPermission");
        Assert.assertEquals(size,11,network.message(params,BasicConfig.WORK_MNG_sellerList,"工作状态错误",response.body().asString()));
        Assert.assertEquals(workStatus,1,network.message(params,BasicConfig.WORK_MNG_sellerList,"工作状态错误",response.body().asString()));
        Assert.assertEquals(assignNewCustPermission,1,network.message(params,BasicConfig.WORK_MNG_sellerList,"认领新客户及强制分配权限错误",response.body().asString()));
        Assert.assertEquals(assignRecycleCustPermission,1,network.message(params,BasicConfig.WORK_MNG_sellerList,"认领回收客户权限错误",response.body().asString()));
        Assert.assertEquals(callPermission,1,network.message(params,BasicConfig.WORK_MNG_sellerList,"呼叫权限错误",response.body().asString()));
    }

    @Test(description = "查看当前登录人仅可选当前及子部门",priority =25)
    public void 查看当前登录人仅可选当前及子部门(){
        Response response = network.getResponse( BasicConfig.WORK_getDeptList);
        boolean root = response.jsonPath().getBoolean("data[0].disabled");
        boolean brother = response.jsonPath().getBoolean("data[0].children[0].disabled");
        boolean current = response.jsonPath().getBoolean("data[0].children.find{it.id == 29}.disabled");
        boolean children = response.jsonPath().getBoolean("data[0].children.find{it.id == 29}.children[0].disabled");
        Object  grandson= response.jsonPath().getJsonObject("data[0].children.find{it.id == 29}.children[0].children");
        Assert.assertTrue(root,network.message(BasicConfig.WORK_getDeptList,"父部门可选择",response.body().asString()));
        Assert.assertTrue(brother,network.message(BasicConfig.WORK_getDeptList,"兄弟部门可选择",response.body().asString()));
        Assert.assertFalse(current,network.message(BasicConfig.WORK_getDeptList,"当前部门不可选择",response.body().asString()));
        Assert.assertFalse(children,network.message(BasicConfig.WORK_getDeptList,"子部门不可选择",response.body().asString()));
        Assert.assertNull(grandson,network.message(BasicConfig.WORK_getDeptList,"删除的部门未过滤",response.body().asString()));
    }

    @Test(description = "修改销售信息",priority = 26)
    public void 修改销售信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", INVITE_ID);
        params.put("sellerName", "勿动-自动化更新邀约");
        params.put("phoneNumber", "18248405155");
        params.put("roles",new int[]{2,5});
        params.put("callPermission", 0);
        params.put("roleType", 1);
        params.put("sellerStatus", 0);
        params.put("companyIds", new int[]{5});
        params.put("companyNames", new String[]{"勿动-自动化测试公司"});
        params.put("sellerLevel", 2);
        params.put("workStatus", 1);
        params.put("deptIds", new int[]{30});
        params.put("thirdParty",new int[]{1,2});
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_sellerUpdate);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_MNG_sellerUpdate,"修改客户失败",response.body().asString()));

        sleep(1000);
        HashMap<String,Object> selectParam = new HashMap<>();
        selectParam.put("sellerName", "勿动-自动化更新邀约");
        selectParam.put("phoneNumber", "18248405155");
        selectParam.put("pageIndex", "1");
        selectParam.put("pageSize", "10");
        response = network.getResponse(selectParam, BasicConfig.WORK_MNG_sellerList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(selectParam,BasicConfig.WORK_MNG_sellerList,"查找结果为空",response.body().asString()));

        //还原
        params.put("callPermission", 1);
        params.put("sellerStatus", 1);
        params.put("companyIds", new int[]{5});
        params.put("companyNames", new String[]{"勿动-自动化测试公司"});
        params.put("sellerLevel", 1);
        params.put("roles", new int[]{5});
        params.put("deptIds", new int[]{29});
        params.put("thirdParty",new int[]{1});
        params.put("sellerName", "勿动-自动化测试邀约");
        response = network.postResponse(params, BasicConfig.WORK_MNG_sellerUpdate);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_MNG_sellerUpdate,"修改销售失败",response.body().asString()));
    }

    @Test(description = "不可新增同一手机号销售",priority = 27)
    public void 不可新增同一手机号销售(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerName", "勿动-自动化邀约");
        params.put("phoneNumber", "18248405155");
        params.put("callPermission", 1);
        params.put("sellerStatus", 1);
        params.put("companyIds", new int[]{5});
        params.put("roles", new int[]{5});
        params.put("sellerLevel", 1);
        params.put("workStatus", 1);
        params.put("deptIds", new int[]{18});
        params.put("assignNewCustPermission", 1);
        params.put("assignRecycleCustPermission", 1);
        params.put("thirdParty",new int[]{1,2});
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_sellerSave);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_MNG_sellerSave,"新增同一手机号销售成功",response.body().asString()));
    }

    @Test(description = "修改工作状态为请假中",priority = 28)
    public void 修改工作状态为请假中(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerId", LEADER_ID);
        params.put("workStatus", 0);
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_workStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_MNG_workStatus,"修改工作状态为请假中失败",response.body().asString()));
    }


    @Test(description = "成员名下存在某角色中不可移除成员角色",priority = 29)
    public void 成员名下存在某角色中不可移除成员角色(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", INVITE_ID);
        params.put("sellerName", "勿动-自动化更新邀约");
        params.put("phoneNumber", "18248405155");
        params.put("roles",new int[]{2});
        params.put("callPermission", 0);
        params.put("sellerStatus", 0);
        params.put("companyIds", new int[]{5});
        params.put("companyNames", new String[]{"勿动-自动化测试公司"});
        params.put("sellerLevel", 2);
        params.put("workStatus", 1);
        params.put("parentId", 28);
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_sellerUpdate);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_MNG_sellerUpdate,"移除存在跟进的邀约角色成功",response.body().asString()));

        params.put("id", SELLER_ID);
        response = network.postResponse(params, BasicConfig.WORK_MNG_sellerUpdate);
        success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_MNG_sellerUpdate,"移除存在跟进的销售角色成功",response.body().asString()));

        params.put("id", EXPERT_ID);
        response = network.postResponse(params, BasicConfig.WORK_MNG_sellerUpdate);
        success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_MNG_sellerUpdate,"移除存在跟进的专家角色成功",response.body().asString()));

    }

    @Test(description = "查看第三方账号列表",priority = 30)
    public void 查看第三方账号列表(){
        Response response = network.getResponse(BasicConfig.WORK_MNG_accountList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.WORK_MNG_accountList,"查询第三方账号列表为空",response.body().asString()));
    }

    @Test(description = "绑定第三方坐席",priority = 31)
    public void 绑定第三方坐席(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerId", INVITE_ID);
        params.put("accountName", "8060@fhpcs");
        Response response = network.postResponse(params,BasicConfig.WORK_MNG_accountBind);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_MNG_accountBind,"绑定第三方账号失败",response.body().asString()));
    }

    @Test(description = "解绑第三方坐席",priority = 32)
    public void 解绑第三方坐席(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerId", INVITE_ID);
        Response response = network.postResponse(params,BasicConfig.WORK_MNG_accountUnbind);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_MNG_accountUnbind,"解绑坐席账号失败",response.body().asString()));
    }
    @Test(description = "查询设备列表",priority = 33)
    public void 查询设备列表(){
        Response response =network.getResponse(BasicConfig.WORK_MNG_ykList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0 ,network.message(BasicConfig.WORK_MNG_ykList,"查看设备列表为空",response.body().asString()));
    }

    @Test(description = "绑定设备",priority = 34)
    public void 绑定设备(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("accountName", "imei4");
        params.put("sellerId", SELLER_ID);
        Response response =network.postResponse(params,BasicConfig.WORK_MNG_ykBind);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data ,network.message(BasicConfig.WORK_MNG_ykBind,"绑定设备失败",response.body().asString()));
    }

    @Test(description = "解绑设备",priority = 35)
    public void 解绑设备(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerId", SELLER_ID);
        Response response =network.postResponse(params,BasicConfig.WORK_MNG_ykUnbind);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data ,network.message(params,BasicConfig.WORK_MNG_ykUnbind,"解绑设备失败",response.body().asString()));
    }

    @Test(description = "刷新设备绑定情况",priority = 36)
    public void 刷新设备绑定情况(){
        Response response =network.postResponse(BasicConfig.WORK_MNG_syncBind);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data ,network.message(BasicConfig.WORK_MNG_syncBind,"刷新设备失败",response.body().asString()));
    }

    @Test(description = "换绑手机并还原",priority = 37)
    public void 换绑手机并还原(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", INVITE_ID);
        params.put("newPhoneNum", "14783743847");
        Response response = network.postResponse(params,BasicConfig.WORK_MNG_changeSellerPhone);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_MNG_changeSellerPhone,"换绑手机号失败",response.body().asString()));

        params.clear();
        params.put("phoneNumber", "14783743847");
        params.put("pageIndex", "1");
        params.put("pageSize", "20");
        response = network.getResponse(params, BasicConfig.WORK_MNG_sellerList);
        int id = response.jsonPath().getInt("data.list[0].id");
        Assert.assertEquals(id,INVITE_ID,network.message(params,BasicConfig.WORK_MNG_sellerList,"销售列表为空",response.body().asString()));

        params.clear();
        params.put("id", INVITE_ID);
        params.put("newPhoneNum", "18248405155");
        response = network.postResponse(params,BasicConfig.WORK_MNG_changeSellerPhone);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_MNG_changeSellerPhone,"换绑手机号失败",response.body().asString()));
    }

    @Test(description = "查看销售部门详情",priority = 38)
    public void 查看销售部门详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", INVITE_ID);
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_sellerDetail);
        int dept = response.jsonPath().getInt("data.allSidDeptIds[0]");
        Assert.assertEquals(dept,29,network.message(params,BasicConfig.WORK_MNG_sellerDetail,"销售列表为空",response.body().asString()));
    }

    @Test(description = "成员存在跟进入客户不可离职",priority = 40)
    public void 成员存在跟进入客户不可离职(){
        dimissionStatus(INVITE_ID);
        dimissionStatus(SELLER_ID);
        dimissionStatus(EXPERT_ID);
    }

    @Test(description ="获取任务管理列表",priority = 41)
    public void 获取任务管理列表(){
        otoManagerAuth();
        Response response = network.getResponse(BasicConfig.WORK_taskConfList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size==7,network.message(BasicConfig.WORK_taskConfList,"获取任务配置数量错误",response.body().asString()));
    }

    @Test(description = "修改任务配置",priority = 42)
    public void 修改任务配置(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("notCustSource",new String[]{"01"});//不支持的客户来源
        params.put("sellerRole",new int[]{6,7});//支持的角色
        params.put("effectDays",new int[]{1,2});//生效日期
        params.put("id",1);
        params.put("taskUsable",0); //0:任务状态关闭；1:任务状态开启
        Response response = network.postResponse(params,BasicConfig.WORK_taskEdit);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_taskEdit,"修改任务失败",response.body().asString()));

        //获取任务列表验证修改是否成功
        Response listRes = network.getResponse(BasicConfig.WORK_taskConfList);
        int sellerRole = listRes.jsonPath().getInt("data[0].sellerRole.size()");
        int notCustSource = listRes.jsonPath().getInt("data[0].notCustSource.size()");
        Assert.assertEquals(sellerRole,2,network.message(BasicConfig.WORK_taskConfList,"修改任务配置失败",listRes.body().asString()));
        Assert.assertEquals(notCustSource,1,network.message(BasicConfig.WORK_taskConfList,"修改任务配置失败",listRes.body().asString()));

        //恢复默认配置
        params.put("notCustSource",new String[]{});//不支持的客户来源
        params.put("sellerRole",new int[]{5});//支持的角色
        params.put("effectDays",new int[]{0});//生效日期
        params.put("id",1);
        params.put("taskUsable",1); //0:任务状态关闭；1:任务状态开启
        Response acqRes = network.postResponse(params,BasicConfig.WORK_taskEdit);
        boolean acqData = acqRes.jsonPath().getBoolean("data");
        Assert.assertTrue(acqData,network.message(params,BasicConfig.WORK_taskEdit,"修改任务失败",acqRes.body().asString()));
    }

    @Test(description = "客户管理查询问题详情",priority = 43)
    public void 客户管理查询问题详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("customerId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_MNG_qaDetail);;
        int answer = response.jsonPath().getInt("data.list[0].optionTitles.size()");
        Assert.assertTrue(answer>0,network.message(params,BasicConfig.WORK_MNG_qaDetail,"问题详情为空",response.body().asString()));
    }

    @Test(description = "会话查询销售",priority = 44)
    public void 会话查询销售(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerName", "带看");
        Response response = network.getResponse(params,BasicConfig.WORK_conversationGetSellers);;
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2,network.message(params,BasicConfig.WORK_conversationGetSellers,"问题详情为空",response.body().asString()));
    }

    @Test(description = "查询企微会话管理",priority = 45)
    public void 查询企微会话管理(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("beginMsgTime","2022-10-01" );
        params.put("endMsgTime", "2023-01-01");
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.postResponse(params,BasicConfig.WORK_wxList);;
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,0,network.message(params,BasicConfig.WORK_wxList,"问题详情为空",response.body().asString()));
    }

    @Test(description = "查询微信会话管理",priority = 46)
    public void 查询微信会话管理(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("beginMsgTime","2022-10-01" );
        params.put("endMsgTime", "2023-01-01");
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.postResponse(params,BasicConfig.WORK_ykList);;
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,0,network.message(params,BasicConfig.WORK_ykList,"问题详情为空",response.body().asString()));
    }

    @Test(description = "我的审批搜索成员",priority = 47)
    public void 我的审批搜索成员(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerName","自动化" );
        Response response = network.getResponse(params,BasicConfig.WORK_findMySellerByFuzzyName);;
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,11,network.message(params,BasicConfig.WORK_findMySellerByFuzzyName,"问题详情为空",response.body().asString()));
    }

    public void dimissionStatus(int sellreid){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", sellreid);
        params.put("dimissionStatus", 1);
        Response response = network.postResponse(params,BasicConfig.WORK_MNG_switchDimissionStatus);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_MNG_switchDimissionStatus,"名下存在销售但离职成功",response.body().asString()));
    }
}
