package com.oto.cases.otoseller;

import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.sql.KjyLiveNormalDB;
import com.oto.sql.UserSqlFactory;
import com.oto.utils.IdMakeUtil;
import com.oto.utils.NetworkUtils;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.sql.SQLException;
import java.util.*;

import static com.oto.cases.otoseller.CheckTask.*;
import static com.oto.cases.otoseller.Invite.*;
import static com.oto.cases.otoseller.Manager.cust_id;
import static com.oto.cases.otoseller.Work.*;
import static com.oto.utils.BaseUtils.*;
import static com.oto.utils.ThreadSleepUtils.sleep;
//手机端

public class Phone implements Authorization {
    private static final NetworkUtils network = NetworkUtils.getInstance();
    private String customer_id;//加密的客户ID
    private String custName;
    private String introduceCustomer_id;
    private String myselfCustomer_id;
    private long productId = 19;
    private int businessId;
    private ArrayList<String> interviewIds;
    private Object scanCodeId;
    @BeforeTest
    public void setUp(){
        //登录销售工作台手机端
        otoTakerTku();
        interviewIds = new ArrayList<>();
    }

    @Test(description = "不可创建重复手机号的客户",priority = 1)
    public void 不可创建重复手机号的客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "重复客户");
        params.put("custPhoneNum", "151363613101");
        params.put("custActionType", "05");
        Response response = network.postResponse(params, BasicConfig.PHONE_customerSave);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.PHONE_customerSave,"手机号重复创建客户成功",response.body().asString()));
    }

    @Test(description = "创建缘故客户",priority = 2)
    public void 创建缘故客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化缘故客户");
        params.put("custPhoneNum", "15136361308");
        params.put("custActionType", "04");
        Response response = network.postResponse(params, BasicConfig.PHONE_customerSave);
        myselfCustomer_id = response.jsonPath().getString("data");
        Assert.assertNotNull(myselfCustomer_id,network.message(params,BasicConfig.PHONE_customerSave,"创建缘故客户失败",response.body().asString()));
    }

    @Test(description = "创建社区客户",priority = 3)
    public void 创建社区客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化社区客户");
        params.put("custPhoneNum", "15136361309");
        params.put("custActionType", "09");
        Response response = network.postResponse(params, BasicConfig.PHONE_customerSave);
        introduceCustomer_id = response.jsonPath().getString("data");
        Assert.assertNotNull(introduceCustomer_id,network.message(params,BasicConfig.PHONE_customerSave,"创建转介绍客户失败",response.body().asString()));
    }

    @Test(description = "姓名搜索客户",priority = 4)
    public void 姓名搜索客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化激活用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_customerList);
        int size = response.jsonPath().getInt("data.myCustomerVos.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.PHONE_customerList,"查找不到该客户",response.body().asString()));

        customer_id = response.jsonPath().getString("data.myCustomerVos[0].id");
        custName = response.jsonPath().getString("data.myCustomerVos[0].custName");
    }

    @Test(description = "姓名模糊关联客户",priority = 5)
    public void 姓名模糊查找客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化");
        Response response = network.getResponse(params, BasicConfig.PHONE_fuzzyList);
        int size = response.jsonPath().getInt("data.myCustomerVos.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.PHONE_fuzzyList,"创建缘故客户失败",response.body().asString()));
    }
    @Test(description = "关闭见面场景后不可查看场景",priority = 6)
    public void 关闭见面场景后不可查看场景(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", customer_id);
        Response response = network.getResponse(params, BasicConfig.PHONE_listCustInterConf);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2,network.message(params,BasicConfig.PHONE_listCustInterConf,"见面场景列表数量错误",response.body().asString()));

    }

    @Test(description = "打开场景后查看客户对应的见面场景",priority = 7)
    public void 打开场景后查看客户对应的见面场景(){
        otoManagerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id",sceneId);
        params.put("confUsable",1);
        Response response =network.postResponse(params,BasicConfig.WORK_updateStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_updateStatus,"关闭见面场景失败",response.body().asString()));

        params.clear();
        params.put("custId", customer_id);
        response = network.getResponse(params, BasicConfig.PHONE_listCustInterConf);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,3,network.message(params,BasicConfig.PHONE_listCustInterConf,"见面场景列表数量错误",response.body().asString()));
    }

    @Test(description = "创建社区参观的面访",priority = 8)
    public void 创建社区参观的面访(){
        interviewIds.add(saveInterview(customer_id,1));
        interviewIds.add(saveInterview(myselfCustomer_id,1));
        interviewIds.add(saveInterview(introduceCustomer_id,1));
    }

    @Test(description = "查看我的客户列表已面访客户状态显示",priority = 9)
    public void 查看我的客户列表已面访客户状态显示(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_customerList);
        int size = response.jsonPath().getInt("data.myCustomerVos.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.PHONE_customerList,"客户列表为空",response.body().asString()));
        boolean interviewStatus = response.jsonPath().getBoolean("data.myCustomerVos.find{it.custName == '自动化激活用户'}.interviewStatus");
        Assert.assertTrue(interviewStatus,network.message(params,BasicConfig.PHONE_customerList,"客户面访状态错误：非面访中",response.body().asString()));
    }

    @Test(description = "查询面访二维码",priority = 10)
    public void 查询面访二维码(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("ids", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewCode);
        int size = response.jsonPath().getInt("data.size()");
        int statusCount = response.jsonPath().getInt("data.findAll{it.interviewStatus == 1}.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.PHONE_interviewCode,"面访码数量错误",response.body().asString()));
        Assert.assertEquals(statusCount,1,network.message(params,BasicConfig.PHONE_interviewCode,"面访码数量错误",response.body().asString()));
    }

    @Test(description = "上传地理位置",priority = 11)
    public void 上传地理位置(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("latitude", 30.287816);
        params.put("longitude", 120.111991);
        params.put("id", interviewIds.get(0));
        Response response = network.postResponse(params, BasicConfig.PHONE_address);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.PHONE_customerSave,"上传地理位置失败",response.body().asString()));
    }

    @Test(description = "销售查询面访状态",priority = 12)
    public void 销售查询面访状态() {
        sleep(1000);

        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewStatus);
        int interviewStatus = response.jsonPath().getInt("data.interviewStatus");
        Assert.assertEquals(interviewStatus,1,network.message(params,BasicConfig.PHONE_interviewStatus,"面访状态错误：非未授权",response.body().asString()));
    }

    @Test(description = "修改面访时查询面访详情",priority = 13)
    public void 修改面访时查询面访详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewDetail);
        String customerName = response.jsonPath().getString("data.custName");
        Assert.assertEquals(customerName,custName,network.message(params,BasicConfig.PHONE_interviewDetail,"查询面访详情的客户姓名错误",response.body().asString()));
    }

    @Test(description = "修改面访时间",priority = 14)
    public void 修改面访时间(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        params.put("custPhase", 1);
        params.put("appointmentTime", System.currentTimeMillis()+7200000);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewUpdate);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.PHONE_interviewUpdate,"修改社区时间失败",response.body().asString()));
    }

    @Test(description = "授权失败",priority = 15)
    public void 授权失败() throws SQLException {
        agentTku();

        Map<String, Object> result = KjyLiveNormalDB.getInstance().findSimpleResult(UserSqlFactory.selectCodeIdByCustomerId, cust_id);
        scanCodeId = result.get("scan_code_id");

        HashMap<String,Object> params = new HashMap<>();
        params.put("scanCodeId", IdMakeUtil.encodingId((Long) scanCodeId));
        params.put("scanCodeType", 1048);
        Response response = network.postResponse(params, BasicConfig.PHONE_fail);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.PHONE_fail,"授权失败接口错误",response.body().asString()));
    }

    @Test(description = "销售查询面访状态更新为授权失败",priority = 16)
    public void 销售查询面访状态更新为授权失败() {
        sleep(1000);
        otoTakerTku();

        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewStatus);
        int interviewStatus = response.jsonPath().getInt("data.interviewStatus");
        Assert.assertEquals(interviewStatus,5,network.message(params,BasicConfig.PHONE_interviewStatus,"面访状态错误：非未授权",response.body().asString()));
    }

    @Test(description = "非面对面扫码并评价",priority = 17)
    public void 扫码绑定微信用户(){
        agentTku();
        scanCode(IdMakeUtil.encodingId((Long) scanCodeId),1048);
    }

    @Test(description = "销售查询面访状态更新为待上传",priority = 18)
    public void 销售查询面访状态更新为待上传() {
        sleep(2000);
        otoTakerTku();

        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewStatus);
        int interviewStatus = response.jsonPath().getInt("data.interviewStatus");
        Assert.assertEquals(interviewStatus,3,network.message(params,BasicConfig.PHONE_interviewStatus,"扫码评价失败",response.body().asString()));
    }

    @Test(description = "查询面访异常类型",priority = 19)
    public void 查询面访异常类型(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_getUnusualTypes);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2,network.message(params,BasicConfig.PHONE_getUnusualTypes,"面访异常错误",response.body().asString()));
    }

    @Test(description = "查询面访回填信息",priority = 20)
    public void 查询面访回填信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(0));
        Response response = network.getResponse(params, BasicConfig.PHONE_custExtDetail);
        String followWeight = response.jsonPath().getString("data.followWeight");
        String interviewAddress = response.jsonPath().getString("data.interviewAddress");
        String expertName = response.jsonPath().getString("data.expertName");
        Assert.assertNull(followWeight,network.message(params,BasicConfig.PHONE_custExtDetail,"客户权重回显不为1",response.body().asString()));
        Assert.assertNotNull(interviewAddress,network.message(params,BasicConfig.PHONE_custExtDetail,"客户地址回显为空",response.body().asString()));
        Assert.assertEquals(expertName,"勿动-自动化测试专家",network.message(params,BasicConfig.PHONE_custExtDetail,"专家回显不为空",response.body().asString()));
    }

    @Test(description = "上传第一次社区参观面访详情",priority = 21)
    public void 上传第一次社区参观面访详情(){
        HashMap<String,Object> params = new HashMap<>();
        int[] unusualTypes = {1,2};
        ArrayList unusualProofs = new ArrayList();
        unusualProofs.add("https://yun.dui88.com/kjy/image/20220506/ecf1d585e2e040ad97ec7996ce5bf2a3.jpg");
        unusualProofs.add("https://yun.dui88.com/kjy/image/20220505/62cc0df86ed7430ea67d5015ee3fcc2b.jpg");
        params.put("id", interviewIds.get(0));
        params.put("interviewRemark", "第一次社区参观");
        params.put("birthdayTime", "1960-01-03");
        params.put("custAddress", "杭州市文新地铁站");
        params.put("followWeight", 3);
        params.put("commitPlanFlag", 1);
        params.put("prospectusAmount", "计划书金额20W");
        params.put("prospectusDesc", "计划书确认情况良好");
        params.put("isNormal", false);
        params.put("unusualTypes", unusualTypes);
        params.put("unusualExplain", "手机号不一致且非面对面扫码的情况说明");
        params.put("unusualProofs", unusualProofs);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewFeedback);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(params,BasicConfig.PHONE_interviewFeedback,"上传面访失败",response.body().asString()));
    }

    @Test(description = "查看我的面访状态更新为审批中",priority = 23)
    public void 查看我的面访状态更新为审批中(){
        sleep(1000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化激活用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewList);
        int size = response.jsonPath().getInt("data.customerInterviewVos.size()");
        int interviewStatus = response.jsonPath().getInt("data.customerInterviewVos.find{it.id == '"+  interviewIds.get(0) +"'}.interviewStatus");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.PHONE_interviewList,"面访列表为空",response.body().asString()));
        Assert.assertEquals(interviewStatus,6,network.message(params,BasicConfig.PHONE_interviewList,"面访状态错误",response.body().asString()));

        //带看销售查看上传记录
        otoTakerAuth();
        params.clear();
        params.put("custId",cust_id);
        response =network.getResponse(params,BasicConfig.WORK_invire);
        boolean data = response.jsonPath().getBoolean("data");Assert.assertTrue(data ,network.message(params,BasicConfig.WORK_invire,"上传面访记录>=1",response.body().asString()));

        response = network.getResponse(params,BasicConfig.WORK_detail_v2);
        int commitPlanFlag = response.jsonPath().getInt("data.otoCustInfo4Manage.commitPlanFlag");
        Assert.assertEquals(commitPlanFlag,1,network.message(params,BasicConfig.WORK_detail_v2,"是否提交计划书非否",response.body().asString()));

        //查看约面日历
        otoManagerAuth();
        getCalendarlist(today,5,"自动化激活用户","勿动-自动化测试邀约");

        //查看客户的跟进人
        HashMap<String,Object> selectParams = new HashMap<String,Object>();
        selectParams.put("pageIndex", 1);
        selectParams.put("pageSize", 10);
        selectParams.put("phoneNum", "15136361301");
        response = network.getResponse(selectParams,BasicConfig.MANAGER_oto_customerList);
        String sellerName = response.jsonPath().getString("data.list[0].sellerVo.sellerName");
        String expertName = response.jsonPath().getString("data.list[0].expertVo.sellerName");
        Assert.assertEquals(expertName,"勿动-自动化测试专家" ,network.message(params, BasicConfig.MANAGER_oto_customerList, "修改客户标签失败", response.body().asString()));
        Assert.assertEquals(sellerName,"勿动-自动化测试带看" ,network.message(params, BasicConfig.MANAGER_oto_customerList, "修改客户标签失败", response.body().asString()));
    }

    @Test(description = "总监查看审批列表",priority = 24)
    public void 总监查看审批列表(){
        otoLeaderAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        params.put("auditState",1);
        Response response =network.getResponse(params,BasicConfig.WORK_interviewAuditList);
        int size = response.jsonPath().getInt("data.list.size()");
        int unusualTypes = response.jsonPath().getInt("data.list[0].unusualTypes.size()");
        String sellerName = response.jsonPath().getString("data.list[0].sellerName");
        Assert.assertTrue(size>0,network.message(BasicConfig.WORK_interviewAuditList,"待审批列表为空",response.body().asString()));
        Assert.assertEquals(unusualTypes,2,network.message(BasicConfig.WORK_interviewAuditList,"面访异常错误",response.body().asString()));
        Assert.assertEquals(sellerName,"勿动-自动化测试带看",network.message(BasicConfig.WORK_interviewAuditList,"销售名称错误",response.body().asString()));
        businessId = response.jsonPath().getInt("data.list[0].businessId");
    }

    @Test(description = "总监驳回审批",priority = 25)
    public void 总监驳回审批(){
        otoLeaderAuth();

        HashMap<String,Object> params = new HashMap<>();
        params.put("businessId",businessId);
        Response response =network.postResponse(params,BasicConfig.WORK_interviewAuditReject);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_interviewAuditReject,"驳回审批失败",response.body().asString()));

        otoTakerAuth();
        params.clear();
        params.put("custId",  cust_id);
        response = network.getResponse(params,BasicConfig.WORK_detail_v2);
        int commitPlanFlag = response.jsonPath().getInt("data.otoCustInfo4Manage.commitPlanFlag");
        Assert.assertEquals(commitPlanFlag,1,network.message(params,BasicConfig.WORK_detail_v2,"是否提交计划书为否",response.body().asString()));
    }

    @Test(description = "查看我的面访状态更新为已失效",priority = 26)
    public void 查看我的面访状态更新为已失效(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化激活用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewList);
        int interviewStatus = response.jsonPath().getInt("data.customerInterviewVos.find{it.id == '"+  interviewIds.get(0) +"'}.interviewStatus");
        Assert.assertEquals(interviewStatus,7,network.message(params,BasicConfig.PHONE_interviewList,"面访状态错误",response.body().asString()));
    }

    @Test(description = "取消面访",priority = 27)
    public void 取消面访(){
        interviewCancle(interviewIds.get(1));
        interviewCancle(interviewIds.get(2));
        interviewIds.remove(2);
        interviewIds.remove(1);
    }

    @Test(description = "客户再次创建面访并扫码评价",priority = 28)
    public void 客户再次创建面访并扫码评价() throws SQLException {
        otoTakerTku();
        interviewIds.add(saveInterview(customer_id,1));

        agentTku();
        Map<String, Object> result = KjyLiveNormalDB.getInstance().findSimpleResult(UserSqlFactory.selectCodeIdByCustomerId, cust_id);
        scanCodeId = result.get("scan_code_id");
        System.out.println(scanCodeId);
        scanCode(IdMakeUtil.encodingId((Long) scanCodeId),1047);
    }

    @Test(description = "查询失效面访客户回填信息",priority = 29)
    public void 查询失效面访客户回填信息(){
        otoTakerTku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(1));
        Response response = network.getResponse(params, BasicConfig.PHONE_custExtDetail);
        String interviewAddress = response.jsonPath().getString("data.interviewAddress");
        int commitPlanFlag = response.jsonPath().getInt("data.commitPlanFlag");
        String followWeight = response.jsonPath().getString("data.followWeight");
        String giveProspectusFlag = response.jsonPath().getString("data.giveProspectusFlag");
        String expertName = response.jsonPath().getString("data.expertName");
        Assert.assertNotNull(interviewAddress,network.message(params,BasicConfig.PHONE_custExtDetail,"客户地址回显不为空",response.body().asString()));
        Assert.assertNull(followWeight,network.message(params,BasicConfig.PHONE_custExtDetail,"客户等级回显不为1",response.body().asString()));
        Assert.assertNull(giveProspectusFlag,network.message(params,BasicConfig.PHONE_custExtDetail,"是否可送计划书不为空",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,0,network.message(params,BasicConfig.PHONE_custExtDetail,"是否已送计划书不为否",response.body().asString()));
        Assert.assertEquals(expertName,"勿动-自动化测试专家",network.message(params,BasicConfig.PHONE_custExtDetail,"专家回显错误，非【勿动-自动化测试专家】",response.body().asString()));
    }

    @Test(description = "上传社区参观面访详情",priority = 30)
    public void 上传社区参观面访详情(){
        otoTakerTku();
        HashMap<String,Object> params = new HashMap<>();
        int[] unusualTypes = {2};
        ArrayList unusualProofs = new ArrayList();
        unusualProofs.add("https://yun.dui88.com/kjy/image/20220506/ecf1d585e2e040ad97ec7996ce5bf2a3.jpg");
        params.put("id", interviewIds.get(1));
        params.put("custPhase", 1);
        params.put("interviewRemark", "第二次的社区参观");
        params.put("birthdayTime", "1960-01-03");
        params.put("custAddress", "杭州市文新地铁站");
        params.put("followWeight", 2);
        params.put("expertId", IdMakeUtil.encodingId(284L));
        params.put("prospectusAmount", "方案金额");
        params.put("prospectusDesc", "方案确认情况");
        params.put("commitPlanFlag", 1);
        params.put("isNormal", false);
        params.put("unusualTypes", unusualTypes);
        params.put("unusualExplain", "手机号不一致的情况说明");
        params.put("unusualProofs", unusualProofs);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewFeedback);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(params,BasicConfig.PHONE_interviewFeedback,"上传面访失败",response.body().asString()));
    }

    @Test(description = "总监通过审批",priority = 31)
    public void 总监通过审批(){
        otoLeaderAuth();

        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        params.put("auditState",1);
        Response response =network.getResponse(params,BasicConfig.WORK_interviewAuditList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.WORK_interviewAuditList,"待审批列表为空",response.body().asString()));
        businessId = response.jsonPath().getInt("data.list[0].businessId");

        params.clear();
        params.put("businessId",businessId);
        response =network.postResponse(params,BasicConfig.WORK_interviewAuditPass);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_interviewAuditPass,"通过审批失败",response.body().asString()));

        otoTakerAuth();
        params.clear();
        params.put("custId",  cust_id);
        response = network.getResponse(params,BasicConfig.WORK_detail_v2);
        int commitPlanFlag = response.jsonPath().getInt("data.otoCustInfo4Manage.commitPlanFlag");
        Assert.assertEquals(commitPlanFlag,1,network.message(params,BasicConfig.WORK_detail_v2,"是否提交计划书非【是】",response.body().asString()));
    }

    @Test(description = "查询专家列表",priority = 32)
    public void 查询专家列表(){
        otoTakerTku();
        Response response = network.getResponse( BasicConfig.PHONE_expertList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2,network.message(BasicConfig.PHONE_expertList,"专家回显不为空",response.body().asString()));
    }

    @Test(description = "查看我的面访状态更新为已完成",priority =33)
    public void 查看我的面访状态更新为已完成(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化激活用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewList);
        int interviewStatus = response.jsonPath().getInt("data.customerInterviewVos.find{it.id == '"+  interviewIds.get(1) +"'}.interviewStatus");
        Assert.assertEquals(interviewStatus,4,network.message(params,BasicConfig.PHONE_interviewList,"面访状态错误",response.body().asString()));
    }


    @Test(description = "创建送计划书面访",priority = 34)
    public void 创建送计划书面访(){
        otoEpertTku();
        interviewIds.add(saveInterview(customer_id,2));
    }

    @Test(description = "客户完成送计划书面访并扫码",priority = 35)
    public void 客户完成送计划书面访并扫码() throws SQLException {
        agentTku();
        Map<String, Object> result = KjyLiveNormalDB.getInstance().findSimpleResult(UserSqlFactory.selectCodeIdByCustomerId, cust_id);
        scanCodeId = result.get("scan_code_id");
        System.out.println(scanCodeId);
        scanCode(IdMakeUtil.encodingId((Long) scanCodeId),1047);
    }

    @Test(description = "查询异常通过面访客户回填信息",priority = 36)
    public void 查询异常通过面访客户回填信息(){
        otoEpertTku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(2));
        Response response = network.getResponse(params, BasicConfig.PHONE_custExtDetail);
        int commitPlanFlag = response.jsonPath().getInt("data.commitPlanFlag");
        String expertName = response.jsonPath().getString("data.expertName");
        Assert.assertEquals(commitPlanFlag,1,network.message(params,BasicConfig.PHONE_custExtDetail,"是否讲解方案不为否",response.body().asString()));
        Assert.assertEquals(expertName,"勿动-自动化测试专家",network.message(params,BasicConfig.PHONE_custExtDetail,"陪同专家错误",response.body().asString()));
    }

    @Test(description = "二次正常扫码面访异常类型为空",priority = 37)
    public void 二次正常扫码面访异常类型为空(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewIds.get(2));
        Response response = network.getResponse(params, BasicConfig.PHONE_getUnusualTypes);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,0,network.message(params,BasicConfig.PHONE_getUnusualTypes,"面访异常错误",response.body().asString()));
    }

    @Test(description = "查看公司产品列表",priority = 38)
    public void 查看公司产品列表() {
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", customer_id);
        Response response = network.getResponse(params,BasicConfig.PHONE_listBysellComp);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2,network.message(BasicConfig.PHONE_listBysellComp,"产品列表未包含已上架产品",response.body().asString()));
    }

    @Test(description = "下架公司产品",priority = 39)
    public void 下架公司产品() {
        ssoLogin();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", productId);
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_productUpdateStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_productUpdateStatus,"下架公司产品失败",response.body().asString()));
    }

    @Test(description = "产品下架后公司产品列表不显示",priority = 40)
    public void 产品下架后公司产品列表不显示() {
        otoEpertTku();

        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", customer_id);
        Response response = network.getResponse(params,BasicConfig.PHONE_listBysellComp);
        int size = response.jsonPath().getJsonObject("data.size()");
        Assert.assertEquals(size,1,network.message(BasicConfig.PHONE_listBysellComp,"产品列表未包含已上架产品",response.body().asString()));

        params.clear();
        params.put("id", productId);
        response = network.postResponse(params, BasicConfig.MANAGER_oto_productUpdateStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_productUpdateStatus,"上架公司产品失败",response.body().asString()));

    }

    @Test(description = "上传送计划书面访",priority = 41)
    public void 上传送计划书面访() {
        HashMap<String, Object> params = new HashMap<>();
        params.put("id", interviewIds.get(2));
        params.put("interviewRemark", "送客户最终版计划书");
        params.put("birthdayTime", "1960-01-03");
        params.put("custAddress", "杭州市文新地铁站");
        params.put("followWeight", 1);
        params.put("commitPlanFlag", 0);
        params.put("isNormal", true);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewFeedback);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(params,BasicConfig.PHONE_interviewFeedback,"上传面访失败",response.body().asString()));
    }


    @Test(description = "删除见面场景",priority = 47)
    public void 删除见面场景(){
        otoManagerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id",sceneId);
        Response response =network.postResponse(params,BasicConfig.WORK_delete);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_delCust,"删除见面场景失败",response.body().asString()));
    }

    @Test(description = "查看面访详情",priority = 53)
    public void 查看面访详情(){
        otoTakerTku();
        interviewdetail(interviewIds.get(0),3,2,"手机号不一致且非面对面扫码的情况说明",1,1,null);
        otoEpertTku();
        interviewdetail(interviewIds.get(1),2,1,"手机号不一致的情况说明",1,1,"勿动-自动化测试专家");
        interviewdetail(interviewIds.get(2),1,0,"",0,0,null);
    }

    @Test(description = "邀约仅能查看自己创建的面访",priority = 55)
    public void 邀约仅能查看自己创建的面访(){
        otoInviterTku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化激活用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewList);
        int size = response.jsonPath().getInt("data.customerInterviewVos.size()");
        Assert.assertEquals(size,0,network.message(params,BasicConfig.PHONE_interviewList,"邀约面访列表不为空",response.body().asString()));
    }

    @Test(description = "邀约查看历史备注包含各种备注",priority = 56)
    public void 邀约查看历史备注包含各种备注(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params, BasicConfig.WORK_historyRecord);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,6,network.message(params,BasicConfig.WORK_historyRecord,"邀约面访列表不为空",response.body().asString()));
    }

    @Test(description = "专家能查看关联自己的面访",priority = 57)
    public void 专家能查看关联自己的面访(){
        otoEpertTku();

        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化激活用户");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.PHONE_interviewList);
        int size = response.jsonPath().getInt("data.customerInterviewVos.size()");
        Assert.assertEquals(size,2,network.message(params,BasicConfig.PHONE_interviewList,"专家面访列表为空",response.body().asString()));

        params.clear();
        params.put("custName", "自动化激活用户");
        params.put("pageSize", "20");
        response = network.getResponse(params, BasicConfig.PHONE_customerList);
        int interviewNum = response.jsonPath().getInt("data.myCustomerVos[0].interviewNum");
        Assert.assertEquals(interviewNum,2,network.message(params,BasicConfig.PHONE_customerList,"专家线下拜访次数不包含关联面访",response.body().asString()));
    }

    @Test(description = "上传面访后完成见面计划",priority = 58)
    public void 上传面访后完成见面计划(){
        otoTakerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("ids", planIds);
        Response response = network.getResponse(params,BasicConfig.WORK_getPlanDetail);
        int phoneStatus = response.jsonPath().getInt("data.am[0].planStatus");
        Assert.assertEquals(phoneStatus,2,network.message(params,BasicConfig.WORK_getPlanDetail,"见面计划状态非已完成",response.body().asString()));

        params.clear();
        getSellerPlan(2,2,0,1,1,0);
    }

    @Test(description = "邀约销售查看见面次数",priority = 59)
    public void 邀约销售查看见面次数(){
        otoInviterAuth();//邀约统计客户已上传的总面访次数
        HashMap<String,Object> params1 = new HashMap<>();
        params1.put("custId", cust_id);
        params1.put("type", 1);
        Response response = network.getResponse(params1,BasicConfig.WORK_detail_v2);
        int meetTimeSize = response.jsonPath().getInt("data.otoCustInfo4Manage.meetTimeSize");
        Assert.assertEquals(meetTimeSize,3,network.message(params1,BasicConfig.WORK_detail_v2,"客户的见面次数非3",response.body().asString()));

        HashMap<String,Object> params2 = new HashMap<>();
        params2.put("custName", "自动化激活用户");
        params2.put("pageIndex", 1);
        params2.put("pageSize", 50);
        response = network.getResponse(params2,BasicConfig.WORK_inviterCustList);
        int finishInterviewNum = response.jsonPath().getInt("data.list[0].finishInterviewNum");
        Assert.assertEquals(finishInterviewNum,3,network.message(params2,BasicConfig.WORK_inviterCustList,"客户的见面次数非3",response.body().asString()));

        otoTakerAuth();//销售统计当前与客户之间创建的已上传面访次数
        response = network.getResponse(params1,BasicConfig.WORK_detail_v2);
        meetTimeSize = response.jsonPath().getInt("data.otoCustInfo4Manage.meetTimeSize");
        Assert.assertEquals(meetTimeSize,2,network.message(params1,BasicConfig.WORK_detail_v2,"客户的见面次数非3",response.body().asString()));

        response = network.postResponse(params2,BasicConfig.WORK_SellerCustList);
        finishInterviewNum = response.jsonPath().getInt("data.list[0].meetTimes");
        Assert.assertEquals(finishInterviewNum,2,network.message(params2,BasicConfig.WORK_SellerCustList,"客户的见面次数非3",response.body().asString()));

        otoExpertAuth();//专家统计当前与客户之间创建或关联的已上传面访次数
        response = network.getResponse(params1,BasicConfig.WORK_detail_v2);
        meetTimeSize = response.jsonPath().getInt("data.otoCustInfo4Manage.meetTimeSize");
        Assert.assertEquals(meetTimeSize,2,network.message(params1,BasicConfig.WORK_detail_v2,"客户的见面次数非3",response.body().asString()));

        response = network.postResponse(params2,BasicConfig.WORK_SellerCustList);
        finishInterviewNum = response.jsonPath().getInt("data.list[0].meetTimes");
        Assert.assertEquals(finishInterviewNum,2,network.message(params2,BasicConfig.WORK_SellerCustList,"客户的见面次数非3",response.body().asString()));
    }


    @Test(description = "查看跟进人标签",priority = 60)
    public void 查看跟进人标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("type", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_header);
        int sceneConfDesc= response.jsonPath().getInt("data.sceneConfDesc.size()");
        Assert.assertEquals(sceneConfDesc,1,network.message(params,BasicConfig.WORK_header,"客户的场景标签数量错误",response.body().asString()));
    }

    @Test(description = "盘点详情重新分配",priority = 65)
    public void 盘点详情重新分配(){
        otoLeaderAuth();
        assignSeller(cust_id,457,true,2,"check");
    }

    @Test(description = "重新分配销售不显示该客户计划",priority = 66)
    public void 重新分配销售不显示该客户计划(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("beginTime", beginTime);
        Response response = network.postResponse(params,BasicConfig.WORK_getDirectorPlanCalendarList);
        int size = response.jsonPath().getInt("data.size()");
        int flag = 0;
        for(int i =0;i<size;i++){
            if(response.jsonPath().getString("data["+i+"].sellerName").equals("勿动-自动化测试带看")){
                flag = 1;
                int plans = response.jsonPath().getInt("data["+i+"].vos.size()");
                Assert.assertEquals(plans,0,network.message(params,BasicConfig.WORK_getDirectorPlanCalendarList,"销售的当前计划包含不在库客户",response.body().asString()));
            }
        }
        if (flag== 0){
            Assert.fail(network.message(params,BasicConfig.WORK_getDirectorPlanCalendarList,"团队计划中不包含总监名下销售",response.body().asString()));
        }

        otoTakerAuth();
        response = network.postResponse(params,BasicConfig.WORK_getSellerPlanCalendarList);
        size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,0,network.message(params,BasicConfig.WORK_getDirectorPlanCalendarList,"销售的当前计划包含不在库客户",response.body().asString()));

    }

    @Test(description = "方案讲解历史更新",priority = 67)
    public void 方案讲解历史更新(){
        getTree(4,null,1,1,99,2);
        getSchemeList(3,1);
    }

    @Test(description = "查看我的日报为未提交",priority = 75)
    public void 查看我的日报为未提交(){
        otoTakerTku();
        Response response =network.getResponse(BasicConfig.PHONE_paper_getReportFlag);
        int reportFlag = response.jsonPath().getInt("data.reportFlag");
        Assert.assertEquals(reportFlag,0,network.message(BasicConfig.PHONE_paper_getReportFlag,"日报提交状态非未提交",response.body().asString()));
    }

    @Test(description = "查看日报客户列表",priority = 76)
    public void 查看日报客户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageSize",20);
        Response response =network.getResponse(params,BasicConfig.PHONE_paper_getCustomers);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.PHONE_paper_getCustomers,"日报列表客户为空",response.body().asString()));
    }

    
    @Test(description = "提交日报",priority = 77)
    public void 提交日报() {
        HashMap<String, Object> params = new HashMap<>();
        ArrayList custIds =new ArrayList();
        custIds.add(IdMakeUtil.decodingId(customer_id));
        custIds.add(IdMakeUtil.decodingId(introduceCustomer_id));
        custIds.add(IdMakeUtil.decodingId(myselfCustomer_id));

        params.put("custIds", custIds);
        Response response = network.postResponse(params, BasicConfig.PHONE_paper_updateCustomer);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.PHONE_paper_updateCustomer,"提交日报失败",response.body().asString()));
    }

    @Test(description = "提交后查看日报状态",priority = 78)
    public void 提交后查看日报状态() {
        Response response =network.getResponse(BasicConfig.PHONE_paper_getReportFlag);
        int reportFlag = response.jsonPath().getInt("data.reportFlag");
        Assert.assertEquals(reportFlag,1,network.message(BasicConfig.PHONE_paper_getReportFlag,"日报提交状态非1：未提交",response.body().asString()));
    }


    @Test(description = "查看我的预约订单列表",priority = 79)
    public void 查看我的预约订单列表(){
        agent2Tku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response =network.getResponse(params,BasicConfig.PHONE_getReservationList);
        int bookingStatus = response.jsonPath().getInt("data[0].bookingStatus");
        Assert.assertEquals(bookingStatus,1,network.message(BasicConfig.PHONE_getReservationList,"订单状态未更新为已参观",response.body().asString()));
    }

    @Test(description = "删除客户",priority = 90)
    public void 删除客户(){
        int id= cust_id;
        for(int i = id-1;i<id+13;i++){
            HashMap<String,Object> params = new HashMap<>();
            params.put("custId", i);
            Response response = network.postResponse(params,BasicConfig.WORK_delCust);
            boolean data = response.jsonPath().getBoolean("data");
            Assert.assertTrue(data,network.message(params,BasicConfig.WORK_delCust,"删除客户失败",response.body().asString()));
        }
    }

    @Test(description = "删除客户填写的表单记录",priority = 91)
    public void 删除客户填写的表单记录(){
        for(int i =0;i<6;i++){
            HashMap<String,Object> params = new HashMap<>();
            params.put("phoneNum", "1513636130"+i);
            Response response = network.postResponse(params,BasicConfig.WORK_delPubFormRecord);

        }
    }

    @Test(description = "退出登录",priority = 92)
    public void 退出登录(){
        Response response = network.postResponse(BasicConfig.WORK_logout);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.WORK_logout,"退出登录失败",response.body().asString()));
    }

    public String saveInterview(String custId,int custPhase) {
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        params.put("interviewType", 2);
        params.put("interviewConfId", IdMakeUtil.encodingId(sceneId));
        params.put("custPhase", custPhase);
        params.put("custPhase", custPhase);
        params.put("appointmentTime", System.currentTimeMillis()+3600000);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewSave);
        int size = response.jsonPath().getJsonObject("data.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.PHONE_interviewSave,"创建1进2的面访失败",response.body().asString()));
        return response.jsonPath().getJsonObject("data[0]");
    }

    public void scanCode(String scanCodeId,int scanCodeType) {
        HashMap<String,Object> params = new HashMap<>();
        params.put("scanCodeId", scanCodeId);
        params.put("scanCodeType", scanCodeType);
        Response response = network.postResponse(params, BasicConfig.PHONE_bindWxUser);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.PHONE_bindWxUser,"扫码绑定失败",response.body().asString()));
    }

    public void interviewCancle(String interviewId){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewId);
        Response response = network.postResponse(params, BasicConfig.PHONE_interviewCancel);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_delCust,"取消面访失败",response.body().asString()));
    }

    public void interviewdetail(String interviewId,int weight,int unusualTypes,String explain,int giveProspectus,int commitPlan,String expert){
        sleep(1000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", interviewId);
        Response response = network.getResponse(params, BasicConfig.PHONE_feedbackDetail);
        int followWeight = response.jsonPath().getInt("data.followWeight");
        int commitPlanFlag = response.jsonPath().getInt("data.commitPlanFlag");
        String expertName = response.jsonPath().getString("data.expertName");
        String unusualExplain = response.jsonPath().getString("data.unusualExplain");
        Assert.assertEquals(followWeight,weight,network.message(params,BasicConfig.PHONE_feedbackDetail,"关注度显示错误",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,commitPlan,network.message(params,BasicConfig.PHONE_feedbackDetail,"是否讲解方案显示错误",response.body().asString()));
        Assert.assertEquals(expertName,expert,network.message(params,BasicConfig.PHONE_feedbackDetail,"专家名称显示错误",response.body().asString()));
        Assert.assertEquals(unusualExplain, explain, network.message(params, BasicConfig.PHONE_feedbackDetail, "异常情况说明显示错误", response.body().asString()));;
        if(unusualTypes>0) {
            int size = response.jsonPath().getInt("data.unusualTypes.size()");
            Assert.assertEquals(size,unusualTypes,network.message(params,BasicConfig.PHONE_feedbackDetail,"面访异常类型显示错误",response.body().asString()));
        }else{
            Object size = response.jsonPath().getJsonObject("data.unusualTypes");
            Assert.assertNull(size,network.message(params,BasicConfig.PHONE_feedbackDetail,"面访异常类型显示错误",response.body().asString()));
        }
    }
}
