package com.oto.cases.otoseller;

import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.utils.IdMakeUtil;
import com.oto.utils.NetworkUtils;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import static com.oto.cases.otoseller.Work.assignSeller;
import static com.oto.config.BasicConfig.*;
import static com.oto.utils.BaseUtils.ssoLogin;
import static com.oto.utils.ThreadSleepUtils.sleep;

public class Manager implements Authorization {

    private static final NetworkUtils network = NetworkUtils.getInstance();
    public static int cust_id;
    private String insureOrderstr;        //告知书的保单号
    public static int tagId;   //标签ID
    private String pdfUrl;        //告知书的模板pdfURL
    private String encryptId;        //告知书的加密id
    private int linkId;        //直播投放链接id
    private String linkRemark;        //直播投放链接备注
    private long pathkeyId;        //固定链接id
    private ArrayList<Integer> custids;
    public static String phone = "1513636130";    //客户手机号
    @BeforeTest
    public void setUp(){
        ssoLogin();
    }

    @Test(description = "公域引流_填写表单",priority = 1)
    public void 公域引流_填写表单(){
        for(int i = 0;i<6;i++){
            PubForm("1513636130"+i,"自动化测试用户"+i);
        }
    }

    @Test(description = "通过销售名称查找销售",priority = 2)
    public void 通过销售名称查找销售(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerName", "勿动-自动化测试邀约");
        Response response = network.getResponse(params, BasicConfig.MANAGER_oto_searchSeller);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.MANAGER_oto_searchSeller,"查找结果为空",response.body().asString()));
    }

    @Test(description = "查询渠道列表",priority = 3)
    public void 查询渠道列表(){
        Response response = network.getResponse(BasicConfig.MANAGER_oto_channelList);
        int size = response.jsonPath().getInt("data.size");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_oto_channelList,"渠道列表为空",response.body().asString()));
    }

    @Test(description = "不可新增同名公司",priority = 4)
    public void 不可新增同名公司(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("companyName", "勿动-自动化测试公司");
        params.put("areaCodes", new String[]{"330000", "330100"});
        params.put("productIds", new int[]{60,59,64});
        params.put("sellerArea", "浙江省-杭州市");
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_saveCompany);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.MANAGER_oto_saveCompany,"新增同名公司成功",response.body().asString()));
    }

    @Test(description = "修改产品组信息",priority = 5)
    public void 修改产品组信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 5);
        params.put("areaCodes", new String[]{"330000", "330100"});
        params.put("productIds", new int[]{60,59,64});
        params.put("companyName", "勿动-自动化测试公司更新");
        params.put("sellerArea", "浙江省-杭州市");
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_updateCompany);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_updateCompany,"修改产品组失败",response.body().asString()));
    }

    @Test(description = "分页查看产品组列表",priority = 6)
    public void 分页查看产品组列表(){
        HashMap<String,Object> params = new HashMap<>();
        int size= 0 ;
        int i= 1;
        Response response = null;
        while(size<1 && i<10){
            params.put("pageIndex",i);
            params.put("pageSize", "20");
            response = network.getResponse(params, BasicConfig.MANAGER_oto_listCompany);
            size = response.jsonPath().getInt("data.list.findAll{it.companyId == 5}.size()");
            i++;
        }
        size = response.jsonPath().getInt("data.list.findAll{it.companyName == \""+"勿动-自动化测试公司更新"+"\"}.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.MANAGER_oto_listCompany,"查询更新的公司名称失败",response.body().asString()));

        //还原
        params.clear();
        params.put("id", 5);
        params.put("companyName", "勿动-自动化测试公司");
        params.put("areaCodes", new String[]{"330000", "330100"});
        params.put("productIds", new int[]{60,59,19});
        params.put("sellerArea", "浙江省-杭州市");
        response = network.postResponse(params, BasicConfig.MANAGER_oto_updateCompany);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_updateCompany,"修改客户失败",response.body().asString()));
    }

    @Test(description = "查看所有产品组列表",priority = 7)
    public void 查看所有公司列表(){
        Response response = network.getResponse(BasicConfig.MANAGER_oto_listAllCompany);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_oto_listAllCompany,"查看所有公司列表为空",response.body().asString()));
    }

    @Test(description = "查看所有总监列表",priority = 8)
    public void 查看所有总监列表(){
        Response response = network.getResponse(BasicConfig.MANAGER_oto_directorList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_oto_directorList,"查看所有总监列表为空",response.body().asString()));
    }

    @Test(description = "修改公司险种",priority =9)
    public void 修改公司险种(){
        ArrayList costOptions = new ArrayList();
        costOptions.add(0);
        costOptions.add(1);
        costOptions.add(2);
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 19);
        params.put("businessType", 2);
        params.put("supplierId", 11);
        params.put("prodName", "勿动-自动化专用产品更新");
        params.put("costOptions", costOptions);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_productSave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_productSave,"修改险种失败",response.body().asString()));
    }

    @Test(description = "查看险种列表",priority = 10)
    public void 查看险种列表(){
        Response response = null;
        HashMap<String,Object> params = new HashMap<>();
        int size= 0 ;
        int i= 1;
        while(size<1 && i<10){
            params.put("pageIndex",i);
            params.put("pageSize", 10);
            params.put("prodStatus", 1);
            response = network.getResponse(params,BasicConfig.MANAGER_oto_productList);
            size = response.jsonPath().getInt("data.list.findAll{it.id == 19}.size()");
            i++;
        }
        Assert.assertTrue(size>0,network.message(params,BasicConfig.MANAGER_oto_productList,"未找到相应产品",response.body().asString()));
        int costOptionsSize = response.jsonPath().getInt("data.list.find{it.id == 19}.costOptions.size()");
        String prodName = response.jsonPath().getString("data.list.find{it.id == 19}.prodName");
        Assert.assertEquals(costOptionsSize,3,network.message(params,BasicConfig.MANAGER_oto_productList,"产品的缴费期未更新",response.body().asString()));
        Assert.assertEquals(prodName,"勿动-自动化专用产品更新",network.message(params,BasicConfig.MANAGER_oto_productList,"产品的名称未更新",response.body().asString()));
    }

    @Test(description = "还原险种信息",priority = 11)
    public void 还原险种信息(){
        ArrayList costOptions = new ArrayList();
        costOptions.add(0);
        costOptions.add(1);
        costOptions.add(2);
        costOptions.add(3);
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 19);
        params.put("businessType", 2);
        params.put("supplierId", 21);
        params.put("prodName", "勿动-自动化专用产品");
        params.put("costOptions", costOptions);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_productSave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_productSave,"修改险种失败",response.body().asString()));
    }


    @Test(description = "不可新增同名供应商",priority = 15)
    public void 不可新增同名供应商(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("supplierName", "勿动-自动化供应商");
        Response response = network.postResponse(params, BasicConfig.MANAGER_supplier_save);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.MANAGER_supplier_save,"新增同名供应商成功",response.body().asString()));
    }

    @Test(description = "修改供应商名称",priority = 16)
    public void 修改供应商名称(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 21);
        params.put("supplierName", "勿动-自动化专用供应商");
        Response response = network.postResponse(params, BasicConfig.MANAGER_supplier_update);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_supplier_update,"修改供应商名称失败",response.body().asString()));
    }

    @Test(description = "查看第三方账号列表",priority = 17)
    public void 查看供应商列表(){
        Response response = network.getResponse(BasicConfig.MANAGER_supplier_list);
        int size = response.jsonPath().getInt("data.list.size()");
        String supplierName =  response.jsonPath().getString("data.list.find{it.id==21}.supplierName");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_supplier_list,"查询供应商列表为空",response.body().asString()));
        Assert.assertEquals(supplierName,"勿动-自动化专用供应商",network.message(BasicConfig.MANAGER_supplier_list,"查询供应商名称未更新",response.body().asString()));

        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 21);
        params.put("supplierName", "勿动-自动化供应商");
        response = network.postResponse(params, BasicConfig.MANAGER_supplier_update);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_supplier_update,"修改供应商名称失败",response.body().asString()));
    }

    @Test(description = "告知书查看产品列表",priority = 18)
    public void 告知书查看产品列表(){
        Response response = network.getResponse( BasicConfig.MANAGER_product_listByAttachUs);
        int size1 = response.jsonPath().getInt("data.findAll{it.id == 60}.size()");
        int size2 = response.jsonPath().getInt("data.findAll{it.id == 59}.size()");
        int size3 = response.jsonPath().getInt("data.findAll{it.id == 19}.size()");
        Assert.assertEquals(size1,0,network.message(BasicConfig.MANAGER_product_listByAttachUs,"告知书产品列表包含久久保自营产品",response.body().asString()));
        Assert.assertEquals(size2,1,network.message(BasicConfig.MANAGER_product_listByAttachUs,"告知书产品列表不包含挂靠久久保产品",response.body().asString()));
        Assert.assertEquals(size3,0,network.message(BasicConfig.MANAGER_product_listByAttachUs,"告知书产品列表包含其他渠道自营产品",response.body().asString()));
    }

    @Test(description = "获取告知书的模板",priority = 19)
    public void 获取告知书的模板(){
        Response response = network.getResponse( BasicConfig.MANAGER_notification_getNotificationTemplate);
        pdfUrl = response.jsonPath().getString("data");
        Assert.assertNotNull(pdfUrl,network.message(BasicConfig.MANAGER_notification_getNotificationTemplate,"告知书的模板pdfURL为空",response.body().asString()));
    }

    @Test(description = "新增告知书",priority =20)
    public void 新增告知书(){
        HashMap<String,Object> params = new HashMap<>();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd");
        insureOrderstr = sdf.format(date)+"_0001";
        params.put("insureOrder", insureOrderstr);
        params.put("custName", "自动化客户");
        params.put("sellerName", "自动化销售");
        params.put("productId", 59);
        params.put("signatureDate", System.currentTimeMillis()-86400);
        params.put("notificationUrl", pdfUrl);
        Response response = network.postResponse(params, BasicConfig.MANAGER_notification_save);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_notification_save,"增加告知书失败",response.body().asString()));
    }

    @Test(description = "查询所有供应商列表",priority = 21)
    public void 查询所有供应商列表(){
        Response response = network.getResponse(BasicConfig.MANAGER_supplier_listAll);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_supplier_listAll,"查询供应商列表为空",response.body().asString()));
    }

    @Test(description = "查询告知书列表",priority = 22)
    public void 查询告知书列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params, BasicConfig.MANAGER_notification_list);
        int size = response.jsonPath().getInt("data.list.size()");
        String insureOrder = response.jsonPath().getString("data.list[0].insureOrder");
        int signatureState = response.jsonPath().getInt("data.list[0].signatureState");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_notification_list,"查询告知书列表为空",response.body().asString()));
        Assert.assertEquals(insureOrder,insureOrderstr,network.message(BasicConfig.MANAGER_notification_list,"告知书的投保单号错误",response.body().asString()));
        Assert.assertEquals(signatureState,0,network.message(BasicConfig.MANAGER_notification_list,"告知书的状态错误：非待签名",response.body().asString()));
        encryptId =  response.jsonPath().getString("data.list[0].encryptId");
    }

    @Test(description = "修改告知书",priority = 23)
    public void 修改告知书(){
        HashMap<String,Object> params = new HashMap<>();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd");
        insureOrderstr = sdf.format(date)+"_A0001";
        params.put("id", IdMakeUtil.decodingId(encryptId));
        params.put("insureOrder", insureOrderstr);
        params.put("custName", "自动化告知书客户");
        params.put("sellerName", "自动化告知书销售");
        params.put("productId", 59);
        params.put("signatureDate", System.currentTimeMillis());
        params.put("notificationUrl", "//yun.dui88.com/kjy/other/20220607/9b78877fe9f748f78a031c709c66b2c4.pdf");
        Response response = network.postResponse(params, BasicConfig.MANAGER_notification_update);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_notification_update,"修改告知书失败",response.body().asString()));
    }

    @Test(description = "H5查询告知书详情",priority = 24)
    public void H5查询告知书详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("encryptId", encryptId);
        Response response = network.getResponse(params, BasicConfig.PHONE_notification_getDetail);
        String supplierName = response.jsonPath().getString("data.supplierName");
        String custName = response.jsonPath().getString("data.custName");
        String sellerName = response.jsonPath().getString("data.sellerName");
        Assert.assertNotNull(supplierName,network.message(BasicConfig.PHONE_notification_getDetail,"告知书的供应商为空",response.body().asString()));
        Assert.assertEquals(custName,"自动化告知书客户",network.message(BasicConfig.PHONE_notification_getDetail,"告知书的客户名字错误",response.body().asString()));
        Assert.assertEquals(sellerName,"自动化告知书销售",network.message(BasicConfig.PHONE_notification_getDetail,"告知书的销售名字错误",response.body().asString()));
    }

    @Test(description = "客户签名告知书",priority = 25)
    public void 客户签名告知书(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("encryptId", encryptId);
        params.put("notificationUrl", pdfUrl);
        params.put("signatureState", 2);
        Response response = network.postResponse(params, BasicConfig.PHONE_notification_updateSignatureInfo);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.PHONE_notification_updateSignatureInfo,"签名告知书失败",response.body().asString()));

        params.clear();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        response = network.getResponse(params, BasicConfig.MANAGER_notification_list);
        int signatureState = response.jsonPath().getInt("data.list[0].signatureState");
        Assert.assertEquals(signatureState,2,network.message(BasicConfig.MANAGER_notification_list,"告知书的状态错误：非客户已签名",response.body().asString()));
    }

    @Test(description = "销售签名告知书",priority = 26)
    public void 销售签名告知书(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("encryptId", encryptId);
        params.put("notificationUrl", pdfUrl);
        params.put("signatureState", 3);
        Response response = network.postResponse(params, BasicConfig.PHONE_notification_updateSignatureInfo);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.PHONE_notification_updateSignatureInfo,"签名告知书失败",response.body().asString()));

        params.clear();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        response = network.getResponse(params, BasicConfig.MANAGER_notification_list);
        int signatureState = response.jsonPath().getInt("data.list[0].signatureState");
        Assert.assertEquals(signatureState,3,network.message(BasicConfig.MANAGER_notification_list,"告知书的状态错误：非销售客户都签名",response.body().asString()));
    }

    @Test(description = "标记告知书失效",priority = 27)
    public void 标记告知书失效(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", IdMakeUtil.decodingId(encryptId));
        Response response = network.postResponse(params, BasicConfig.MANAGER_notification_signInvalid);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.MANAGER_notification_signInvalid,"签名告知书失败",response.body().asString()));

        params.clear();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        response = network.getResponse(params, BasicConfig.MANAGER_notification_list);
        int signatureState = response.jsonPath().getInt("data.list[0].signatureState");
        Assert.assertEquals(signatureState,4,network.message(BasicConfig.MANAGER_notification_list,"告知书的状态错误：非已失效",response.body().asString()));
    }

    @Test(description = "修改投放账户",priority =28)
    public void 修改投放账户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 20);
        params.put("accountId", "20220107CESHI_1");
        params.put("accountName", "勿动_自动化测试专用账号");
        params.put("companyIds", new int[]{5});
        params.put("pubChannel", 6);
        Response response = network.postResponse(params, BasicConfig.MANAGER_account_saveOrUpdate);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_account_saveOrUpdate,"修改投放账户失败",response.body().asString()));
    }

    @Test(description = "查看投放账户列表",priority =29)
    public void 查看投放账户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        params.put("accountId", "");
        params.put("accountName", "");
        Response response = network.getResponse(params, BasicConfig.MANAGER_account_list);
        int size = response.jsonPath().getInt("data.list.size");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.MANAGER_account_list,"投放账户列表为空",response.body().asString()));
        int size2 = response.jsonPath().getInt("data.list.findAll{it.accountId == '20220107CESHI_1'}.size");
        String accountName = response.jsonPath().getString("data.list.find{it.accountId == '20220107CESHI_1'}.accountName");
        Assert.assertEquals(size2,1,network.message(params,BasicConfig.MANAGER_account_list,"投放账户列表不包含修改后的投放账户",response.body().asString()));
        Assert.assertEquals(accountName,"勿动_自动化测试专用账号",network.message(params,BasicConfig.MANAGER_account_list,"修改后的投放账户名称错误",response.body().asString()));

        params.clear();
        params.put("id", 20);
        params.put("accountId", "20220107CESHI_01");
        params.put("accountName", "勿动_自动化测试账号");
        params.put("companyIds", new int[]{5});
        params.put("pubChannel", 5);
        response = network.postResponse(params, BasicConfig.MANAGER_account_saveOrUpdate);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_account_saveOrUpdate,"修改投放账户失败",response.body().asString()));
    }

    @Test(description = "创建固定直播投放链接",priority =30)
    public void 创建固定直播投放链接(){
        HashMap<String,Object> params = new HashMap<>();
        linkRemark = "勿动_自动化直播公司的测试投放链接"+new Date();
        params.put("channelRemark", linkRemark);
        params.put("companyId", "101");
        params.put("liveId", 8202);
        params.put("launchAccountId", 20);
        Response response = network.postResponse(params, BasicConfig.MANAGER_link_save);
        linkId = response.jsonPath().getInt("data");
        Assert.assertNotNull(linkId,network.message(params,BasicConfig.MANAGER_link_save,"修改投放账户失败",response.body().asString()));
    }

    @Test(description = "获取直播链接生成进度",priority =31)
    public void 获取直播链接生成进度(){
        boolean data = false;
        Response response = null;
        for (int i=0;i<10 && !data;i++) {
            sleep(1000);
            HashMap<String,Object> params = new HashMap<>();
            params.put("id", linkId);
            response = network.getResponse(params, BasicConfig.MANAGER_link_getStatus);
            data = response.jsonPath().getBoolean("data");
        }
        Assert.assertTrue(data,network.message(BasicConfig.MANAGER_link_getStatus,"生成投放链接失败",response.body().asString()));
    }

    @Test(description = "查看直播投放链接列表",priority =32)
    public void 查看直播投放链接列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params, BasicConfig.MANAGER_link_list);
        int size = response.jsonPath().getInt("data.list.size");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.MANAGER_link_list,"直播投放链接列表为空",response.body().asString()));
        int liveSpreadLinkId = response.jsonPath().getInt("data.list[0].liveSpreadLinkId");
        String channelRemark = response.jsonPath().getString("data.list[0].channelRemark");
        Assert.assertEquals(liveSpreadLinkId,linkId,network.message(params,BasicConfig.MANAGER_link_list,"直播投放链接列表不包含新增的投放直播链接",response.body().asString()));
        Assert.assertEquals(channelRemark,linkRemark,network.message(params,BasicConfig.MANAGER_link_list,"新增的投放直播链接备注错误",response.body().asString()));
        pathkeyId = response.jsonPath().getLong("data.list[0].id");
    }

    @Test(description = "查看映射记录",priority =33)
    public void 查看映射记录(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pathKey", pathkeyId);
        params.put("pageIndex", 1);
        params.put("pageSize", 5);
        Response response = network.getResponse(params, BasicConfig.MANAGER_link_listByPathKey);
        int size = response.jsonPath().getInt("data.list.size");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.MANAGER_link_listByPathKey,"投放账户列表为空",response.body().asString()));
        int liveSpreadLinkId = response.jsonPath().getInt("data.list[0].liveSpreadLinkId");
        Assert.assertEquals(liveSpreadLinkId,linkId,network.message(params,BasicConfig.MANAGER_link_listByPathKey,"投放账户列表不包含修改后的投放账户",response.body().asString()));
    }

    @Test(description = "修改固定直播投放链接",priority =34)
    public void 修改固定直播投放链接(){
        HashMap<String,Object> params = new HashMap<>();
        linkRemark = "勿动_自动化直播公司的测试投放链接"+new Date();
        params.put("channelRemark", linkRemark);
        params.put("companyId", "101");
        params.put("liveId", 8203);
        params.put("launchAccountId", 20);
        params.put("pathKey", pathkeyId);
        Response response = network.postResponse(params, BasicConfig.MANAGER_link_fakeUpdate);
        linkId = response.jsonPath().getInt("data");
        Assert.assertNotNull(linkId,network.message(params,BasicConfig.MANAGER_link_fakeUpdate,"修改投放账户失败",response.body().asString()));
    }

    @Test(description = "修改固定链接后查看映射记录更新",priority =35)
    public void 修改固定链接后查看映射记录更新(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pathKey", pathkeyId);
        params.put("pageIndex", 1);
        params.put("pageSize", 5);
        Response response = network.getResponse(params, BasicConfig.MANAGER_link_listByPathKey);
        int size = response.jsonPath().getInt("data.list.size");
        Assert.assertEquals(size,2,network.message(params,BasicConfig.MANAGER_link_listByPathKey,"投放账户列表为空",response.body().asString()));
        int liveSpreadLinkId = response.jsonPath().getInt("data.list[0].liveSpreadLinkId");
        Assert.assertEquals(liveSpreadLinkId,linkId,network.message(params,BasicConfig.MANAGER_link_listByPathKey,"投放账户列表不包含修改后的投放账户",response.body().asString()));
    }

    @Test(description = "名称模糊搜索投放账户",priority =37)
    public void 名称模糊搜索投放账户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("accountName", "勿动");
        Response response = network.getResponse(params, BasicConfig.MANAGER_account_fuzzyByAccountName);
        int size = response.jsonPath().getInt("data.list.size");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.MANAGER_account_fuzzyByAccountName,"查询的投放账户列表为空",response.body().asString()));
        int launchAccountId = response.jsonPath().getInt("data[0].launchAccountId");
        Assert.assertEquals(launchAccountId,20,network.message(params,BasicConfig.MANAGER_account_fuzzyByAccountName,"模糊查询结果错误",response.body().asString()));
    }

    @Test(description = "投放链接进入直播后获取直播id",priority =38)
    public void 投放链接进入直播后获取直播id(){
        visitorAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pathKey",IdMakeUtil.encodingId(pathkeyId));
        Response response = network.getResponse(params, BasicConfig.live_mapping_getTrueLinkInfo);
        int accessSource = response.jsonPath().getInt("data.accessSource");
        String liveId = response.jsonPath().getString("data.liveId");
        Assert.assertEquals(accessSource,linkId,network.message(params,BasicConfig.live_mapping_getTrueLinkInfo,"查询的投放账户列表为空",response.body().asString()));
        Assert.assertEquals(liveId,IdMakeUtil.encodingId(8203L),network.message(params,BasicConfig.live_mapping_getTrueLinkInfo,"模糊查询结果错误",response.body().asString()));
    }

    @Test(description = "批量分配客户",priority = 42)
    public void 批量分配客户(){
        custids = new ArrayList<Integer>();
        cust_id = searchCustName("自动化测试用户1","manage");
        custids.add(cust_id-1);
        custids.add(cust_id+1);

        batchAssignSeller(1,INVITE_ID,custids,"manage");  //批量分配给邀约
        batchAssignSeller(2,SELLER_ID,custids,"manage");  //批量分配给带看
        batchAssignSeller(3,EXPERT_ID,custids,"manage");  //批量分配给专家
    }


    @Test(description = "公域引流_创建标签",priority = 58)
    public void 公域引流_创建标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("tagName", "勿动-自动化测试标签");
        params.put("roleTypes", new int[]{6});
        params.put("sellerIds", new int[]{3});
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_saveTag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_saveTag,"创建标签失败",response.body().asString()));

        //创建名称相同的标签失败
        response = network.postResponse(params,BasicConfig.MANAGER_oto_saveTag);
        data = response.jsonPath().getBoolean("success");
        Assert.assertFalse(data,network.message(params,BasicConfig.MANAGER_oto_saveTag,"创建同名的标签成功",response.body().asString()));
    }

    @Test(description = "公域引流_查看标签列表",priority = 59)
    public void 公域引流_查看标签列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params,BasicConfig.MANAGER_oto_tagList);
        int size = response.jsonPath().getInt("data.list.size()");
        String tagName = response.jsonPath().getString("data.list[0].tagName");
        int customerCount = response.jsonPath().getInt("data.list[0].customerCount");
        int tagStatus = response.jsonPath().getInt("data.list[0].tagStatus");
        Assert.assertTrue(size>10 ,network.message(BasicConfig.MANAGER_oto_tagList,"标签列表为空",response.body().asString()));
        Assert.assertEquals(tagName ,"勿动-自动化测试标签",network.message(params,BasicConfig.MANAGER_oto_tagList,"标签名称错误",response.body().asString()));
        Assert.assertEquals(customerCount ,0,network.message(params,BasicConfig.MANAGER_oto_tagList,"新标签的客户数不为0",response.body().asString()));
        Assert.assertEquals(tagStatus ,1,network.message(params,BasicConfig.MANAGER_oto_tagList,"新标签的状态不为打开",response.body().asString()));

        tagId = response.jsonPath().getInt("data.list[0].id");
    }

    @Test(description = "公域引流_修改标签",priority = 60)
    public void 公域引流_修改标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("tagName", "勿动-自动化更新标签");
        params.put("id", tagId);
        params.put("roleTypes", new int[]{5,2});
        params.put("sellerIds", new int[]{43});
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_updateTag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_updateTag,"修改标签失败",response.body().asString()));
    }

    public static int searchCustName(String custName,String entrance){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", custName);
        String path;
        if(entrance.equals("manage")){//如果是管理后台进入则路径为管理后台的接口，否则为CRM的接口
            path = MANAGER_custName;
        }else{
            path =WORK_MNG_custName;
        }
        Response response = network.getResponse(params, path);
        return response.jsonPath().getInt("data[0].custId");
    }

    public static void batchAssignSeller(int assignType,int sellerId,ArrayList custids,String entrance) {
        HashMap<String,Object> params = new HashMap<>();
        params.put("custIds", custids);
        params.put("assignType", assignType);
        params.put("sellerId", sellerId);
        String path;
        if(entrance.equals("manage")){//如果是管理后台进入则路径为管理后台的接口，否则为CRM的接口
            path = MANAGER_batchAssignSeller;
        }else{
            path =WORK_MNG_batchAssignSeller;
        }
        Response response = network.postResponse(params, path);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data, network.message(params, path, "批量分配失败", response.body().asString()));
    }

    public static void searchRole(String sellerName,int roleType,int result,String entrance) {
        HashMap<String,Object> params = new HashMap<>();
        params.put("name", sellerName);
        params.put("roleType", roleType);
        String path;
        if(entrance.equals("manage")){//如果是管理后台进入则路径为管理后台的接口
            path = MANAGER_roleSellerList;
        }else if(entrance.equals("crm")){//如果CRM进入则路径为CRM客户管理的接口
            path =WORK_MNG_roleSellerList;
        }else{//否则是盘点详情重新分配的接口
            path =WORK_roleSellerList;
        }
        Response response = network.getResponse(params, path);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,result, network.message(params, path, "结果数量不为"+result, response.body().asString()));
    }

    public static void PubForm(String phone,String username){
        HashMap<String,Object> params = new HashMap<>();
        params.put("formId", "Kj20ODA3");
        params.put("phoneNum", phone);
        params.put("urlLink", "https://kjj-static.duibatest.com.cn/cpic-home/202111261430?formId=Kj20ODA3&channel=bd&agent=x");
        params.put("username", username);
        params.put("uuid", "622d83e4-ca21-4ccd-94cb-182c0f2a6b60");
        Response response = network.postResponse(params,BasicConfig.FORM_submit);
        String recordId = response.jsonPath().getString("data.recordId");
        Assert.assertNotNull(recordId,network.message(params,BasicConfig.FORM_submit,"客户创建失败",response.body().asString()));

        params.clear();
        ArrayList<String> optionIds = new ArrayList<>();
        optionIds.add("Kj21NTY1OTE");
        params.put("optionIds", optionIds);
        params.put("questionId", "Kj21MjQ5Njc");
        params.put("recordId", recordId);
        response = network.postResponse(params,BasicConfig.FORM_submitQuestion);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.FORM_submitQuestion,"客户填写表单失败",response.body().asString()));
    }

}
