package com.oto.cases.otoseller;

import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.util.HashMap;

import static com.oto.cases.otoseller.Work.assignSeller;
import static com.oto.utils.BaseUtils.ssoLogin;

public class TestFile implements Authorization {

    @BeforeTest
    public void setUp(){
        ssoLogin();
        otoTestAuth();
    }

    @Test(description = "新建客户",priority = 1)
    public void testSubmit(){
        for(int i = 10;i<100;i++){
            HashMap<String,Object> params = new HashMap<>();
            params.put("formId", "Kj22MTU5MQ");
            params.put("phoneNum", "130202300"+i);
            params.put("urlLink", "https://kjj-static.duibatest.com.cn/tk/202204111900-1?formId=Kj22MTU5MQ&channel=jrtt&agent=td");
            params.put("username", "团队池用户"+i);
            params.put("uuid", "622d83e4-ca21-4ccd-94cb-182c0f2a6b60");
            Response response = network.postResponse(params, BasicConfig.FORM_submit);
            String recordId = response.jsonPath().getString("data.recordId");
            Assert.assertNotNull(recordId,network.message(params,BasicConfig.FORM_submit,"客户创建失败",response.body().asString()));

        }
    }

    @Test(description = "分配客户并创建邀约记录",priority = 2)
    public void testInvite(){
        long time = System.currentTimeMillis() + 86400000 ;
        HashMap<String,Object> params = new HashMap<>();
        params.put("eventType",2);
        params.put("firstInterviewFlag",1);
        params.put("interviewConfId",628);
        params.put("interviewTime",time);
        params.put("haveMealFlag",1);
        params.put("pickTakeFlag",0);
        params.put("custNum",1);
        for(int i = 9277;i<9298;i++){
            assignSeller(i,2,true,1,"manage");
            params.put("custId",i);
            Response response =network.postResponse(params,BasicConfig.WORK_invite_submit);
            boolean data = response.jsonPath().getBoolean("data");
            Assert.assertTrue(data ,network.message(params,BasicConfig.WORK_invite_submit,"修改客户邀约承诺失败",response.body().asString()));

        }
    }

    @Test(description = "删除客户",priority = 90)
    public void 删除客户(){
        for(int i = 8885;i<8895;i++){
            HashMap<String,Object> params = new HashMap<>();
            params.put("custId", i);
            Response response = network.postResponse(params,BasicConfig.WORK_delCust);

        }
    }

    @Test(description = "删除客户填写的表单记录",priority = 91)
    public void 删除客户填写的表单记录(){
        for(int i =10;i<50;i++){
            HashMap<String,Object> params = new HashMap<>();
            params.put("phoneNum", "130112100"+i);
            Response response = network.postResponse(params,BasicConfig.WORK_delPubFormRecord);

        }
    }
}
