package com.oto.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import groovy.json.JsonBuilder;
import io.restassured.response.Response;

import java.util.List;
import java.util.Map;

public class JsonUtil {

    private JsonUtil() {
    }

    public static <T> T parseResponseToBeanTT(Response response, Class<T> tClass) {
        Object data = response.jsonPath().getJsonObject("d");
        String str = new JsonBuilder(data).toString();
        return JSON.parseObject(str, tClass);
    }

    /**
     * 将响应转换成对象
     * @param response
     * @param tClass
     * @param <T>
     * @return
     */
    public static <T>  T parseResponseToBean(Response response, Class<T> tClass){
        Object data = response.jsonPath().getJsonObject("data");
        String str = new JsonBuilder(data).toString();
        return JSON.parseObject(str, tClass);
    }

    /**
     * 分页接口专用-将响应转换成对象
     * @param response
     * @param tClass
     * @param <T>
     * @return
     */
    public static  <T> List<T> parseResponseToPageBean(Response response, Class<T> tClass){
        return parseResponseToPageBean(response, tClass,"list");
    }

    /**
     * 分页接口专用-将响应转换成对象
     * @param response
     * @param tClass
     * @param <T>
     * @return
     */
    public static  <T> List<T> parseResponseToPageBean(Response response, Class<T> tClass,String listName){
        Object data = response.jsonPath().getJsonObject("data");
        String str = new JsonBuilder(data).toString();
        JSONObject jsonObject = JSON.parseObject(str);
        JSONArray array = jsonObject.getJSONArray(listName);
        return array.toJavaList(tClass);
    }

    public static  <T> List<T> parseResponseToListBean(Response response, Class<T> tClass){
        Object data = response.jsonPath().getJsonObject("data");
        String str = new JsonBuilder(data).toString();
        return JSON.parseArray(str, tClass);
    }

    public static  <T> List<T> parseResponseToListBean(Response response, Class<T> tClass, String listName){
        Map map = response.jsonPath().getJsonObject("data");
        Object data = map.get(listName);
        String str = new JsonBuilder(data).toString();
        return JSON.parseArray(str, tClass);
    }

    public static  <T> List<T> parseResponsePathToListBean(Response response, String path,Class<T> tClass){
        Object data = response.jsonPath().getJsonObject(path);
        String str = new JsonBuilder(data).toString();
        return JSON.parseArray(str, tClass);
    }
}
