package com.oto.cases.otoseller;

import com.oto.bean.InvitationRecord;
import com.oto.bean.InviteDay;
import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.utils.IdMakeUtil;
import com.oto.utils.JsonUtil;
import com.oto.utils.NetworkUtils;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.oto.cases.otoseller.Manager.cust_id;
import static com.oto.cases.otoseller.Work.*;
import static com.oto.config.BasicConfig.*;
import static com.oto.utils.BaseUtils.ssoLogin;
import static com.oto.utils.ThreadSleepUtils.sleep;

public class Invite implements Authorization {
    private static final NetworkUtils network = NetworkUtils.getInstance();
    public static Map<String,Integer> header;
    public Map<String,Double> coefficient;
    public static long sceneId;
    public static String inviteUrl;//邀请函链接
    public static long today;    //当前日期0点时间戳
    public static long sunndayWeek;    //当前周日日期
    public double takerCoefficient;
    public static InvitationRecord recordItem;

    @BeforeTest
    public void setUp(){
        header = new HashMap<>();
        coefficient = new HashMap<>();
        otoManagerAuth();
        Sunday();
    }
    @Test(description = "新增见面场景",priority = 1)
    public void 新增见面场景(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("confUsable",1);
        params.put("companyIds",new int[]{5});
        params.put("sceneClassification",2);
        params.put("sceneName","勿动-自动化场景");
        params.put("sceneType",2);
        params.put("sceneDesc","勿动，这是自动化测试专用的面访场景");
        Response response =network.postResponse(params, BasicConfig.WORK_custConfSave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_custConfSave,"新增见面场景失败",response.body().asString()));
    }

    @Test(description = "查看见面场景列表",priority = 2)
    public void 查看见面场景列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response =network.getResponse(params,BasicConfig.WORK_custConfList);
        int size = response.jsonPath().getInt("data.list.size()");
        int confUsable = response.jsonPath().getInt("data.list[0].confUsable");
        String sceneName = response.jsonPath().getString("data.list[0].sceneName");
        Assert.assertTrue(size>0 ,network.message(params,BasicConfig.WORK_custConfList,"查看列表场景不为空",response.body().asString()));
        Assert.assertEquals(confUsable, 1,network.message(params,BasicConfig.WORK_custConfList,"查看见面场景非0",response.body().asString()));
        Assert.assertEquals(sceneName,"勿动-自动化场景",network.message(params,BasicConfig.WORK_custConfList,"查看见面名称错误",response.body().asString()));

        sceneId = response.jsonPath().getLong("data.list[0].id");
    }

    @Test(description = "修改见面场景",priority = 3)
    public void 修改见面场景(){
        int companyIds[] ={5};

        HashMap<String,Object> params = new HashMap<>();
        params.put("id",sceneId);
        params.put("confUsable",1);
        params.put("sceneType",1);
        params.put("companyIds",companyIds);
        params.put("sceneClassification",1);
        params.put("sceneName","勿动-自动化面访场景");
        params.put("sceneDesc","勿动，这是自动化测试专用的面访场景");
        Response response =network.postResponse(params,BasicConfig.WORK_custConfSave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_custConfSave,"修改自动化场景失败",response.body().asString()));
    }

    @Test(description = "查看客户面访状态为尚未约到",priority = 4)
    public void 查看客户面访状态为尚未约到(){
        otoInviterAuth();
        getHasFirstInvite(-1,true);
    }

    @Test(description = "修改客户面访状态为明确拒绝",priority = 5)
    public void 修改客户面访状态为明确拒绝(){
        updateInvite(0,now+86400000,cust_id);
        getHasFirstInvite(0,true);
    }

    @Test(description = "修改客户面访状态为已约到时间未定",priority = 6)
    public void 修改客户面访状态为已约到时间未定(){
        updateInvite(2,now+86400000,cust_id);
        getHasFirstInvite(2,true);
    }

    @Test(description = "获取客户适用场景",priority = 7)
    public void 获取客户适用场景(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",cust_id);
        Response response =network.getResponse(params,BasicConfig.WORK_getAllSceneConfs);
        int size = response.jsonPath().getInt("data.size()");
        int confUsableSize = response.jsonPath().getInt("data[5].findAll{it.confUsable == 1}.size()");
        Assert.assertEquals(size,4 ,network.message(params,BasicConfig.WORK_getAllSceneConfs,"面访场景包含场景未根据产品组关联",response.body().asString()));
        Assert.assertEquals(confUsableSize,3 ,network.message(params,BasicConfig.WORK_getAllSceneConfs,"面访场景包含场景未根据产品组关联",response.body().asString()));
    }

    @Test(description = "修改客户面访承诺时间为今天",priority = 8)
    public void 修改客户面访承诺时间为1天后(){
        updateInvite(1,now,cust_id);

        getHasFirstInvite(1,true);
        getCallCustInfo(1);
    }

    @Test(description = "查看约面日历为已确认",priority = 9)
    public void 查看约面日历为已确认(){
        getCalendarlist(today+86400000,2,"自动化测试客户","勿动-自动化测试邀约");
    }


    @Test(description = "修改客户具体时间客户状态不变",priority = 10)
    public void 修改客户具体时间客户状态不变(){
        updateInvite(1,now + 86400000+3600000,cust_id);

        getHasFirstInvite(1,true);
        getCallCustInfo(1);
        getCalendarlist(today+86400000,2,"自动化测试客户","勿动-自动化测试邀约");
    }

    @Test(description = "修改客户具体日期覆盖邀约记录",priority = 11)
    public void 修改客户具体日期覆盖邀约记录(){
        updateInvite(1,now + 86400000*2,cust_id);

        getHasFirstInvite(1,true);
        getCallCustInfo(1);
        getCalendarlist(today+86400000,0,"自动化测试客户","勿动-自动化测试邀约");
        getCalendarlist(today+86400000*2,1,"自动化测试客户","勿动-自动化测试邀约");
        headerDeatil(1,"inviteStatus","1");
    }

    @Test(description = "修改客户未约到客户删除邀约记录",priority = 12)
    public void 修改客户未约到客户删除邀约记录(){
        updateInvite(0,now + 3600000,cust_id);

        getHasFirstInvite(0,true);
        getCallCustInfo(0);;
        getCalendarlist(today+86400000*2,0,"自动化测试客户","勿动-自动化测试邀约");
    }

    @Test(description = "修改客户已约到客户状态时间明天后变为已确认",priority =13)
    public void 修改客户已约到客户状态时间明天后变为已确认(){
        updateInvite(1,now + 86400000,cust_id);

        getHasFirstInvite(1,true);
        getCallCustInfo(1);
        getCalendarlist(today,2,"自动化测试客户","勿动-自动化测试邀约");
    }

    @Test(description = "查询客户的面访上传记录<1",priority = 14)
    public void 查询客户的面访上传记录(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",cust_id);
        Response response =network.getResponse(params,BasicConfig.WORK_invire);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertFalse(data ,network.message(params,BasicConfig.WORK_invire,"上传面访记录>=1",response.body().asString()));
    }

    @Test(description = "生成加微邀请函二维码",priority = 15)
    public void 生成加微邀请函二维码(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("content",inviteUrl);
        params.put("height",209);
        params.put("width",209);
        Response response =network.postResponse(params,BasicConfig.WORK_generate);
        String data = response.jsonPath().getString("data");
        Assert.assertNotNull(data ,network.message(params,BasicConfig.WORK_generate,"二维码生成失败",response.body().asString()));
    }

    @Test(description = "查看邀请函客户信息",priority = 16)
    public void 查看邀请函客户信息(){
        agent2Tku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", IdMakeUtil.encodingId((long)cust_id));
        Response response =network.postResponse(params,BasicConfig.WX_look);
        String visitDate = response.jsonPath().getString("data.visitDate");
        int visitorNum = response.jsonPath().getInt("data.visitorNum");
        boolean confirmFlag = response.jsonPath().getBoolean("data.confirmFlag");
        Assert.assertNotNull(visitDate ,network.message(params,BasicConfig.WX_look,"约面状态未更新为【已约到】",response.body().asString()));
        Assert.assertEquals(visitorNum ,10,network.message(params,BasicConfig.WX_look,"约面状态未更新为【已约到】",response.body().asString()));
        Assert.assertFalse(confirmFlag ,network.message(params,BasicConfig.WX_look,"约面状态未更新为【已约到】",response.body().asString()));
    }

    @Test(description = "客户确认邀请函",priority = 17)
    public void 客户确认邀请函(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", IdMakeUtil.encodingId((long)cust_id));
        Response response =network.postResponse(params, WX_confirm);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data ,network.message(params,BasicConfig.WX_confirm,"客户确认邀请函失败",response.body().asString()));

        otoInviterAuth();
    }
    @Test(description = "邀约组拨打电话回填面访信息正常",priority = 18)
    public void 邀约组拨打电话回填面访信息正常(){
        getCallCustInfo(1);
        getHasFirstInvite(1,true);
    }


    @Test(description = "关闭见面场景状态",priority = 19)
    public void 关闭见面场景状态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id",sceneId);
        params.put("confUsable",0);
        Response response =network.postResponse(params,BasicConfig.WORK_updateStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_updateStatus,"关闭见面场景失败",response.body().asString()));
    }

    @Test(description = "重新分配邀约后邀约任务继承",priority = 20)
    public void 重新分配邀约后邀约任务继承(){
        //重新分配邀约
        assignSeller(cust_id,320,true,1,"crm");

        //查看回显
        getHasFirstInvite(1,true);
        getCallCustInfo(1);
        getCalendarlist(today,2,"自动化测试客户","勿动-自动化备用邀约");

        //还原
        assignSeller(cust_id,INVITE_ID,true,1,"crm");
    }


    @Test(description = "CRM查询场景专家列表",priority = 21)
    public void CRM查询场景专家列表(){
        otoManagerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("recordId",recordItem.recordId);
        params.put("expertFlag",true);
        Response response =network.getResponse(params,BasicConfig.WORK_calendar_workMenu);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,3 ,network.message(BasicConfig.WORK_calendar_workMenu,"查看专家列表不为空",response.body().asString()));
    }

    @Test(description = "CRM查询场景带看人列表",priority = 22)
    public void CRM查询场景带看人列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("recordId",recordItem.recordId);
        params.put("expertFlag",false);
        Response response =network.getResponse(params,BasicConfig.WORK_calendar_workMenu);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2 ,network.message(BasicConfig.WORK_calendar_workMenu,"查看带看列表不为空",response.body().asString()));
    }

    @Test(description = "预分配客户",priority = 23)
    public void 预分配客户(){
        otoInviterAuth();
        coefficient.put("totalCoefficient",getSellertotalCoefficient());

        otoTakerAuth();
        takerCoefficient = getSellertotalCoefficient();
        otoInviterAuth();

        //预分配
        HashMap<String,Object> params = new HashMap<>();
        otoInviterAuth();
        params.put("recordId",recordItem.recordId);
        params.put("takeLookId",SELLER_ID);
        params.put("expertId",EXPERT_ID);
        Response response =network.postResponse(params,BasicConfig.WORK_calendar_preAssign);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_calendar_preAssign,"预分配失败",response.body().asString()));

        //验证约面日历状态/专家/带看人变更
        getCalendarlist(today,4,"自动化测试客户","勿动-自动化测试邀约");
        Assert.assertEquals(recordItem.expertName,"勿动-自动化测试专家",network.message(params,BasicConfig.WORK_calendar_list,"专家名称错误",response.body().asString()));
        Assert.assertEquals(recordItem.takeLookName,"勿动-自动化测试带看",network.message(params,BasicConfig.WORK_calendar_list,"带看人名称错误",response.body().asString()));
        Assert.assertTrue(recordItem.hasAssignFlag,network.message(params,BasicConfig.WORK_calendar_list,"是否分配状态非【已分配】",response.body().asString()));

        //验证邀约人系数不变
        double sellertotalCoefficient = getSellertotalCoefficient();
        Assert.assertEquals(sellertotalCoefficient,coefficient.get("totalCoefficient"),network.message(params,BasicConfig.WORK_coefficient_detail,"邀约人系数变化",response.body().asString()));

        //验证带看人系数不变
        otoTakerAuth();
        double leadertotalCoefficient = getSellertotalCoefficient();
        Assert.assertEquals(leadertotalCoefficient,takerCoefficient,network.message(params,BasicConfig.WORK_coefficient_detail,"邀约人系数未增加",response.body().asString()));
    }

    @Test(description = "退回邀约组",priority = 24)
    public void 退回邀约组(){
        //退回邀约组
        otoManagerAuth();
        HashMap<String,Object> params = new HashMap<>();
        otoInviterAuth();
        params.put("recordId",recordItem.recordId);
        Response response =network.postResponse(params,BasicConfig.WORK_calendar_assignRollback);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_calendar_assignRollback,"退回邀约组失败",response.body().asString()));

        //验证约面日历状态/专家/带看人清空
        getCalendarlist(today,3,"自动化测试客户","勿动-自动化测试邀约");
        Assert.assertNull(recordItem.expertName,network.message(params,BasicConfig.WORK_calendar_list,"专家名称不为空",response.body().asString()));
        Assert.assertNull(recordItem.takeLookName,network.message(params,BasicConfig.WORK_calendar_list,"带看人名称不为空",response.body().asString()));
        Assert.assertFalse(recordItem.hasAssignFlag,network.message(params,BasicConfig.WORK_calendar_list,"是否分配状态非【待分配未确认】",response.body().asString()));

        otoInviterAuth();
        //验证邀约人系数不变
        double sellertotalCoefficient = getSellertotalCoefficient();
        Assert.assertEquals(sellertotalCoefficient,coefficient.get("totalCoefficient"),network.message(params,BasicConfig.WORK_coefficient_detail,"邀约人系数变化",response.body().asString()));
    }


    @Test(description = "立即分配邀约客户",priority = 25)
    public void 立即分配邀约客户(){
        updateInvite(1,now + 3600000,cust_id);
        getCalendarlist(today,2,"自动化测试客户","勿动-自动化测试邀约");

        otoManagerAuth();

        //立即分配
        HashMap<String,Object> params = new HashMap<>();
        params.put("recordId",recordItem.recordId);
        params.put("takeLookId",SELLER_ID);
        params.put("expertId",EXPERT_ID);
        Response response =network.postResponse(params,BasicConfig.WORK_calendar_nowAssign);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_calendar_nowAssign,"立即分配失败",response.body().asString()));

        //验证约面日历状态/专家/带看人变更
        getCalendarlist(today,4,"自动化测试客户","勿动-自动化测试邀约");
        Assert.assertEquals(recordItem.expertName,"勿动-自动化测试专家",network.message(params,BasicConfig.WORK_calendar_list,"专家名称错误",response.body().asString()));
        Assert.assertEquals(recordItem.takeLookName,"勿动-自动化测试带看",network.message(params,BasicConfig.WORK_calendar_list,"带看人名称错误",response.body().asString()));
        Assert.assertTrue(recordItem.hasAssignFlag,network.message(params,BasicConfig.WORK_calendar_list,"是否分配状态非【已分配】",response.body().asString()));

        //验证邀约人系数不变
        otoInviterAuth();
        double sellertotalCoefficient = getSellertotalCoefficient();
        Assert.assertEquals(sellertotalCoefficient,coefficient.get("totalCoefficient"),network.message(params,BasicConfig.WORK_coefficient_detail,"邀约人系数变化",response.body().asString()));

        //验证带看人系数增加
        otoTakerAuth();
        double leadertotalCoefficient = getSellertotalCoefficient();
        Assert.assertTrue(leadertotalCoefficient>takerCoefficient,network.message(params,BasicConfig.WORK_coefficient_detail,"带看人系数未增加",response.body().asString()));
        takerCoefficient = leadertotalCoefficient;
    }

    @Test(description = "PM分配团队",priority = 26)
    public void PM分配团队(){
        otoPMAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("recordId", recordItem.recordId);
        params.put("deptId", 47);
        params.put("pageSource", 1);
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_team);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data, network.message(params, BasicConfig.WORK_MNG_team, "客户分配团队失败", response.body().asString()));

        getCalendarlist(today,4,"自动化测试客户","勿动-自动化测试邀约");
        Assert.assertEquals(recordItem.deptId, 47,network.message(BasicConfig.WORK_getAllSceneConfs,"未回显部门id",""));
    }

    @Test(description = "导出确认到场客户",priority = 27)
    public void 导出确认到场客户(){
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String,Object> params = new HashMap<>();
        params.put("date", sdt.format(today));
        Response response = network.getResponse(params, BasicConfig.WORK_calendarExport);
        String data = response.jsonPath().getString("data");
        Assert.assertNotNull(data, network.message(params, BasicConfig.WORK_calendarExport, "导出客户失败", response.body().asString()));
    }


    @Test(description = "邀约记录未到场盘点详情不可重新分配专家",priority = 30)
    public void 邀约记录未到场盘点详情不可重新分配专家(){
        assignSeller(cust_id,479,false,3,"check");
    }

    //获取销售系数
    public Double getSellertotalCoefficient(){
        sleep(1000);
        Response response =network.getResponse(BasicConfig.WORK_coefficient_detail);
        Double totalCoefficient = response.jsonPath().getDouble("data.totalCoefficient");
        Assert.assertTrue(totalCoefficient>=0,network.message(BasicConfig.WORK_coefficient_detail,"销售总系数<0",response.body().asString()));
        return totalCoefficient;
    }

    //获取电话回填客户约面信息
    public void getCallCustInfo(int interviewFlag){
        sleep(1000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response =network.getResponse(params,BasicConfig.WORK_getCallCustInfo);
        int firstInterviewFlag = response.jsonPath().getInt("data.firstInterviewFlag");
        Assert.assertEquals(firstInterviewFlag ,interviewFlag ,network.message(params,BasicConfig.WORK_getCallCustInfo,"约面状态回显非"+"",response.body().asString()));

        if(interviewFlag == 1){//已约到非终态-回显邀约记录
            String interviewTime = response.jsonPath().getString("data.interviewTime");
            Assert.assertNotNull(interviewTime ,network.message(params,BasicConfig.WORK_getCallCustInfo,"约面状态未更新为【已约到】",response.body().asString()));
        }else if(interviewFlag == 2){//已约到终态-不回显邀约记录
            String interviewTime = response.jsonPath().getString("data.interviewTime");
            Assert.assertNull(interviewTime ,network.message(params,BasicConfig.WORK_getCallCustInfo,"约面状态未更新为【已约到】",response.body().asString()));
        }else{
            String nextContactTime = response.jsonPath().getString("data.nextContactTime");
            Assert.assertNotNull(nextContactTime ,network.message(params,BasicConfig.WORK_getCallCustInfo,"约面状态未更新为【已约到】",response.body().asString()));
        }
    }

    //修改客户的约面情况
    public static void updateInvite(int interviewFlag,long time,int customer_id){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",customer_id);
        params.put("eventType",2);
        params.put("firstInterviewFlag",interviewFlag);
        if(interviewFlag == 1){      //1为已约到需要填写时间地点
            params.put("interviewConfId",440);
            params.put("interviewTime",time);
            params.put("haveMealFlag",1);
            params.put("pickTakeFlag",1);
            params.put("custNum",10);
            params.put("pickTakeAddress","杭州数字娱乐大厦");
            params.put("receiveAndSendOffTime",time-3600000);
        } else if(interviewFlag == 2) {      //1为已约到需要填写时间地点
            params.put("nextContactTime",time);
        } else{      //0表示未约到
            params.put("custManner",1);
            params.put("rejectReason",2);
        }
        Response response =network.postResponse(params,BasicConfig.WORK_invite_submit);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data ,network.message(params,BasicConfig.WORK_invite_submit,"修改客户邀约承诺失败",response.body().asString()));

    }


    //获取客户详情回填的客户约面信息
    public static void getHasFirstInvite(int interviewFlag,boolean isinviter){
        sleep(1000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",cust_id);
        Response response =network.getResponse(params,BasicConfig.WORK_getHasFirstInvite);
        String firstInterviewFlag = response.jsonPath().getString("data.firstInterviewFlag");
        String interviewTime = response.jsonPath().getString("data.interviewTime");
        String nextContactTime = response.jsonPath().getString("data.nextContactTime");
        String invLetterUrl = response.jsonPath().getString("data.invLetterUrl");
        if(interviewFlag == -1){
            Assert.assertNull(firstInterviewFlag ,network.message(params,BasicConfig.WORK_getHasFirstInvite,"约面状态回显不为空",response.body().asString()));
            Assert.assertNull(interviewTime ,network.message(params,BasicConfig.WORK_getHasFirstInvite,"面访承诺时间不为空",response.body().asString()));
            Assert.assertNull(nextContactTime ,network.message(params,BasicConfig.WORK_getHasFirstInvite,"下次联系时间不为空",response.body().asString()));
            Assert.assertNull(invLetterUrl ,network.message(params,BasicConfig.WORK_getHasFirstInvite,"邀请函链接不为空",response.body().asString()));
        }else {
            Assert.assertEquals(firstInterviewFlag, String.valueOf(interviewFlag), network.message(params, BasicConfig.WORK_getHasFirstInvite, "约面状态回显非" + interviewFlag, response.body().asString()));
            if (interviewFlag == 1) {
                Assert.assertNotNull(interviewTime, network.message(params, BasicConfig.WORK_getHasFirstInvite, "面访承诺时间为空", response.body().asString()));
                inviteUrl = response.jsonPath().getString("data.invLetterUrl");
                if (isinviter)
                    Assert.assertNotNull(inviteUrl, network.message(params, BasicConfig.WORK_getHasFirstInvite, "邀请函链接为空", response.body().asString()));
                else
                    Assert.assertNull(inviteUrl, network.message(params, BasicConfig.WORK_getHasFirstInvite, "邀请函链接为空", response.body().asString()));
            } else{
                Assert.assertNull(interviewTime, network.message(params, BasicConfig.WORK_getHasFirstInvite, "面访承诺时间不为空", response.body().asString()));
                Assert.assertNull(invLetterUrl, network.message(params, BasicConfig.WORK_getHasFirstInvite, "邀请函链接不为空", response.body().asString()));
                if (interviewFlag == 2) {
                    Assert.assertNotNull(nextContactTime ,network.message(params,BasicConfig.WORK_getHasFirstInvite,"下次联系时间不为空",response.body().asString()));
                }else{
                    int custManner = response.jsonPath().getInt("data.custManner");
                    int rejectReason = response.jsonPath().getInt("data.rejectReason");
                    Assert.assertEquals(custManner, 1, network.message(params, BasicConfig.WORK_getHasFirstInvite, "客户态度非明确拒绝", response.body().asString()));
                    Assert.assertEquals(rejectReason, 2, network.message(params, BasicConfig.WORK_getHasFirstInvite, "拒绝原因非2" + interviewFlag, response.body().asString()));
                }
            }
        }
    }

    //获取约面日历列表
    public static void getCalendarlist(long calendarTime,int inviteStatus,String custName,String inviterName){
        sleep(1000);
        int flag= 0 ;
        HashMap<String,Object> params = new HashMap<>();
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
        if (calendarTime>sunndayWeek){
            params.put("calendarTime", sdt.format(now+86400000*7));
        }else{
            params.put("calendarTime", sdt.format(now));
        }

        Response response =network.getResponse(params,BasicConfig.WORK_calendar_list);
        System.out.println(calendarTime);
        List<InviteDay> invitationList = JsonUtil.parseResponseToListBean(response, InviteDay.class);
        for (InviteDay day: invitationList) {
            if(day.calendarTime == calendarTime){
                for(InvitationRecord record:day.invitationInfo) {
                    if(record.custName != null && record.custName.equals(custName)){
                        flag=1;
                        recordItem = record;
                        Assert.assertEquals(record.inviteStatus, inviteStatus ,network.message(params,BasicConfig.WORK_calendar_list,"约面状态回显非"+inviteStatus,response.body().asString()));
                        Assert.assertEquals(record.inviterName, inviterName ,network.message(params,BasicConfig.WORK_calendar_list,"邀约人非【"+inviterName+"】",response.body().asString()));
                        break;
                    }
                }
                break;
            }
        }

        if(flag == 0 && inviteStatus!=0){
            Assert.fail("未找到相应的约面记录");
        }
    }
    public static void Sunday(){
        now = System.currentTimeMillis();
        today = now-(now + 8*3600 * 1000) % (60*60*24*1000);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        if(cal.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY ){
            sunndayWeek = cal.getTimeInMillis();
            System.out.println(simpleDateFormat.format(cal.getTime()));
        }else{
            cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
            cal.set(Calendar.DATE, cal.get(Calendar.DATE) + 6);
            System.out.println(simpleDateFormat.format(cal.getTime()));
            sunndayWeek = cal.getTimeInMillis();
        }
    }

}
