package com.oto.cases.otoseller;

import com.alibaba.fastjson.JSONObject;
import com.oto.bean.*;
import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.utils.BaseUtils;
import com.oto.utils.JsonUtil;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;

import static com.oto.cases.otoseller.Manager.cust_id;
import static com.oto.utils.ThreadSleepUtils.sleep;

public class FormSubmit implements Authorization {
    public int formId;   //资料组ID
    public GroupData groupData;

    @Test(description = "查看资料组列表",priority = 1)
    public void 查看资料组列表(){
        otoManagerAuth();
        Response response = network.getResponse(BasicConfig.WORK_formList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,8,network.message(BasicConfig.WORK_formList,"资料组数量错误",response.body().asString()));

        formId =response.jsonPath().getInt("data[7].id");
    }

    @Test(description = "创建同名资料组名称失败",priority = 2)
    public void 创建同名资料组名称失败(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("title", "勿动-自动化资料组");
        Response response = network.postResponse(params, BasicConfig.WORK_formSave);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_formSave,"创建同名资料组名称成功",response.body().asString()));
    }

    @Test(description = "删除资料组所有题目不可开启资料组",priority = 3)
    public void 删除资料组所有题目不可开启资料组(){
        HashMap<String,Object> paramsFrom = new HashMap<>();
        paramsFrom.put("id", formId);
        paramsFrom.put("formQuestions", new ArrayList<>());
        paramsFrom.put("title", "勿动-自动化资料组");
        Response response = network.postResponse(paramsFrom, BasicConfig.WORK_saveFormDetail);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(paramsFrom,BasicConfig.WORK_saveFormDetail,"修改资料组状态失败",response.body().asString()));
    }

    @Test(description = "获取资料组的配置详情",priority = 4)
    public void 获取资料组的配置详情(){
        formDetail(4,"勿动-自动化资料组");
    }

    @Test(description = "开启资料组",priority = 5)
    public void 开启资料组(){
        formStatus(1,true);

        //客户详情仅显示开启的资料组
        custDetail(8,false,false);
    }



    @Test(description = "新增资料组题目",priority = 6)
    public void 新增资料组题目(){
        ArrayList options = new ArrayList();
        options.add(new Option(0,"q-0-"+ BaseUtils.randomCode(),"normal","选项1"));
        options.add(new Option(0,"q-1-"+ BaseUtils.randomCode(),"normal","选项2"));
        options.add(new Option(0,"q-2-"+ BaseUtils.randomCode(),"normal","选项3"));
        options.add(new Option(0,"q-3-"+ BaseUtils.randomCode(),"other","其他"));
        FormQuestion select = new FormQuestion(0,0,"q-5-"+ BaseUtils.randomCode(),"select","自动化新增多选题",null,true,options,null);
        groupData.formQuestions.add(select);
        FormQuestion input = new FormQuestion(0,0,"q-6-"+ BaseUtils.randomCode(),"input","自动化新增填空题",false,null,new ArrayList<>(),null);
        groupData.formQuestions.add(input);
        groupData.setTitle("勿动-自动化更新资料组");
        saveFormDetail();

        formDetail(6,"勿动-自动化更新资料组");
        custDetail(8,false,false);
    }

    @Test(description = "客户保存新增资料组选项",priority = 7)
    public void 客户保存新增资料组选项(){
        otoInviterAuth();
        ArrayList answers1 = new ArrayList();   //多选题答案
        ArrayList answers2 = new ArrayList();   //填空题答案
        answers1.add(new Answer(groupData.formQuestions.get(4).options.get(0).code,""));
        answers1.add(new Answer(groupData.formQuestions.get(4).options.get(1).code,""));
        answers1.add(new Answer(groupData.formQuestions.get(4).options.get(3).code,"其他选项"));
        answers2.add(new Answer("","输入框"));

        ArrayList questionParams = new ArrayList();
        for (int i = 0; i < 4;i++) {
            questionParams.add(new QuestionParam(groupData.formQuestions.get(i).id,new ArrayList()));
        }
        questionParams.add(new QuestionParam(groupData.formQuestions.get(4).id,answers1));//单选题-选择选项1、选项2、其他选项
        questionParams.add(new QuestionParam(groupData.formQuestions.get(5).id,answers2));//填空题输入内容

        HashMap<String,Object> paramsFrom = new HashMap<>();
        paramsFrom.put("groupId", formId);
        paramsFrom.put("custId", cust_id);
        paramsFrom.put("questionParams", questionParams);
        Response response = network.postResponse(paramsFrom, BasicConfig.WORK_formSubmit);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(paramsFrom,BasicConfig.WORK_formSubmit,"修改资料组状态失败",response.body().asString()));

        sleep(3000);
        custDetail(8,true,false);
    }

    @Test(description = "删除和修改选项",priority = 8)
    public void 删除和修改选项(){
        groupData.formQuestions.get(4).options.get(0).setTitle("选项1的文案更新");    //修改多选题-选项1的答案
        groupData.formQuestions.get(4).options.remove(3);            //删除多选题-其他选项
        groupData.setTitle("勿动-自动化资料组");
        saveFormDetail();
    }

    @Test(description = "删除和修改选项客户回显更新",priority = 9)
    public void 删除和修改选项客户回显更新(){
        sleep(3000);
        formDetail(6,"勿动-自动化资料组");
        custDetail(8,true,true);
    }

    @Test(description = "删除资料组题目",priority = 10)
    public void 删除资料组题目(){
        groupData.formQuestions.remove(5);    //删除多选题
        groupData.formQuestions.remove(4);            //删除填空题
        saveFormDetail();
    }

    @Test(description = "删除资料组题目客户不显示该题目",priority = 11)
    public void 删除资料组题目客户不显示该题目(){
        formDetail(4,"勿动-自动化资料组");
        custDetail(8,false,true);
    }
    @Test(description = "关闭资料组",priority = 20)
    public void 关闭资料组(){
        formStatus(0,true);

        //客户详情仅显示开启的资料组
        custDetail(7,false,true);
    }

    @Test(description = "查询客户的历史字段信息",priority = 11)
    public void 查询客户的历史字段信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("type", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_detail_v2);
        int checkInCommunity = response.jsonPath().getInt("data.otoCustInfo4Insurance.checkInCommunity");
        String familyStructure = response.jsonPath().getString("data.otoCustInfo4Insurance.familyStructure");
        int commitPlanFlag = response.jsonPath().getInt("data.otoCustInfo4Manage.commitPlanFlag");
        int meetTimeSize = response.jsonPath().getInt("data.otoCustInfo4Manage.meetTimeSize");
        String drawType = response.jsonPath().getString("data.otoCustInfo4Plan.drawType");
        Assert.assertNull(familyStructure,network.message(params,BasicConfig.WORK_detail_v2,"新客户家庭结构非空",response.body().asString()));
        Assert.assertNull(drawType,network.message(params,BasicConfig.WORK_detail_v2,"新客户支取方案非空",response.body().asString()));
        Assert.assertEquals(checkInCommunity,0,network.message(params,BasicConfig.WORK_detail_v2,"新客户的是否需入住社区非否",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,0,network.message(params,BasicConfig.WORK_detail_v2,"新客户的是否提交计划书非否",response.body().asString()));
        Assert.assertEquals(meetTimeSize,0,network.message(params,BasicConfig.WORK_detail_v2,"新客户的见面次数非0",response.body().asString()));
    }

    public void formStatus(int status,boolean result){
        otoManagerAuth();
        HashMap<String,Object> paramsFrom = new HashMap<>();
        paramsFrom.put("id", formId);
        paramsFrom.put("status", status);
        Response response = network.postResponse(paramsFrom, BasicConfig.WORK_formStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertEquals(data,result,network.message(paramsFrom,BasicConfig.WORK_formStatus,"修改资料组状态失败",response.body().asString()));
    }

    public void saveFormDetail(){
        otoManagerAuth();
        HashMap<String,Object> paramsFrom = new HashMap<>();
        paramsFrom.put("id", formId);
        paramsFrom.put("formQuestions", groupData.formQuestions);
        paramsFrom.put("title", groupData.title);
        Response response = network.postResponse(paramsFrom, BasicConfig.WORK_saveFormDetail);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(paramsFrom,BasicConfig.WORK_saveFormDetail,"新增资料组题目失败",response.body().asString()));
    }

    public void custDetail(int formCount,boolean submit,boolean deleteFlag){
        otoInviterAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("type", 1);
        Response response = network.getResponse(params, BasicConfig.WORK_custDetail);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,formCount,network.message(params,BasicConfig.WORK_custDetail,"资料组数量错误",response.body().asString()));

        if(formCount == 8){
            int qCount = response.jsonPath().getInt("data[7].formQuestions.size()");
            String title = response.jsonPath().getString("data[7].title");
            Assert.assertEquals(qCount,groupData.formQuestions.size(),network.message(params,BasicConfig.WORK_custDetail,"资料组数量错误",response.body().asString()));
            Assert.assertEquals(title,groupData.title,network.message(params,BasicConfig.WORK_custDetail,"资料组名称错误",response.body().asString()));
            if (submit){
                int answers1 = response.jsonPath().getInt("data[7].formQuestions[4].answers.size()");
                String answers2 = response.jsonPath().getString("data[7].formQuestions[5].answers[0].text");
                if(deleteFlag){
                    String option1 = response.jsonPath().getString("data[7].formQuestions[4].answers[0].text");
                    String option2 = response.jsonPath().getString("data[7].formQuestions[4].answers[1].text");
                    Assert.assertEquals(answers1,2,network.message(params,BasicConfig.WORK_custDetail,"答案回显错误",response.body().asString()));
                    Assert.assertEquals(option1,"",network.message(params,BasicConfig.WORK_custDetail,"答案回显错误",response.body().asString()));
                    Assert.assertEquals(option2,"",network.message(params,BasicConfig.WORK_custDetail,"答案回显错误",response.body().asString()));
                    Assert.assertEquals(answers2,"输入框",network.message(params,BasicConfig.WORK_custDetail,"答案回显错误",response.body().asString()));
                }else{
                    Assert.assertEquals(answers1,3,network.message(params,BasicConfig.WORK_custDetail,"答案回显错误",response.body().asString()));
                    String other = response.jsonPath().getString("data[7].formQuestions[4].answers[2].text");
                    Assert.assertEquals(other,"其他选项",network.message(params,BasicConfig.WORK_custDetail,"答案回显错误",response.body().asString()));
                    Assert.assertEquals(answers2,"输入框",network.message(params,BasicConfig.WORK_custDetail,"答案回显错误",response.body().asString()));
                }

            }

        }
    }

    public void formDetail(int questionCount,String groupName){
        HashMap<String,Object> paramsFrom = new HashMap<>();
        paramsFrom.put("id", formId);
        Response response = network.getResponse(paramsFrom, BasicConfig.WORK_formDetail);
        int size = response.jsonPath().getInt("data.formQuestions.size()");
        String title = response.jsonPath().getString("data.title");
        Assert.assertEquals(size,questionCount,network.message(paramsFrom,BasicConfig.WORK_formDetail,"资料组的配置详情的题目数量错误",response.body().asString()));
        Assert.assertEquals(title,groupName,network.message(paramsFrom,BasicConfig.WORK_formDetail,"资料组的名称数量错误",response.body().asString()));

        groupData = JsonUtil.parseResponseToBean(response,GroupData.class);

    }
}
