package com.oto.cases.otoseller;

import com.oto.bean.Customer;
import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.utils.JsonUtil;
import com.oto.utils.NetworkUtils;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.math.BigDecimal;
import java.util.*;

import static com.oto.cases.otoseller.Manager.*;
import static com.oto.config.BasicConfig.*;
import static com.oto.utils.BaseUtils.*;
import static com.oto.utils.ThreadSleepUtils.sleep;

public class Work implements Authorization {
    private static final NetworkUtils network = NetworkUtils.getInstance();
    public int followTimes;    //跟进次数
    public static Map<String,Integer> header;
    public Map<String,Double> coefficient;
    public static long now;    //当前时间戳
    public static Customer customer;    //当前日期0点时间戳
    public int callRecordId;    //任务ID

    @BeforeTest
    public void setUp(){
        header = new HashMap<>();
        coefficient = new HashMap<>();
        ssoLogin();
        now = System.currentTimeMillis();
    }



    @Test(description = "工作台_菜单权限列表",priority = 4)
    public void 工作台_菜单权限列表(){
        otoInviterAuth();
        menuList(4);

        otoTakerAuth();
        menuList(3);

        otoExpertAuth();
        menuList(3);

        otoAssistAuth();
        menuList(13);

        otoLeaderAuth();
        menuList(18);

        otoPMAuth();
        menuList(13);

        otoAreaAuth();
        menuList(12);

        otoPlanAuth();
        menuList(3);

        otoManagerAuth();
        menuList(23);
    }

    @Test(description = "工作台_标签列表",priority = 5)
    public void 工作台_标签列表(){
        HashMap<Integer,Object> tags = new HashMap<>();

        otoInviterAuth();
        tags.put(tagId,"勿动-自动化更新标签");
        tags.put(831,"自动化邀约标签");
        tagList(tags);

        otoTakerAuth();
        tags.clear();
        tags.put(696,"自动化销售标签");
        tagList(tags);

        otoAssistAuth();
        tags.put(833,"自动化管理标签");
        tagList(tags);

        otoLeaderAuth();
        tags.put(tagId,"勿动-自动化更新标签");
        tags.put(832,"自动化专家标签");
        tagList(tags);

        otoExpertAuth();
        tags.clear();
        tags.put(832,"自动化专家标签");
        tagList(tags);

        otoPMAuth();
        tags.clear();
        tagList(tags);

        otoAreaAuth();
        tagList(tags);

        otoPlanAuth();
        tagList(tags);

        otoManagerAuth();
        tagList(tags);
    }

    @Test(description = "工作台_销售信息",priority = 6)
    public void 客户分类_销售信息(){
        otoInviterAuth();
        Response response = network.getResponse(BasicConfig.WORK_userInfo);
        String sellerName = response.jsonPath().getString("data.sellerName");
        int newRoleTypes = response.jsonPath().getInt("data.newRoleTypes.size()");
        Assert.assertEquals(sellerName,"勿动-自动化测试邀约",network.message(BasicConfig.WORK_userInfo,"销售姓名错误",response.body().asString()));
    }

    @Test(description = "工作台_通知栏",priority = 7)
    public void 工作台_通知栏(){
        Response response = network.getResponse(BasicConfig.WORK_notifyList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.WORK_notifyList,"通知栏不为空",response.body().asString()));
        int notifyType = response.jsonPath().getInt("data[0].notifyType");
        int custCount = response.jsonPath().getInt("data[0].custCount");
        Assert.assertEquals(custCount,5,network.message(BasicConfig.WORK_notifyList,"客户数量错误",response.body().asString()));
        Assert.assertEquals(notifyType,2,network.message(BasicConfig.WORK_notifyList,"通知栏类型错误",response.body().asString()));
    }

    @Test(description = "客户状态分类_数量总览",priority = 9)
    public void 客户状态分类_数量总览(){
        Response response = network.getResponse(BasicConfig.WORK_staticHeader);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(BasicConfig.WORK_staticHeader,"数量总览数据为空",response.body().asString()));
        int totalNum = response.jsonPath().getInt("data.totalNum");
        header.put("totalNum",totalNum);
    }

    @Test(description = "全部客户客户列表",priority = 11)
    public void 全部客户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 50);
        Response response = network.getResponse(params,BasicConfig.WORK_inviterCustList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,5,network.message(params,BasicConfig.WORK_inviterCustList,"需要联系列表中首位客户非新增客户",response.body().asString()));

        followTimes = response.jsonPath().getInt("data.list[0].followTimes");
        Object lastFollowTime = response.jsonPath().getJsonObject("data.list[0].lastFollowTime");
        Assert.assertEquals(followTimes,0,network.message(params,BasicConfig.WORK_inviterCustList,"新客户的默认跟进次数不为0",response.body().asString()));
        Assert.assertNull(lastFollowTime,network.message(params,BasicConfig.WORK_inviterCustList,"新客户的默认跟进时间不为null",response.body().asString()));
    }

    @Test(description = "查看微信",priority = 12)
    public void 查看微信(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_phone);
        String data = response.jsonPath().getString("data");
        Assert.assertEquals(data,"15136361301",network.message(params,BasicConfig.WORK_phone,"手机号错误",response.body().asString()));
    }

    @Test(description = "查询新客户见面情况",priority = 13)
    public void 查询新客户见面情况(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_info);
        boolean todayMeetFlag = response.jsonPath().getBoolean("data.todayMeetFlag");
        boolean orderVisitFlag = response.jsonPath().getBoolean("data.orderVisitFlag");
        Object orderVisitDate = response.jsonPath().getJsonObject("data.orderVisitDate");
        Assert.assertFalse(todayMeetFlag,network.message(params,BasicConfig.WORK_info,"今日见面状态错误：为已见面",response.body().asString()));
        Assert.assertFalse(orderVisitFlag,network.message(params,BasicConfig.WORK_info,"预约参观状态错误：为已预约",response.body().asString()));
        Assert.assertNull(orderVisitDate,network.message(params,BasicConfig.WORK_info,"预约时间不为空",response.body().asString()));
    }

    @Test(description = "查询新客户头部信息",priority = 14)
    public void 查询新客户头部信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("type", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_header);
        int allCallTimes= response.jsonPath().getInt("data.allCallTimes");
        int allCallTime= response.jsonPath().getInt("data.allCallTime");
        int callTimes= response.jsonPath().getInt("data.callTimes");
        int custStar= response.jsonPath().getInt("data.custStar");
        int addWxStatus= response.jsonPath().getInt("data.addWxStatus");
        int followUp= response.jsonPath().getInt("data.followUp");
        int bindWxWorkFlag= response.jsonPath().getInt("data.wxCustInfo.bindWxWorkFlag");
        String custHead= response.jsonPath().getString("data.custHead");
        String custDescription= response.jsonPath().getString("data.custDescription");
        String expertRemark= response.jsonPath().getString("data.expertRemark");
        Assert.assertEquals(allCallTimes,0,network.message(params,BasicConfig.WORK_header,"新客户总call次数非0",response.body().asString()));
        Assert.assertEquals(allCallTime,0,network.message(params,BasicConfig.WORK_header,"新客户总通话时间非0",response.body().asString()));
        Assert.assertEquals(callTimes,0,network.message(params,BasicConfig.WORK_header,"新客户总通话次数非0",response.body().asString()));
        Assert.assertEquals(custStar,0,network.message(params,BasicConfig.WORK_header,"新客户星标不为否",response.body().asString()));
        Assert.assertEquals(addWxStatus,0,network.message(params,BasicConfig.WORK_header,"新客户的加微状态不是未添加",response.body().asString()));
        Assert.assertEquals(followUp,6,network.message(params,BasicConfig.WORK_header,"新客户的重点跟进人不是空",response.body().asString()));
        Assert.assertEquals(bindWxWorkFlag,0,network.message(params,BasicConfig.WORK_header,"新客户的企微状态不是未绑定",response.body().asString()));
        Assert.assertEquals(custHead,"https://yun.kjjcrm.com/kjy/media/file/20221018/c9c37c521ddfd949614f1b78b92a1001.png?x-oss-process=image/quality,q_80",network.message(params,BasicConfig.WORK_header,"新客户头像非默认头像",response.body().asString()));
        Assert.assertEquals(custDescription,"",network.message(params,BasicConfig.WORK_header,"新客户的备注不为null",response.body().asString()));
        Assert.assertNull(expertRemark,network.message(params,BasicConfig.WORK_header,"新客户的专家评价不为null",response.body().asString()));

    }

    @Test(description = "查询新客户的日程状态",priority = 15)
    public void 查询新客户的日程状态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_getScheduleInfo);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNull(data,network.message(params,BasicConfig.WORK_getScheduleInfo,"新客户日程非空",response.body().asString()));
    }

    @Test(description = "查询新客户的详细信息",priority = 16)
    public void 查询新客户的详细信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("type", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_detail_v2);
        String age = response.jsonPath().getString("data.otoCustInfo4Base.age");
        String sellerName = response.jsonPath().getString("data.otoCustInfo4Base.sellerName");
        int checkInCommunity = response.jsonPath().getInt("data.otoCustInfo4Insurance.checkInCommunity");
        String familyStructure = response.jsonPath().getString("data.otoCustInfo4Insurance.familyStructure");
        int commitPlanFlag = response.jsonPath().getInt("data.otoCustInfo4Manage.commitPlanFlag");
        int meetTimeSize = response.jsonPath().getInt("data.otoCustInfo4Manage.meetTimeSize");
        String drawType = response.jsonPath().getString("data.otoCustInfo4Plan.drawType");
        Assert.assertNull(age,network.message(params,BasicConfig.WORK_detail_v2,"新客户年龄非空",response.body().asString()));
        Assert.assertNull(sellerName,network.message(params,BasicConfig.WORK_detail_v2,"新客户当前的跟进销售非空",response.body().asString()));
        Assert.assertNull(familyStructure,network.message(params,BasicConfig.WORK_detail_v2,"新客户家庭结构非空",response.body().asString()));
        Assert.assertNull(drawType,network.message(params,BasicConfig.WORK_detail_v2,"新客户支取方案非空",response.body().asString()));
        Assert.assertEquals(checkInCommunity,0,network.message(params,BasicConfig.WORK_detail_v2,"新客户的是否需入住社区非否",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,0,network.message(params,BasicConfig.WORK_detail_v2,"新客户的是否提交计划书非否",response.body().asString()));
        Assert.assertEquals(meetTimeSize,0,network.message(params,BasicConfig.WORK_detail_v2,"新客户的见面次数非0",response.body().asString()));
        customer = JsonUtil.parseResponseToBean(response,Customer.class);
    }

    @Test(description = "查询客户电话表单回填状态",priority = 17)
    public void 查询客户电话表单回填状态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_showFeedback);
        boolean data = response.jsonPath().getBoolean("data.hasUndoneFeedback");
        Assert.assertFalse(data,network.message(params,BasicConfig.WORK_showFeedback,"电话表单回填状态错误：为需要回填",response.body().asString()));
    }

    @Test(description = "查询省市列表",priority = 18)
    public void 查询省市列表(){
        Response response = network.getResponse(BasicConfig.WORK_regionCity);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(BasicConfig.WORK_regionCity,"省市列表为空",response.body().asString()));
    }

    @Test(description = "查询历史通话",priority = 19)
    public void 查询历史通话(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("logDays", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_callLog);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(params,BasicConfig.WORK_callLog,"历史通话为空",response.body().asString()));
    }

    @Test(description = "查看销售的总系数",priority = 21)
    public void 查看销售的总系数(){
        Response response =network.getResponse(BasicConfig.WORK_coefficient_detail);
        Double totalCoefficient = response.jsonPath().getDouble("data.totalCoefficient");
        Double coefficientLimit = response.jsonPath().getDouble("data.coefficientLimit");
        Assert.assertTrue(totalCoefficient>0,network.message(BasicConfig.WORK_coefficient_detail,"销售总系数≤0",response.body().asString()));
        Assert.assertTrue(coefficientLimit>0,network.message(BasicConfig.WORK_coefficient_detail,"总系数上限≤0",response.body().asString()));
        coefficient.put("totalCoefficient",totalCoefficient);
        coefficient.put("formCoefficient",response.jsonPath().getDouble("data.formCoefficient"));
        coefficient.put("outRegionCoefficient",response.jsonPath().getDouble("data.outRegionCoefficient"));
        coefficient.put("outAgreeCoefficient",response.jsonPath().getDouble("data.outAgreeCoefficient"));
    }

    @Test(description = "查询客户的地区及系数",priority = 22)
    public void 查询客户的地区及系数(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_customer_detail);
        boolean showConfirmFlag = response.jsonPath().getBoolean("data.showConfirmFlag");
        int remainDays = response.jsonPath().getInt("data.remainDays");
        String custActionType = response.jsonPath().getString("data.custActionType");
        Assert.assertTrue(showConfirmFlag,network.message(params,BasicConfig.WORK_customer_detail,"外地客户未展示确认认领按钮",response.body().asString()));
        Assert.assertTrue(remainDays>0,network.message(params,BasicConfig.WORK_customer_detail,"自动认领天数≤0",response.body().asString()));
        Assert.assertEquals(custActionType,"01",network.message(params,BasicConfig.WORK_customer_detail,"外地客户的客户来源为空",response.body().asString()));

        coefficient.put("custCoefficient",response.jsonPath().getDouble("data.custCoefficient"));
        coefficient.put("claimCustCoefficient",response.jsonPath().getDouble("data.claimCustCoefficient"));
    }

    @Test(description = "认领外地客户后销售系数更新",priority = 23)
    public void 认领外地客户后销售系数更新(){
        //认领外地客户
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.postResponse(params,BasicConfig.WORK_customer_claim);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_customer_claim,"认领外地客户失败",response.body().asString()));

        //查询销售总系数
        response =network.getResponse(BasicConfig.WORK_coefficient_detail);
        Double totalCoefficient = response.jsonPath().getDouble("data.totalCoefficient");
        Double formCoefficient = response.jsonPath().getDouble("data.formCoefficient");
        Double outRegionCoefficient = response.jsonPath().getDouble("data.outRegionCoefficient");
        Double outAgreeCoefficient = response.jsonPath().getDouble("data.outAgreeCoefficient");

        //认领后总系数=认领前总系数+客户认领后系数-客户认领前系数
        BigDecimal bg = new BigDecimal(coefficient.get("totalCoefficient") + coefficient.get("claimCustCoefficient") - coefficient.get("custCoefficient"));
        Double sum1 = bg.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
        bg = new BigDecimal(coefficient.get("outRegionCoefficient")-coefficient.get("custCoefficient"));
        Double sum2 = bg.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
        bg = new BigDecimal(coefficient.get("outAgreeCoefficient")+coefficient.get("claimCustCoefficient"));
        Double sum3 = bg.setScale(2,BigDecimal.ROUND_HALF_UP).doubleValue();
        Assert.assertEquals(totalCoefficient,sum1,network.message(BasicConfig.WORK_coefficient_detail,"销售总系数增加错误",response.body().asString()));
        Assert.assertEquals(formCoefficient, coefficient.get("formCoefficient"),network.message(BasicConfig.WORK_coefficient_detail,"填单系数发生变化",response.body().asString()));
        Assert.assertEquals(outRegionCoefficient, sum2,network.message(BasicConfig.WORK_coefficient_detail,"外地客户总系数减少错误",response.body().asString()));
        Assert.assertEquals(outAgreeCoefficient, sum3,network.message(BasicConfig.WORK_coefficient_detail,"外地确认客户总系数增加错误",response.body().asString()));

        coefficient.put("totalCoefficient",totalCoefficient);
    }

    @Test(description = "修改客户客户等级",priority = 24)
    public void 修改客户客户等级(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("followWeight", 1);
        Response response = network.postResponse(params,BasicConfig.WORK_weight);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_weight,"修改客户客户等级失败",response.body().asString()));
    }

    @Test(description = "修改客户标签",priority = 25)
    public void 修改客户标签(){
        HashMap<String,Object> params = new HashMap<>();
        ArrayList<Integer> tags = new ArrayList<>();
        tags.add(tagId);
        params.put("custId", cust_id);
        params.put("tagIds", tags);
        Response response = network.postResponse(params,BasicConfig.WORK_tag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_tag,"修改客户标签失败",response.body().asString()));

        //查询信息更新
        params.clear();
        params.put("custId", cust_id);
        response = network.getResponse(params,BasicConfig.WORK_detail);
        int tagSize = response.jsonPath().getInt("data.custInfo.tagIds.size()");
        Assert.assertEquals(tagSize,1,network.message(params,BasicConfig.WORK_detail,"标签数量错误",response.body().asString()));
        int tId = response.jsonPath().getInt("data.custInfo.tagIds[0]");
        Assert.assertEquals(tId,tagId,network.message(params,BasicConfig.WORK_detail,"标签Id错误",response.body().asString()));
    }

    @Test(description = "修改标签状态为关闭",priority = 26)
    public void 修改标签状态为关闭(){
        ssoLogin();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", tagId);
        params.put("tagStatus", 0);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_switchStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_switchStatus,"关闭标签显示失败",response.body().asString()));
    }

    @Test(description = "查询更新的标签列表和客户标签",priority = 27)
    public void 查询更新的标签列表和客户标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_detail);
        Object tagIds = response.jsonPath().getJsonObject("data.custInfo.tagIds");
        Assert.assertNull(tagIds,network.message(params,BasicConfig.WORK_detail,"标签数量错误",response.body().asString()));

        response = network.getResponse(BasicConfig.WORK_tagList);
        int size = response.jsonPath().getInt("data.findAll{it.tagId =="+tagId+"}.size()");
        Assert.assertEquals(size,0,network.message(BasicConfig.WORK_tagList,"标签数量错误",response.body().asString()));

        params.clear();
        sleep(1000);
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        response = network.getResponse(params,BasicConfig.MANAGER_oto_tagList);
        int customerCount = response.jsonPath().getInt("data.list[0].customerCount");
        Assert.assertEquals(customerCount ,1,network.message(params,BasicConfig.MANAGER_oto_tagList,"标签的客户数不为1",response.body().asString()));
    }

    @Test(description = "修改标签状态为开启",priority = 28)
    public void 修改标签状态为开启() {
        ssoLogin();
        HashMap<String, Object> params = new HashMap<>();
        params.put("id", tagId);
        params.put("tagStatus", 1);
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_switchStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_switchStatus,"修改客户标签失败",response.body().asString()));
    }

    @Test(description = "删除客户标签",priority = 29)
    public void 删除客户标签() {
        HashMap<String,Object> params = new HashMap<>();
        ArrayList<Integer> tags = new ArrayList<>();
        params.put("custId", cust_id);
        params.put("tagIds", tags);
        Response response = network.postResponse(params,BasicConfig.WORK_tag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_tag,"修改客户标签失败",response.body().asString()));


        params.clear();
        params.put("custId", cust_id);
        response = network.getResponse(params,BasicConfig.WORK_detail);
        Object tagIds = response.jsonPath().getJsonObject("data.custInfo.tagIds");
        Assert.assertNull(tagIds,network.message(params,BasicConfig.WORK_detail,"标签数量错误",response.body().asString()));

        response = network.getResponse(BasicConfig.WORK_tagList);
        int size = response.jsonPath().getInt("data.findAll{it.tagId =="+tagId+"}.size()");
        Assert.assertEquals(size,1,network.message(BasicConfig.WORK_tagList,"标签数量错误",response.body().asString()));
    }

    @Test(description = "查看日报客户列表",priority = 30)
    public void 查看日报客户列表(){
        otoInviterTku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageSize",20);
        Response response =network.getResponse(params,BasicConfig.PHONE_paper_getCustomers);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.PHONE_paper_getCustomers,"订单状态未更新为已参观",response.body().asString()));
        String label = response.jsonPath().getString("data.list[0].label");
        Assert.assertEquals(label,"今日查看微信",network.message(BasicConfig.PHONE_paper_getCustomers,"日报提交状态非0：未提交",response.body().asString()));
    }

    @Test(description = "修改客户个人信息",priority = 31)
    public void 修改客户个人信息(){
        HashMap<String,Object> params = new HashMap<>();
        long now = System.currentTimeMillis();
        long tomorrow = now-(now + 8*3600 * 1000) % (60*60*24*1000) - 86400000;
        params.put("custId", cust_id);
        params.put("birthdayTime", tomorrow);
        params.put("custAddress", "老的客户住址");
        params.put("custGender", 1);
        Response response = network.postResponse(params,BasicConfig.WORK_updateInfo);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_updateInfo,"修改个人信息失败",response.body().asString()));

        params.clear();
        params.put("custId", cust_id);
        params.put("type", 1);
        response = network.getResponse(params,BasicConfig.WORK_header);
        long birthdayTime= response.jsonPath().getLong("data.birthdayTime");
        String custAddress= response.jsonPath().getString("data.custAddress");
        int age= response.jsonPath().getInt("data.age");
        int custGender= response.jsonPath().getInt("data.custGender");
        Assert.assertEquals(birthdayTime,tomorrow,network.message(params,BasicConfig.WORK_header,"出生年月日更新失败",response.body().asString()));
        Assert.assertEquals(age,0,network.message(params,BasicConfig.WORK_header,"年纪更新失败",response.body().asString()));
        Assert.assertEquals(custAddress,"老的客户住址",network.message(params,BasicConfig.WORK_header,"家庭住址更新失败",response.body().asString()));
        Assert.assertEquals(custGender,1,network.message(params,BasicConfig.WORK_header,"性别更新失败",response.body().asString()));
    }

    @Test(description = "修改客户基础信息",priority = 34)
    public void 修改客户基础信息(){
//
    }

    @Test(description = "编辑客户备注",priority = 35)
    public void 编辑客户备注(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("custDescription", "客户的备注");
        Response response = network.postResponse(params,BasicConfig.WORK_updateCustDescription);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_updateCustDescription,"修改客户备注失败",response.body().asString()));

        headerDeatil(1,"custDescription","客户的备注");
    }

    @Test(description = "编辑客户加微状态",priority = 36)
    public void 编辑客户加微状态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("addWxStatus", 3);
        Response response = network.postResponse(params,BasicConfig.WORK_updateAddWxStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_updateAddWxStatus,"修改客户加微状态失败",response.body().asString()));

        headerDeatil(1,"addWxStatus","3");
    }

    @Test(description = "编辑客户姓名",priority = 37)
    public void 编辑客户姓名(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("custName", "自动化测试用户");
        Response response = network.postResponse(params,BasicConfig.WORK_updateCustName);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_updateCustName,"修改客户姓名失败",response.body().asString()));

        headerDeatil(1,"custName","自动化测试用户");
    }

    @Test(description = "创建转介绍客户",priority = 38)
    public void 创建转介绍客户(){
        HashMap<String,Object> params = new HashMap<>();
        createCustomerFromDetail(1,cust_id,"自动化测试用户","15136361306","自动化测试客户6",true);

        params.put("pageIndex", 1);
        params.put("pageSize", 50);
        params.put("custName", "自动化测试客户6");
        Response response = network.getResponse(params,BasicConfig.WORK_inviterCustList);
        int customerId = response.jsonPath().getInt("data.list[0].custId");

        params.clear();
        params.put("custId", customerId);
        params.put("type", 1);
        response = network.getResponse(params,BasicConfig.WORK_header);
        String introducer = response.jsonPath().getString("data.introducer");
        String inviteName = response.jsonPath().getString("data.inviteName");
        String expertName = response.jsonPath().getString("data.expertName");
        String sellerName = response.jsonPath().getString("data.sellerName");
        Assert.assertEquals(introducer,"自动化测试用户",network.message(params,BasicConfig.WORK_updateAddWxStatus,"转介绍客户的介绍人错误",response.body().asString()));
        Assert.assertEquals(inviteName,"勿动-自动化测试邀约",network.message(params,BasicConfig.WORK_updateAddWxStatus,"转介绍客户的当前邀约与介绍人不一致",response.body().asString()));
        Assert.assertNull(expertName,network.message(params,BasicConfig.WORK_updateAddWxStatus,"转介绍客户的当前销售不为空",response.body().asString()));
        Assert.assertNull(sellerName,network.message(params,BasicConfig.WORK_updateAddWxStatus,"转介绍客户的当前专家不为空",response.body().asString()));
    }

    @Test(description = "查看客户动态",priority = 39)
    public void 查看客户动态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("logDays", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_operation);
        int logSize = response.jsonPath().getInt("data.list[0].dayLog.size()");
        Assert.assertTrue(logSize>0,network.message(params,BasicConfig.WORK_operation,"客户动态条数错误",response.body().asString()));
    }

    @Test(description = "姓名模糊查找客户",priority = 40)
    public void 姓名模糊查找客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化");
        Response response = network.getResponse(params,BasicConfig.WORK_fuzzyCustName);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.WORK_fuzzyCustName,"客户查找结果为空",response.body().asString()));
    }


    @Test(description = "新建日程",priority = 41)
    public void 新建日程(){
        //获取日程提醒数量
        otoInviterAuth();
        Response listRes = network.getResponse(BasicConfig.WORK_notifyList);
        int size = listRes.jsonPath().getInt("data.size()");

        //新建日程
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",cust_id);
        params.put("notifyTime",now + 3600000);
        params.put("type","phone");
        Response scheduleRes =network.postResponse(params,BasicConfig.WORK_saveOrModifySchedule);
        boolean success = scheduleRes.jsonPath().getBoolean("data");
        Assert.assertTrue(success,network.message(BasicConfig.WORK_saveOrModifySchedule,"新建日程失败",scheduleRes.body().asString()));

        //日程通知数量增加
        Response listRes2 = network.getResponse(BasicConfig.WORK_notifyList);
        int size2 = listRes2.jsonPath().getInt("data.size()");
        Assert.assertTrue(size<size2,network.message(BasicConfig.WORK_notifyList,"日程通知未展示新建日程",listRes.body().asString()));
    }

    @Test(description = "取消日程",priority = 42)
    public void 取消日程(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",cust_id);
        Response response =network.postResponse(params,BasicConfig.WORK_cancelSchedule);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.WORK_cancelSchedule,"取消日程失败",response.body().asString()));
    }

    @Test(description = "邀约查看任务",priority = 43)
    public void 邀约查看任务(){
        otoInviterAuth();
        sleep(2000);
        Response response = network.getResponse(BasicConfig.WORK_statisticHeader);
        int listSize = response.jsonPath().getInt("data.size()");
        int finishCustNum = response.jsonPath().getInt("data[0].finishCustNum");
        Assert.assertEquals(listSize,1,network.message(BasicConfig.WORK_taskList,"待完成客户数统计错误",response.body().asString()));
        Assert.assertEquals(finishCustNum,0,network.message(BasicConfig.WORK_statisticHeader,"销售任务统计错误",response.body().asString()));
    }

    @Test(description = "查看承接客户任务明细",priority = 44)
    public void 查看承接客户任务明细(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("taskConfId",7); //任务配置id，4:联系未跟进的客户，5:复拨未接通的客户，6:超过N天未跟进的客户
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response = network.getResponse(params,BasicConfig.WORK_taskList);
        int finishCustNum = response.jsonPath().getInt("data.finishCustNum");
        int listSize = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(finishCustNum,0,network.message(params,BasicConfig.WORK_taskList,"已完成数量记录错误",response.body().asString()));
        Assert.assertEquals(listSize,6,network.message(params,BasicConfig.WORK_taskList,"待完成客户数统计错误",response.body().asString()));
    }


    @Test(description = "邀约完成任务",priority = 45)
    public void 邀约完成任务(){
        //notDeal -未接通，dealing-已接通
        callling("18248405155","15136361301",0,"notDeal");
        callling("18248405155","15136361301",0,"notDeal");
        callling("18248405155","15136361302",0,"notDeal");
        callling("18248405155","15136361303",30,"dealing");
        sleep(3000);
        //销售完成面访，跟进时间更新，联系新客户任务完成
        HashMap<String,Object> params = new HashMap<>();
        params.put("taskConfId",7);
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response = network.getResponse(params,BasicConfig.WORK_taskList);
        int finishCustNum = response.jsonPath().getInt("data.finishCustNum");
        Assert.assertEquals(finishCustNum,2,network.message(params,BasicConfig.WORK_taskList,"已完成数量记录错误",response.body().asString()));
    }

    @Test(description = "校验通话后显示回填弹窗",priority = 46)
    public void 校验通话后显示回填弹窗(){
        sleep(1000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_showFeedback);
        boolean data = response.jsonPath().getBoolean("data.hasUndoneFeedback");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_showFeedback,"电话表单回填状态错误：为不需要回填",response.body().asString()));
        callRecordId = response.jsonPath().getInt("data.recordId");

        sleep(1000);
        params.put("custId", cust_id+2);
        response = network.getResponse(params,BasicConfig.WORK_showFeedback);
        data = response.jsonPath().getBoolean("data.hasUndoneFeedback");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_showFeedback,"电话表单回填状态错误：为不需要回填",response.body().asString()));
    }

    @Test(description = "提交通话信息",priority = 47)
    public void 提交通话信息(){
        sleep(1000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("addWxStatus", 7);
        params.put("attentionOldCommunity", "客户最关注养老社区什么");
        params.put("considerAgedForWho", "为谁考虑养老");
        params.put("custAddress", "杭州市文新地铁站");
        params.put("custAge", 62);
        params.put("custDescription", "客户通话的备注");
        params.put("custGender", 1);
        params.put("custName","自动化测试用户");
        params.put("followWeight", 2);
        params.put("recordId", callRecordId);
        params.put("viewRetireCommunity", "社区参观情况");
        Response response = network.postResponse(params,BasicConfig.WORK_callSubmit);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_callSubmit,"提交通话信息失败",response.body().asString()));
    }

    @Test(description = "校验邀约的通话统计信息",priority = 48)
    public void 校验邀约的通话统计信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("type", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_header);
        int allCallTimes= response.jsonPath().getInt("data.allCallTimes");
        int allCallTime= response.jsonPath().getInt("data.allCallTime");
        int callTimes= response.jsonPath().getInt("data.callTimes");
        String lastCallTime= response.jsonPath().getString("data.lastCallTime");
        Assert.assertEquals(allCallTimes,2,network.message(params,BasicConfig.WORK_header,"新客户总call次数非0",response.body().asString()));
        Assert.assertEquals(allCallTime,0,network.message(params,BasicConfig.WORK_header,"新客户总通话时间非0",response.body().asString()));
        Assert.assertEquals(callTimes,0,network.message(params,BasicConfig.WORK_header,"新客户总通话次数非0",response.body().asString()));
        Assert.assertNull(lastCallTime,network.message(params,BasicConfig.WORK_header,"新客户总通话次数非0",response.body().asString()));

        params.put("custId", cust_id+2);
        params.put("type", 1);
        response = network.getResponse(params,BasicConfig.WORK_header);
        allCallTimes= response.jsonPath().getInt("data.allCallTimes");
        allCallTime= response.jsonPath().getInt("data.allCallTime");
        callTimes= response.jsonPath().getInt("data.callTimes");
        lastCallTime= response.jsonPath().getString("data.lastCallTime");
        Assert.assertEquals(allCallTimes,1,network.message(params,BasicConfig.WORK_header,"新客户总call次数非0",response.body().asString()));
        Assert.assertEquals(allCallTime,30,network.message(params,BasicConfig.WORK_header,"新客户总通话时间非0",response.body().asString()));
        Assert.assertEquals(callTimes,1,network.message(params,BasicConfig.WORK_header,"新客户总通话次数非0",response.body().asString()));
        Assert.assertNotNull(lastCallTime,network.message(params,BasicConfig.WORK_header,"新客户总通话次数非0",response.body().asString()));
    }

    @Test(description = "关闭的相关权限",priority = 49)
    public void 关闭新客户认领权限和回收客户认领权限(){
        otoManagerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", MANAGER_ID);
        params.put("sellerStatus", 1);
        params.put("callPermission", 0);
        params.put("assignNewCustPermission", 0);
        params.put("assignRecycleCustPermission", 0);
        params.put("lookCustPhonePermission", 0);
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_updatePermission);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(BasicConfig.WORK_MNG_updatePermission,"关闭新客户认领权限和回收客户认领权限失败",response.body().asString()));

        params.put("id", INVITE_ID);
        response = network.postResponse(params, BasicConfig.WORK_MNG_updatePermission);
        success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(BasicConfig.WORK_MNG_updatePermission,"关闭新客户认领权限和回收客户认领权限失败",response.body().asString()));
    }

    @Test(description = "无新客户认领权限不可查看新客户列表",priority = 50)
    public void 无新客户认领权限不可查看新客户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params,BasicConfig.WORK_freshList);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(BasicConfig.WORK_freshList,"无新客户认领权限可查看新客户列表",response.body().asString()));
    }

    @Test(description = "无回收客户认领权限不可查看回收客户列表",priority = 51)
    public void 无回收客户认领权限不可查看回收客户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params,BasicConfig.WORK_recycleList);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(BasicConfig.WORK_logout,"无回收客户认领权限可查看回收客户列表",response.body().asString()));
    }

    @Test(description = "无查看微信权限不可查看客户号码",priority = 52)
    public void 无查看微信权限不可查看客户号码(){
        otoInviterAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_phone);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(BasicConfig.WORK_phone,"无查看微信权限可查看客户号码",response.body().asString()));
    }

    @Test(description = "关闭呼叫权限_呼叫失败",priority = 53)
    public void 关闭呼叫权限_呼叫失败(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.postResponse(params,BasicConfig.WORK_call);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_call,"关闭呼叫权限后呼叫成功",response.body().asString()));
    }
    @Test(description = "仅禁用账号使用权限",priority = 54)
    public void 仅禁用账号使用权限(){
        otoManagerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", INVITE_ID);
        params.put("sellerStatus", 0);
        params.put("callPermission", 1);
        params.put("assignNewCustPermission", 1);
        params.put("assignRecycleCustPermission", 1);
        params.put("lookCustPhonePermission", 1);
        Response response = network.postResponse(params, BasicConfig.WORK_MNG_updatePermission);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(BasicConfig.WORK_MNG_updatePermission,"禁用邀约账号权限失败",response.body().asString()));
    }

    @Test(description = "关闭销售权限_访问失败",priority = 55)
    public void 关闭销售权限_访问失败(){
        otoInviterAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        Response response = network.getResponse(params,BasicConfig.WORK_inviterCustList);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_inviterCustList,"关闭邀约权限后访问成功",response.body().asString()));

        params.clear();
        otoManagerAuth();
        params.put("id", MANAGER_ID);
        params.put("sellerStatus", 1);
        params.put("callPermission", 1);
        params.put("assignNewCustPermission", 1);
        params.put("assignRecycleCustPermission", 1);
        params.put("lookCustPhonePermission", 1);
        response = network.postResponse(params, BasicConfig.WORK_MNG_updatePermission);
        success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(BasicConfig.WORK_MNG_updatePermission,"开启权限失败",response.body().asString()));


        params.put("id", INVITE_ID);
        response = network.postResponse(params, BasicConfig.WORK_MNG_updatePermission);
        success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(BasicConfig.WORK_MNG_updatePermission,"开启权限失败",response.body().asString()));
    }

    @Test(description ="跟进中可重新激活更新来源",priority = 59)
    public void 跟进中可重新激活更新来源(){
        //重新填写表单
        HashMap<String,Object> params = new HashMap<>();
        createCustomerFromDetail(1,cust_id-0,"自动化测试用户0","15136361301","自动化未激活用户",false);

        //查看客户未被重新激活，客户来源更新，姓名和产品组不变
        params.clear();
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        params.put("phoneNum", "15136361301");
        Response response = network.getResponse(params,BasicConfig.MANAGER_oto_customerList);
        int totalCount = response.jsonPath().getInt("data.totalCount");
        Assert.assertTrue(totalCount == 1,network.message(params,BasicConfig.MANAGER_oto_customerList,"未查找到该客户",response.body().asString()));
        String custName = response.jsonPath().getString("data.list[0].custName");
        String custFromSourceDesc = response.jsonPath().getString("data.list[0].custFromSourceDesc");
        int custStatus = response.jsonPath().getInt("data.list[0].custStatus");
        Assert.assertEquals(custName,"自动化测试用户",network.message(params,BasicConfig.MANAGER_oto_customerList,"客户姓名更新",response.body().asString()));
        Assert.assertEquals(custFromSourceDesc,"销售自建-转介绍客户-转介绍客户",network.message(params,BasicConfig.MANAGER_oto_customerList,"客户来源未更新",response.body().asString()));
        Assert.assertEquals(custStatus,1,network.message(params,BasicConfig.MANAGER_oto_customerList,"客户的资源池错误",response.body().asString()));
    }

    @Test(description = "销售间客户动态取消隔离",priority = 60)
    public void 销售间客户动态取消隔离(){
        //重新分配邀约
        assignSeller(cust_id,320,true,1,"crm");

        //查看客户动态
        otoInviterAuth2();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",cust_id);
        params.put("logDays",1);
        Response logRes = network.getResponse(params,BasicConfig.WORK_operation);
        int logSize = logRes.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(logSize>0,network.message(BasicConfig.WORK_operation,"客户动态隔离失败",logRes.body().asString()));
    }

    @Test(description = "编辑客户专家评价",priority = 61)
    public void 编辑客户专家评价(){
        otoLeaderAuth();
        assignSeller(cust_id,EXPERT_ID,true,3,"crm");
        assignSeller(cust_id,SELLER_ID,true,2,"crm");

        otoExpertAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("expertRemark", "专家的评价");
        Response response = network.postResponse(params,BasicConfig.WORK_updateExpertRemark);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_updateExpertRemark,"修改专家评价失败",response.body().asString()));

        headerDeatil(1,"expertRemark","专家的评价");
    }


    @Test(description = "查询成员列表",priority = 64)
    public void 查询成员列表(){
        otoInviterAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("name", "自动化");
        Response response = network.postResponse(params,BasicConfig.WORK_sellerList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,7,network.message(params,BasicConfig.WORK_sellerList,"当前跟进人模糊搜索数量错误",response.body().asString()));
    }

    @Test(description = "放弃客户进入回收池",priority = 65)
    public void 放弃客户进入回收池(){
        abandonCust(cust_id);

        sleep(1000);
        Response response = network.getResponse(BasicConfig.WORK_staticHeader);
        int totalNum = response.jsonPath().getInt("data.totalNum");
        int num = header.get("totalNum");
        Assert.assertEquals(totalNum, num,network.message(BasicConfig.WORK_staticChart,"客户总数未更新",response.body().asString()));

        //查询销售总系数
        response =network.getResponse(BasicConfig.WORK_coefficient_detail);
        Double totalCoefficient = response.jsonPath().getDouble("data.totalCoefficient");
        Assert.assertEquals(totalCoefficient,coefficient.get("totalCoefficient"),network.message(BasicConfig.WORK_coefficient_detail,"放弃客户销售总系数变化",response.body().asString()));
    }

    @Test(description ="放弃客户后重新激活进入预备池",priority = 66)
    public void 放弃客户后重新激活进入预备池(){
        //重新填写表单
        PubForm("15136361301","自动化激活用户");

        //查看客户被重新激活并姓名和产品组更新
        HashMap<String,Object> params = new HashMap<>();
        params.clear();
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        params.put("phoneNum", "15136361301");
        Response response = network.getResponse(params,BasicConfig.MANAGER_oto_customerList);
        int totalCount = response.jsonPath().getInt("data.totalCount");
        Assert.assertTrue(totalCount == 1,network.message(params,BasicConfig.MANAGER_oto_customerList,"未查找到该客户",response.body().asString()));
        String custName = response.jsonPath().getString("data.list[0].custName");
        String custFromSourceDesc = response.jsonPath().getString("data.list[0].custFromSourceDesc");
        int custStatus = response.jsonPath().getInt("data.list[0].custStatus");
        Assert.assertEquals(custName,"自动化测试用户",network.message(params,BasicConfig.MANAGER_oto_customerList,"客户姓名更新",response.body().asString()));
        Assert.assertEquals(custFromSourceDesc,"投放客户-自建落地页-表单",network.message(params,BasicConfig.MANAGER_oto_customerList,"客户来源未更新",response.body().asString()));
        Assert.assertEquals(custStatus,0,network.message(params,BasicConfig.MANAGER_oto_customerList,"客户的资源池错误",response.body().asString()));

        //分配给邀约
        ssoLogin();
        sleep(5000);
        assignSeller(cust_id,INVITE_ID,true,1,"crm");
    }

    @Test(description = "查询认领客户评价不清空",priority = 67)
    public void 查询认领客户评价不清空(){
        headerDeatil(1,"followWeight","2");
//        HashMap<String,Object> params = new HashMap<>();
//        params.put("custId", cust_id);
//        params.put("type", 1);
//        Response response = network.getResponse(params,BasicConfig.WORK_header);
//        int followWeight = response.jsonPath().getInt("data.followWeight");
//        Assert.assertEquals(followWeight,2,network.message(params,BasicConfig.WORK_header,"客户权重未清空",response.body().asString()));
    }
    @Test(description = "查询直播动态",priority = 68)
    public void 查询直播动态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_liveDynamic);
        int size = response.jsonPath().getInt("data.liveDynamicListVoList.size()");
        Assert.assertEquals(size,0,network.message(params,BasicConfig.WORK_liveDynamic,"直播动态错误",response.body().asString()));
    }

    @Test(description = "总监查看团队客户列表",priority = 70)
    public void 总监查看团队客户列表(){
        otoLeaderAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 50);
        Response response = network.postResponse(params,BasicConfig.WORK_SellerCustList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.WORK_SellerCustList,"总监的团队客户为空",response.body().asString()));
    }

    @Test(description = "查看即将改派告警客户",priority = 71)
    public void 查看即将改派告警客户(){
        Response response =network.getResponse(BasicConfig.WORK_notifyWarning);
        int assignWarnNum = response.jsonPath().getInt("data.assignWarnNum");
        Assert.assertEquals(assignWarnNum,1,network.message(BasicConfig.WORK_notifyWarning,"即将被改派客户不为1",response.body().asString()));
    }

    @Test(description = "查看即将改派客户列表",priority = 72)
    public void 查看即将改派客户列表(){
        Response response =network.getResponse(BasicConfig.WORK_warnList);
        int assignWarnNum = response.jsonPath().getInt("data.assignWarnNum");
        int size = response.jsonPath().getInt("data.vos.size()");
        int fromAssignTypes = response.jsonPath().getInt("data.vos[0].fromAssignTypes.size()");
        Assert.assertEquals(assignWarnNum,1,network.message(BasicConfig.WORK_warnList,"即将被改派客户不为1",response.body().asString()));
        Assert.assertEquals(size,1,network.message(BasicConfig.WORK_warnList,"即将被改派客户列表不为1",response.body().asString()));
        Assert.assertEquals(fromAssignTypes,2,network.message(BasicConfig.WORK_warnList,"即将被改派原因非2个",response.body().asString()));
    }




    @Test(description = "公域引流_删除标签",priority = 88)
    public void 公域引流_删除标签(){
        ssoLogin();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", tagId);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_deleteTag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_deleteTag,"删除标签失败",response.body().asString()));

        params.clear();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        response = network.getResponse(params,BasicConfig.MANAGER_oto_tagList);
        int id = response.jsonPath().getInt("data.list[0].id");
        Assert.assertTrue(id!= tagId ,network.message(params,BasicConfig.MANAGER_oto_tagList,"标签删除后依旧显示",response.body().asString()));
    }

    @Test(description = "查看我的预约订单列表",priority = 90)
    public void 查看我的预约订单列表(){
        agent2Tku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response =network.getResponse(params,BasicConfig.PHONE_getReservationList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2,network.message(BasicConfig.PHONE_getReservationList,"查看预约列表不为空",response.body().asString()));

        int bookingStatus = response.jsonPath().getInt("data[0].bookingStatus");
        Assert.assertEquals(bookingStatus,0,network.message(BasicConfig.PHONE_getReservationList,"预约状态错误：非待参观",response.body().asString()));
    }




    public static void callling(String sellerPhone,String custPhone,int length,String callState){
        //通话回传
        String  CALL_URL = CALL_BACK_1 +sellerPhone + "&CalledNo="+  custPhone + CALL_BACK_2 + length +"&State=" +callState + CALL_BACK_3;
        Response response = network.getResponse(CALL_URL);
    }



    //确认准客户面访任务列表
    public void taskList(int finish,int status){
//        sleep(2000);
//        HashMap<String,Object> params = new HashMap<>();
//        params.put("taskConfId",7);
//        Response response =network.getResponse(params,BasicConfig.WORK_invitation_list);
//        int goalCount = response.jsonPath().getInt("data.goalCount");
//        int finishCustNum = response.jsonPath().getInt("data.finishCustNum");
//        int size = response.jsonPath().getInt("data.list.size()");
//        int inviteStatus = response.jsonPath().getInt("data.list[0].inviteStatus");
//        Assert.assertEquals(goalCount,1 ,network.message(params,BasicConfig.WORK_invitation_list,"面访列表的目标数量不为1",response.body().asString()));
//        Assert.assertEquals(finishCustNum,finish ,network.message(params,BasicConfig.WORK_invitation_list,"面访列表的完成数量不为"+finish,response.body().asString()));
//        Assert.assertEquals(size,1 ,network.message(params,BasicConfig.WORK_invitation_list,"面访列表的客户数量不为1",response.body().asString()));
//        Assert.assertEquals(inviteStatus,status ,network.message(params,BasicConfig.WORK_invitation_list,"面访列表的客户状态不为"+status,response.body().asString()));
//        taskId = response.jsonPath().getInt("data.list[0].id");
    }

    public static void assignSeller(int customerId,int sellerId,boolean result,int assignType,String entrance) {
        HashMap<String, Object> params = new HashMap<>();
        params.put("customerId", customerId);
        params.put("assignType", assignType);
        params.put("sellerId", sellerId);

        String path;
        if(entrance.equals("manage")){//如果是管理后台进入则路径为管理后台的接口，否则为CRM的接口
            path = MANAGER_oto_assignSeller;
        }else if(entrance.equals("crm")){
            path =WORK_MNG_assignSeller;
        }else{
            path = WORK_assignSeller;
        }
        Response response = network.postResponse(params, path);
        if (result){
            boolean data = response.jsonPath().getBoolean("data");
            Assert.assertTrue(data, network.message(params, path, "分配客户失败", response.body().asString()));
        }
        else {
            boolean success = response.jsonPath().getBoolean("success");
            Assert.assertFalse(success, network.message(params, path, "销售不同产品组分配客户成功", response.body().asString()));
        }
    }

    public void menuList(int menuSize){
        Response response = network.getResponse(BasicConfig.WORK_menu_list);
        int size = response.jsonPath().getInt("data.menuList.size()");
        Assert.assertEquals(size,menuSize,network.message(BasicConfig.WORK_notifyList,"菜单列表数量错误",response.body().asString()));
    }

    public void tagList(HashMap<Integer, Object> tags){
        Response response = network.getResponse(BasicConfig.WORK_tagList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,tags.size(),network.message(BasicConfig.WORK_tagList,"标签数量错误",response.body().asString()));
        for (int key: tags.keySet()
             ) {
            String tagName = response.jsonPath().getString("data.find{it.tagId =="+key+"}.tagName");
            Assert.assertEquals(tagName,tags.get(key),network.message(BasicConfig.WORK_tagList,"标签名称错误",response.body().asString()));
        }
    }

    public static void abandonCust(int c_id){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", c_id);
        params.put("abandonReasonType", 3);
        params.put("abandonRemark", "放弃原因"+new Date());
        Response response = network.postResponse(params,BasicConfig.WORK_abandonCust);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_abandonCust,"放弃客户失败",response.body().asString()));
    }

    public static void createCustomerFromDetail(int addType,int introducerId, String introducerName,String custPhoneNum,String custName,boolean result){
        //1-从客户详情创建转介绍客户
        HashMap<String,Object> params = new HashMap<>();
        params.put("addType", addType);
        params.put("introducerId", introducerId);
        params.put("introducerName", introducerName);
        params.put("custPhoneNum", custPhoneNum);
        params.put("custName", custName);
        Response response = network.postResponse(params,BasicConfig.WORK_introduce_save);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertEquals(success,result,network.message(params,BasicConfig.WORK_introduce_save,"创建转介绍客户结果非"+result,response.body().asString()));

    }

    public static void headerDeatil(int type,String key,String value){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("type", type);
        Response response = network.getResponse(params,BasicConfig.WORK_header);
        String result= response.jsonPath().getString("data."+ key);
        Assert.assertEquals(result,value,network.message(params,BasicConfig.WORK_header,"客户的"+key+"非"+value,response.body().asString()));
    }
}
