package com.oto.cases.otoseller;

import com.oto.bean.SignCustomer;
import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.utils.IdMakeUtil;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

import static com.oto.cases.otoseller.Invite.*;
import static com.oto.cases.otoseller.Manager.cust_id;
import static com.oto.cases.otoseller.Work.*;
import static com.oto.config.BasicConfig.*;
import static com.oto.utils.ThreadSleepUtils.sleep;

public class Activity implements Authorization {
    public int acitityId;
    public String activity_day;
    @BeforeTest
    public void setUp(){
        Date date = new Date();
        SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd ");
        activity_day = sdt.format(date);
        Sunday();
    }

    @Test(description = "新建营销活动",priority = 1)
    public void 新建营销活动(){
        otoPMAuth();

        HashMap<String,Object> params = new HashMap<>();
        params.put("isNeedInvite", 1);
        ArrayList depts = new ArrayList();
        HashMap<String,Object> deptItem1 = new HashMap<>();
        HashMap<String,Object> deptItem2 = new HashMap<>();
        deptItem1.put("deptId",47);
        deptItem1.put("groupNum",2);
        deptItem2.put("deptId",30);
        deptItem2.put("groupNum",1);
        depts.add(deptItem1);
        depts.add(deptItem2);
        params.put("paramList", depts);
        params.put("isNeedInvite", 1);
        params.put("maTime", activity_day+"11:30");
        params.put("sceneConfId", 17);
        Response response = network.postResponse(params, BasicConfig.WORK_saveActivity);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_saveActivity,"新建营销活动失败",response.body().asString()));

        otoManagerAuth();
        params.put("sceneConfId", 440);
        params.put("totalCost", 99999999.99);
        params.put("maTime", activity_day+"12:00");
        response = network.postResponse(params, BasicConfig.WORK_saveActivity);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_saveActivity,"新建营销活动失败",response.body().asString()));

        params.clear();
        params.put("totalCost", 0.01);
        params.put("sceneConfId", 440);
        params.put("isNeedInvite", 0);
        params.put("maTime", activity_day+"11:20");
        response = network.postResponse(params, BasicConfig.WORK_saveActivity);
    }

    @Test(description = "查看营销活动",priority = 2)
    public void 查看营销活动(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("beginTime", activity_day+"00:00:00");
        params.put("endTime", activity_day+"23:59:59");
        Response response = network.postResponse(params, BasicConfig.WORK_listActivity);
        int size = response.jsonPath().getInt("data[0].voList.size()");
        Assert.assertEquals(size,3,network.message(params,BasicConfig.WORK_listActivity,"营销活动数量错误",response.body().asString()));
        acitityId = response.jsonPath().getInt("data[0].voList[2].id");
        String sceneName = response.jsonPath().getString("data[0].voList[0].sceneName");
        Assert.assertEquals(sceneName,"勿动_自动化邀约场景",network.message(params,BasicConfig.WORK_listActivity,"营销活动排序错误",response.body().asString()));
        String timeInterval1 = response.jsonPath().getString("data[0].voList[0].timeInterval");
        Assert.assertEquals(timeInterval1, "am",network.message(params,BasicConfig.WORK_listActivity,"营销活动排序错误",response.body().asString()));
        String timeInterval2 = response.jsonPath().getString("data[0].voList[2].timeInterval");
        Assert.assertEquals(timeInterval2, "pm",network.message(params,BasicConfig.WORK_listActivity,"营销活动排序错误",response.body().asString()));
    }

    @Test(description = "修改营销活动",priority = 3)
    public void 修改营销活动(){
        otoPMAuth();

        HashMap<String,Object> params = new HashMap<>();
        ArrayList depts = new ArrayList();
        HashMap<String,Object> deptItem1 = new HashMap<>();
        deptItem1.put("deptId",47);
        deptItem1.put("groupNum",1);
        depts.add(deptItem1);
        params.put("paramList", depts);
        params.put("id", acitityId-1);
        params.put("id", acitityId);
        params.put("isNeedInvite", 1);
        params.put("sceneConfId", 440);
        params.put("totalCost",0);
        params.put("maTime", activity_day+"20:00");
        Response response = network.postResponse(params, BasicConfig.WORK_modifyActivity);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_modifyActivity,"修改营销活动失败",response.body().asString()));
    }

    @Test(description = "查询营销活动详情",priority = 4)
    public void 查询营销活动详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", acitityId-1);
        Response response = network.getResponse(params, BasicConfig.WORK_detailActivity);
        int paramList = response.jsonPath().getInt("data.paramList.size()");
        Assert.assertEquals(paramList,1,network.message(params,BasicConfig.WORK_detailActivity,"营销活动详情错误",response.body().asString()));
    }

    @Test(description = "删除营销活动",priority = 5)
    public void 删除营销活动(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id",acitityId+1);
        Response response = network.postResponse(params, BasicConfig.WORK_cancelActivity);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_cancelActivity,"修改营销活动部门组数错误",response.body().asString()));
    }

    @Test(description = "邀约记录为今天实时分配",priority = 6)
    public void 邀约记录为今天实时分配(){
        otoInviterAuth();
        abandonCust(cust_id-1);//自动化客户0
        sleep(2000);
        assignSeller(cust_id-1,INVITE_ID,true,1,"crm");
        sleep(2000);
        updateInvite(1,now + 3600000,cust_id-1);

        abandonCust(cust_id+1);//自动化客户2
        sleep(2000);
        assignSeller(cust_id+1,INVITE_ID,true,1,"crm");
        sleep(2000);
        updateInvite(1,now + 3600000,cust_id+1);
        sleep(2000);
        updateInvite(0,now + 3600000,cust_id+1);

        abandonCust(cust_id+2);//自动化客户3
        sleep(2000);
        assignSeller(cust_id+2,INVITE_ID,true,1,"crm");
        sleep(2000);
        updateInvite(1,now + 3600000,cust_id+2);

        otoAssistAuth();
        getCalendarlist(today,0,"自动化测试用户2","勿动-自动化测试邀约");
        getCalendarlist(today,2,"自动化测试用户0","勿动-自动化测试邀约");
    }

    @Test(description = "分配邀约卡片",priority = 7)
    public void 分配邀约卡片(){
        //预分配客户0
        HashMap<String,Object> params = new HashMap<>();
        otoInviterAuth();
        params.put("recordId",recordItem.recordId);
        params.put("takeLookId",SELLER_ID);
        params.put("expertId",EXPERT_ID);
        Response response =network.postResponse(params,BasicConfig.WORK_calendar_preAssign);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_calendar_preAssign,"预分配失败",response.body().asString()));

        //重新邀约客户2
        updateInvite(1,now + 3600000,cust_id+1);
        getCalendarlist(today,2,"自动化测试用户2","勿动-自动化测试邀约");
        params.put("recordId",recordItem.recordId);
        response =network.postResponse(params,BasicConfig.WORK_calendar_preAssign);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_calendar_preAssign,"预分配失败",response.body().asString()));
        updateInvite(0,now + 3600000,cust_id+1);//再次已鸽

        //立即分配客户3
        getCalendarlist(today,2,"自动化测试用户3","勿动-自动化测试邀约");
        params.put("recordId",recordItem.recordId);
        response =network.postResponse(params,BasicConfig.WORK_calendar_nowAssign);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_calendar_nowAssign,"立即分配失败",response.body().asString()));
    }


    @Test(description = "查询活动签到配置",priority = 8)
    public void 查询活动签到配置(){
        WXCustomerTku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("activityId", IdMakeUtil.encodingId((long) acitityId+1));
        Response response = network.getResponse(params, BasicConfig.WX_signDetail);
        int signStatus = response.jsonPath().getInt("data.signStatus");
        boolean sign = response.jsonPath().getBoolean("data.sign");
        Assert.assertEquals(signStatus,1,network.message(params,BasicConfig.WX_signDetail,"活动不可签到",response.body().asString()));
        Assert.assertFalse(sign,network.message(params,BasicConfig.WX_signDetail,"用户已签到",response.body().asString()));
    }

    @Test(description = "活动签到",priority = 9)
    public void 活动签到(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("firstSubmit", true);
        params.put("activityId", IdMakeUtil.encodingId((long) acitityId+1));
        Response response = network.postResponse(params, BasicConfig.WX_signSubmit);
        boolean needExtra = response.jsonPath().getBoolean("data.needExtra");
        Assert.assertFalse(needExtra,network.message(params,BasicConfig.WX_signSubmit,"用户签到失败，在库手机号需要二次填写",response.body().asString()));
    }

    @Test(description = "专家查看提报列表",priority = 10)
    public void 专家查看提报列表(){
        WXExpertTTku();
        sellerSubmitRecord(0,1);
    }

    @Test(description = "专家查看今日签到活动情况",priority = 11)
    public void 专家查看今日签到活动情况(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("date", today);
        Response response = network.postResponse(params, BasicConfig.WX_submitRecordDetail);
        int confSize = response.jsonPath().getInt("data.list.size");
        Assert.assertEquals(confSize,1,network.message(params,BasicConfig.WX_submitRecordDetail,"签到场景数错误",response.body().asString()));
        int size = response.jsonPath().getInt("data.list[0].custList.size");
        int configId = response.jsonPath().getInt("data.list[0].configId");
        Assert.assertEquals(configId,440,network.message(params,BasicConfig.WX_submitRecordDetail,"签到活动的见面场景错误",response.body().asString()));
        Assert.assertEquals(size,3,network.message(params,BasicConfig.WX_submitRecordDetail,"签到活动量数错误",response.body().asString()));
        int signStatus0 = response.jsonPath().getInt("data.list[0].custList.find{it.custName.equals(\"自动化测试用户0\")}.signStatus");
        int signStatus1 = response.jsonPath().getInt("data.list[0].custList.find{it.custName.equals(\"自动化测试用户2\")}.signStatus");
        int signStatus2 = response.jsonPath().getInt("data.list[0].custList.find{it.custName.equals(\"自动化测试用户3\")}.signStatus");
        Assert.assertEquals(signStatus0,-1,network.message(params,BasicConfig.WX_submitRecordDetail,"已分配的签到状态非【需确认】",response.body().asString()));
        Assert.assertEquals(signStatus1,0,network.message(params,BasicConfig.WX_submitRecordDetail,"已鸽的签到状态非【未到场】",response.body().asString()));
        Assert.assertEquals(signStatus2,2,network.message(params,BasicConfig.WX_submitRecordDetail,"已签到的签到状态非【已签到】",response.body().asString()));
    }

    @Test(description = "专家查看今日非签到活动场景",priority = 12)
    public void 专家查看今日非签到活动场景(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("date", today);
        Response response = network.postResponse(params, BasicConfig.otherDetailForSeller);
        int confSize = response.jsonPath().getInt("data.vos.size");
        Assert.assertEquals(confSize,1,network.message(params,BasicConfig.otherDetailForSeller,"签到场景数错误",response.body().asString()));
        int configId = response.jsonPath().getInt("data.vos[0].configId");
        Assert.assertEquals(configId,17,network.message(params,BasicConfig.otherDetailForSeller,"签到活动的见面场景错误",response.body().asString()));
    }

    @Test(description = "专家确认客户到场",priority = 13)
    public void 专家确认客户到场(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("date", today);
        params.put("custId", IdMakeUtil.encodingId((long)cust_id-1));
        params.put("configId", 440);
        params.put("status", 1);
        params.put("timeInterval", "am");
        Response response = network.postResponse(params, BasicConfig.WX_checkSign);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WX_checkSign,"确认客户到场失败",response.body().asString()));

        sellerSubmitRecord(0,2);
    }

    @Test(description = "专家查看提报可选择的其他见面场景",priority = 14)
    public void 专家查看提报可选择的其他见面场景(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("date", today);
        Response response = network.postResponse(params, BasicConfig.WX_interviewConfigList);
        int size = response.jsonPath().getInt("data.list.size");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.WX_interviewConfigList,"其他见面场景数错误",response.body().asString()));
    }

    @Test(description = "专家查看见面目的列表",priority = 15)
    public void 专家查看见面目的列表(){
        Response response = network.getResponse(BasicConfig.WX_custPhase);
        int size = response.jsonPath().getInt("data.size");
        Assert.assertEquals(size,5,network.message(BasicConfig.WX_custPhase,"见面目的数错误",response.body().asString()));
    }

    @Test(description = "专家搜索跟进中客户",priority = 16)
    public void 专家搜索跟进中客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化测试用户3");
        Response response = network.getResponse(params, BasicConfig.WX_searchCust);
        int size = response.jsonPath().getInt("data.list.size");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.WX_searchCust,"搜索跟进中客户数量为0",response.body().asString()));
    }

    @Test(description = "添加非签到活动和其他见面客户并提报",priority = 17)
    public void 添加非签到活动和其他见面客户并提报(){
        HashMap<String,Object> params = new HashMap<>();
        ArrayList list = new ArrayList();
        list.add(new SignCustomer(IdMakeUtil.encodingId((long)cust_id+3),"am", 226 ,0));
        list.add(new SignCustomer(IdMakeUtil.encodingId((long)cust_id+4),"am", 17,2));
        params.put("date", today);
        params.put("params", list);
        Response response = network.postResponse(params, BasicConfig.WX_submitRecord);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WX_submitRecord,"提报活动量失败",response.body().asString()));

        sellerSubmitRecord(1,2);
    }

    @Test(description = "总监查看部门列表",priority = 18)
    public void 总监查看部门列表(){
        WXLeaderTku();
        Response response = network.getResponse( BasicConfig.WX_deptList);
        int size = response.jsonPath().getInt("data.size");
        Assert.assertEquals(size,2,network.message(BasicConfig.WX_custPhase,"见面目的数错误",response.body().asString()));
    }

    @Test(description = "总监查看今日提报概况",priority = 19)
    public void 总监查看今日提报概况(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("date", today);
        Response response = network.postResponse(params, BasicConfig.WX_leaderHeader);
        int faceCustCount = response.jsonPath().getInt("data.faceCustCount");
        int submitCount = response.jsonPath().getInt("data.submitCount");
        int unSubmitCount = response.jsonPath().getInt("data.unSubmitCount");
        Assert.assertEquals(faceCustCount,4,network.message(params,BasicConfig.WX_leaderHeader,"见面客户数错误",response.body().asString()));
        Assert.assertEquals(submitCount,1,network.message(params,BasicConfig.WX_leaderHeader,"已提交的销售专家数错误",response.body().asString()));
        Assert.assertEquals(unSubmitCount,3,network.message(params,BasicConfig.WX_leaderHeader,"未提交的销售专家数错误",response.body().asString()));
    }

    @Test(description = "总监查看销售专家提报列表",priority = 20)
    public void 总监查看销售专家提报列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("date", today);
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.postResponse(params, BasicConfig.WX_leaderList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,4,network.message(params,BasicConfig.WX_leaderList,"销售专家数数错误",response.body().asString()));
        int submitStatus1 = response.jsonPath().getInt("data.list.find{it.sellerName == '勿动-自动化测试专家'}.submitStatus");
        int submitStatus2 = response.jsonPath().getInt("data.list.find{it.sellerName == '勿动-自动化测试带看'}.submitStatus");
        int configStatistics1 = response.jsonPath().getInt("data.list.find{it.sellerName == '勿动-自动化测试专家'}.configStatistics.size()");
        int configStatistics2 = response.jsonPath().getInt("data.list.find{it.sellerName == '勿动-自动化测试带看'}.configStatistics.size()");
        int custCount = response.jsonPath().getInt("data.list.find{it.sellerName == '勿动-自动化测试带看'}.configStatistics[0].custCount");
        Assert.assertEquals(submitStatus1,1,network.message(params,BasicConfig.WX_leaderList,"专家非【已提报】状态",response.body().asString()));
        Assert.assertEquals(submitStatus2,0,network.message(params,BasicConfig.WX_leaderList,"销售非【未提报】状态",response.body().asString()));
        Assert.assertEquals(configStatistics1,3,network.message(params,BasicConfig.WX_leaderList,"专家的见面总数错误",response.body().asString()));
        Assert.assertEquals(configStatistics2,3,network.message(params,BasicConfig.WX_leaderList,"销售的见面总数错误",response.body().asString()));
        Assert.assertEquals(custCount,2,network.message(params,BasicConfig.WX_leaderList,"销售的签到数不为0",response.body().asString()));
    }

    @Test(description = "总监查看专家今日签到活动情况",priority = 21)
    public void 总监查看专家今日签到活动情况() {
        HashMap<String, Object> params = new HashMap<>();
        params.put("date", today);
        params.put("sellerId", IdMakeUtil.encodingId(284L));
        Response response = network.postResponse(params, BasicConfig.WX_submitRecordDetail);
        int confSize = response.jsonPath().getInt("data.list.size");
        Assert.assertEquals(confSize, 1, network.message(params, BasicConfig.WX_submitRecordDetail, "签到场景数错误", response.body().asString()));
        int size = response.jsonPath().getInt("data.list[0].custList.size");
        int configId = response.jsonPath().getInt("data.list[0].configId");
        Assert.assertEquals(configId, 440, network.message(params, BasicConfig.WX_submitRecordDetail, "签到活动的见面场景错误", response.body().asString()));
        Assert.assertEquals(size, 3, network.message(params, BasicConfig.WX_submitRecordDetail, "签到活动量数错误", response.body().asString()));
        int signStatus0 = response.jsonPath().getInt("data.list[0].custList.find{it.custName.equals(\"自动化测试用户0\")}.signStatus");
        int signStatus1 = response.jsonPath().getInt("data.list[0].custList.find{it.custName.equals(\"自动化测试用户2\")}.signStatus");
        int signStatus2 = response.jsonPath().getInt("data.list[0].custList.find{it.custName.equals(\"自动化测试用户3\")}.signStatus");
        Assert.assertEquals(signStatus0, 1, network.message(params, BasicConfig.WX_submitRecordDetail, "已到场的签到状态非【已到场】", response.body().asString()));
        Assert.assertEquals(signStatus1, 0, network.message(params, BasicConfig.WX_submitRecordDetail, "已鸽的签到状态非【未到场】", response.body().asString()));
        Assert.assertEquals(signStatus2, 2, network.message(params, BasicConfig.WX_submitRecordDetail, "已签到的签到状态非【已签到】", response.body().asString()));
    }

    @Test(description = "总监查看专家今日非签到活动场景",priority = 22)
    public void 总监查看专家今日非签到活动场景(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("date", today);
        params.put("sellerId", IdMakeUtil.encodingId(284L));
        Response response = network.postResponse(params, BasicConfig.WX_otherDetailForLeader);
        int vosSize = response.jsonPath().getInt("data.vos.size()");
        Assert.assertEquals(vosSize,1,network.message(params,BasicConfig.WX_otherDetailForLeader,"非签到活动的场景数错误",response.body().asString()));
        vosSize = response.jsonPath().getInt("data.vos[0].otherVos.size()");
        Assert.assertEquals(vosSize,1,network.message(params,BasicConfig.WX_otherDetailForLeader,"非签到活动的客户数错误",response.body().asString()));
        vosSize = response.jsonPath().getInt("data.otherVos.size()");
        Assert.assertEquals(vosSize,1,network.message(params,BasicConfig.WX_otherDetailForLeader,"其他见面场景的客户数错误",response.body().asString()));
    }


    public void sellerSubmitRecord(int status,int count){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pagesize",20);
        Response response = network.postResponse(params, BasicConfig.WX_sellerSubmitRecordList);
        int submitStatus = response.jsonPath().getInt("data.list[0].submitStatus");
        int custCount = response.jsonPath().getInt("data.list[0].configStatistics.find{it.configId == 440}.custCount");
        Assert.assertEquals(submitStatus,status,network.message(params,BasicConfig.WX_sellerSubmitRecordList,"专家提报状态错误",response.body().asString()));
        Assert.assertEquals(custCount,count,network.message(params,BasicConfig.WX_sellerSubmitRecordList,"已签到数量非1",response.body().asString()));
    }
}
