package com.oto.sql;


import java.sql.*;
import java.util.*;

public class KjyLiveNormalDB {
    private static KjyLiveNormalDB user_Utils;
    //数据库用户名
    private   String USERNAME = "auto_test";
    //数据库密码
    private   String PASSWORD = "881QYHoGGgc09Ngv"; //= "yanzi";
    //驱动信息
    private   String DRIVER="com.mysql.cj.jdbc.Driver";
    //数据库地址
    private   String USER_URL="jdbc:mysql://rm-bp11mkg584kvjr485.mysql.rds.aliyuncs.com:3306/kjy_live_normal";
    private Connection connection;
    private PreparedStatement pstmt;
    private ResultSet resultSet;

    public static synchronized KjyLiveNormalDB getInstance(){
        if (Objects.nonNull(user_Utils)){
            return user_Utils;
        }
        user_Utils = new KjyLiveNormalDB();
        user_Utils.initConnection();
        return user_Utils;
    }
    /**
     * 获得数据库的连接
     * @return
     */
    private Connection initConnection(){
        try {
            try {
                Class.forName(DRIVER);

            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            String url = USER_URL+"?autoReconnect=true&testOnBorrow=true&testWhileIdle=true";
            connection = DriverManager.getConnection(url,USERNAME,PASSWORD);
            System.out.println("数据库连接成功！");
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return connection;
    }

    /**
     * 查询结果只有一行数据
     * @param sql         sql语句
     * @param params      可变参数，替换 ？
     * @return            map
     * @throws SQLException
     */
    public Map<String, Object> findSimpleResult(String sql, Object ...params) throws SQLException{
        if(!connection.isValid(3)){
            System.out.println("mysql connect is not vaild,reconnect.");
            connection.close();
            initConnection();
        }
        Map<String, Object> map = new HashMap<String, Object>();
        int index  = 1;
        pstmt = connection.prepareStatement(sql);
        if(params != null && !(params.length==0)){
            for(int i=0; i<params.length; i++){
                pstmt.setObject(index++, params[i]);
            }
        }
        System.out.println("sql:"+pstmt.toString());
        resultSet = pstmt.executeQuery();//返回查询结果
        ResultSetMetaData metaData = resultSet.getMetaData();
        int col_len = metaData.getColumnCount();
        while(resultSet.next()){
            for(int i=0; i<col_len; i++ ){
                String cols_name = metaData.getColumnName(i+1);
                Object cols_value = resultSet.getObject(cols_name);
                if(cols_value == null){
                    cols_value = "";
                }
                map.put(cols_name, cols_value);
            }
        }
        return map;
    }

    /**
     * 返回多条数据
     * @param sql           sql语句
     * @param params        可变参数，替换 ？
     * @return              list
     * @throws SQLException
     */
    public List<Map<String, Object>> findModeResult(String sql, Object ...params) throws SQLException{
        if(!connection.isValid(3)){
            System.out.println("mysql connect is not vaild,reconnect.");
            connection.close();
            initConnection();
        }
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int index = 1;
        pstmt = connection.prepareStatement(sql);
        if(params != null && !(params.length==0)){
            for(int i=0; i<params.length; i++){
                pstmt.setObject(index++, params[i]);
            }
        }
        resultSet = pstmt.executeQuery();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int cols_len = metaData.getColumnCount();
        while(resultSet.next()){
            Map<String, Object> map = new HashMap<String, Object>();
            for(int i=0; i<cols_len; i++){
                String cols_name = metaData.getColumnName(i+1);
                Object cols_value = resultSet.getObject(cols_name);
                if(cols_value == null){
                    cols_value = "";
                }
                map.put(cols_name, cols_value);
            }
            list.add(map);
        }

        return list;
    }


    /**
     * 执行更新语句
     * @param sql         sql语句
     * @param params      可变参数，替换 ？
     * @return            void
     * @throws SQLException
     */
    public void updataSql(String sql, Object ...params) throws SQLException{
        if(!connection.isValid(3)){
            System.out.println("mysql connect is not vaild,reconnect.");
            connection.close();
            initConnection();
        }
        Map<String, Object> map = new HashMap<String, Object>();
        int index  = 1;
        pstmt = connection.prepareStatement(sql);
        if(params != null && !(params.length==0)){
            for(int i=0; i<params.length; i++){
                pstmt.setObject(index++, params[i]);
            }
        }
        System.out.println("sql:"+pstmt.toString());
        pstmt.executeUpdate();//返回更新结果
    }

    /**
     * 释放数据库连接
     */
    public void releaseConn(){
        if(resultSet != null){
            try{
                resultSet.close();
            }catch(SQLException e){
                e.printStackTrace();
            }
        }
    }

}

