package com.oto.cases.otoseller;

import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.utils.NetworkUtils;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.text.SimpleDateFormat;
import java.util.*;

import static com.oto.utils.BaseUtils.JJBLogin;

public class JiuJiuBao implements Authorization {

    private static final NetworkUtils network = NetworkUtils.getInstance();
    public int isApproveId;     //入职审批id
    public int sellerListSize;  //入职审批个数
    public int jjbSellerId;     //久久保销售id
    public int leaveTotalCount; //离职审批列表的数目
    public int leaveIsApproveId; //离职审批id
    public String phoneNumber; //销售手机号
    public int detailId; //销售信息id

    @BeforeTest
    public void setup(){
        JJBLogin();
    }

    @Test(description = "获取销售信息维护列表",priority = 1)
    public void 获取销售信息维护列表(){
        Map<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize","50");
        Response response = network.getResponse(params,BasicConfig.JiuJiuBao_sellerList);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(params,BasicConfig.JiuJiuBao_sellerList,"获取销售信息维护列表失败",response.body().asString()));
        sellerListSize = response.jsonPath().getInt("data.totalCount");

    }

    @Test(description = "保存入职信息",priority =2)
    public void 保存入职信息(){
        Map<String,Object> params = new HashMap<>();
        params.put("bankAccount",1);
        params.put("bankAccountNumber","1111111111111111111");
        params.put("birthTime",System.currentTimeMillis());
        params.put("certificateNumber","1234");
        params.put("certificateType","passport");//护照
        params.put("companyId",5);
        List listCon = new ArrayList();
        listCon.add("//yun.dui88.com/kjy/media/file/20220629/b87f8de281d7daa7b1df767a71692ee0.jpeg");
        params.put("contractSign",listCon);//一寸照片
        List listDip = new ArrayList();
        listDip.add("//yun.dui88.com/kjy/media/file/20220629/70acebbcde2089f66b2c998f850afeb6.jpg");
        params.put("diploma",listDip);
        params.put("homeAddress","浙江省杭州市西湖区兑吧集团");
        params.put("inductionTime",System.currentTimeMillis());
        params.put("leaveOfEducation",2);//类型是硕士
        params.put("nation",3);//民族是蒙古族
        params.put("oneInchPhoto","//yun.dui88.com/kjy/media/file/20220629/ee3596b2606f4ef8c41360a55b5c8001.jpg");
        //拼接手机号
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String num = df.format(new Date());
        phoneNumber = "151" + num;
        params.put("phoneNumber",phoneNumber);
        params.put("politicCountenance",1);//政治面貌 1：中共党员
        params.put("roleType",1);//角色 1：普通销售
        params.put("sellerGender",1);//性别
        params.put("sellerLevel",1);
        params.put("sellerName","自动化久久保");
        params.put("sellerType","autarky");//销售类型 autarky：久久保自营销售 depend_on：挂靠销售 orther_autarky：自营其他销售
        params.put("serialNumber","12332");
        params.put("signedType","labour_service");//签约类型：labour_service 劳务合同  labour 劳动合同

        Response response = network.postResponse(params, BasicConfig.JiuJiuBao_auditSave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_auditSave,"保存入职信息失败",response.body().asString()));
    }

    @Test(description = "查询保存的入职信息",priority =3)
    public void 查询保存的入职信息(){
        Response response = network.getResponse(BasicConfig.JiuJiuBao_auditSubmitDetail);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(BasicConfig.JiuJiuBao_auditSubmitDetail,"查看入职信息失败",response.body().asString()));

        //获取销售信息id
        detailId = response.jsonPath().getInt("data.id");
    }

    @Test(description = "提交入职信息",priority =4)
    public void 提交入职信息(){
        Map<String,Object> params = new HashMap<>();
        params.put("bankAccount",1);
        params.put("bankAccountNumber","1111111111111111111");
        params.put("birthTime",System.currentTimeMillis());
        params.put("certificateNumber","1234");
        params.put("certificateType","passport");//护照
        params.put("companyId",5);
        List listCon = new ArrayList();
        listCon.add("//yun.dui88.com/kjy/media/file/20220629/b87f8de281d7daa7b1df767a71692ee0.jpeg");
        params.put("contractSign",listCon);//一寸照片
        List listDip = new ArrayList();
        listDip.add("//yun.dui88.com/kjy/media/file/20220629/70acebbcde2089f66b2c998f850afeb6.jpg");
        params.put("diploma",listDip);
        params.put("homeAddress","浙江省杭州市西湖区兑吧集团");
        params.put("id",detailId);
        params.put("inductionTime",System.currentTimeMillis());
        params.put("leaveOfEducation",2);//类型是硕士
        params.put("nation",1);//民族是汉族
        params.put("oneInchPhoto","//yun.dui88.com/kjy/media/file/20220629/ee3596b2606f4ef8c41360a55b5c8001.jpg");
        params.put("phoneNumber",phoneNumber);
        params.put("politicCountenance",1);//政治面貌 1：中共党员
        params.put("roleType",1);//角色 1：普通销售
        params.put("sellerGender",1);//性别
        params.put("sellerLevel",1);
        params.put("sellerName","自动化久久保");
        params.put("sellerType","autarky");//销售类型 autarky：久久保自营销售 depend_on：挂靠销售 orther_autarky：自营其他销售
        params.put("serialNumber","12332");
        params.put("signedType","labour_service");//签约类型：labour_service 劳务合同  labour 劳动合同

        Response response = network.postResponse(params, BasicConfig.JiuJiuBao_auditSubmit);
        String data = response.jsonPath().getString("data");
        Assert.assertNotNull(data,network.message(params,BasicConfig.JiuJiuBao_auditSubmit,"提交入职信息失败",response.body().asString()));
    }


    @Test(description = "获取入职审批列表",priority = 5)
    public void 获取入职审批列表(){
        Map<String,Object> params = new HashMap<>();
        params.put("auditType",1);
        params.put("pageIndex",1);
        params.put("pageSize",50);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_auditList);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(params,BasicConfig.JiuJiuBao_auditList,"获取入职审批列表失败",response.body().asString()));

        //获取入职审批id
        isApproveId = response.jsonPath().getInt("data.list[0].id");
    }

    @Test(description = "入职审批通过",priority = 6)
    public void 入职审批通过(){
        Map<String,Object> params = new HashMap<>();
        params.put("auditFlag",1);
        params.put("id",isApproveId);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_auditIsApprove);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_auditIsApprove,"入职审批通过失败",response.body().asString()));

        //校验销售信息维护页数据增加1
        params.clear();
        params.put("pageIndex",1);
        params.put("pageSize","50");
        Response listSizeRes = network.getResponse(params,BasicConfig.JiuJiuBao_sellerList);
        int sellerListSizeNew = listSizeRes.jsonPath().getInt("data.totalCount");
        Assert.assertTrue(sellerListSizeNew>sellerListSize,network.message(params,BasicConfig.JiuJiuBao_sellerList,"入职审批失败",listSizeRes.body().asString()));
        //获取新增的销售id
        jjbSellerId = listSizeRes.jsonPath().getInt("data.list[0].id");
    }

    @Test(description = "编辑销售信息",priority = 7)
    public void 编辑销售信息(){
        Map<String,Object> params = new HashMap();
        params.put("bankAccount",2);
        params.put("bankAccountNumber","1111111111111111111");
        params.put("companyId",5);
        List listCon = new ArrayList();
        listCon.add("//yun.dui88.com/kjy/media/file/20220629/b87f8de281d7daa7b1df767a71692ee0.jpeg");
        params.put("contractSign",listCon);//一寸照片
        List listDip = new ArrayList();
        listDip.add("//yun.dui88.com/kjy/media/file/20220629/70acebbcde2089f66b2c998f850afeb6.jpg");
        params.put("diploma",listDip);
        params.put("homeAddress","浙江省杭州市西湖区兑吧集团11");
        params.put("id",jjbSellerId);
        params.put("leaveOfEducation",2);
        params.put("nation",1);
        params.put("oneInchPhoto","//yun.dui88.com/kjy/media/file/20220629/55cda664352206a34f526082781538e1.jpeg");
        params.put("politicCountenance",2);
        params.put("roleType",1);
        params.put("sellerLevel",1);
        params.put("sellerType","autarky");
        params.put("serialNumber","560743");
        params.put("signedType","labour_service");
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_sellerUpdate);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_sellerUpdate,"编辑销售信息失败",response.body().asString()));
    }

    @Test(description = "换绑手机",priority = 8)
    public void 换绑手机(){
        Map<String,Object> params = new HashMap<>();
        params.put("id",jjbSellerId);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        String num = df.format(new Date());
        String bindPhoneNumber = "178" + num;
        params.put("newPhoneNum",bindPhoneNumber);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_phoneChange);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_phoneChange,"换绑手机失败",response.body().asString()));
    }

    @Test(description = "权限管理开关控制",priority = 9)
    public void 权限管理开关控制(){
        Map<String,Object> params = new HashMap<>();
        params.put("assignNewCustPermission",0);
        params.put("assignRecycleCustPermission",0);
        params.put("callPermission",0);
        params.put("id",jjbSellerId);
        params.put("sellerStatus",1);
        params.put("workStatus",1);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_updatePermission);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_updatePermission,"权限管理开关变更失败",response.body().asString()));
    }

    @Test(description = "查看坐席列表",priority = 10)
    public void 查看坐席列表(){
        Response response = network.getResponse(BasicConfig.JiuJiuBao_availableList);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(BasicConfig.JiuJiuBao_availableList,"坐席列表获取失败",response.body().asString()));
    }
    @Test(description = "绑定坐席",priority = 11)
    public void 绑定坐席(){
        Map<String,Object> params = new HashMap<>();
        params.put("accountName","8005@fhpcs");
        params.put("sellerId",jjbSellerId);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_accountBind);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_accountBind,"绑定坐席失败",response.body().asString()));
    }

    @Test(description = "解绑外呼坐席",priority = 12)
    public void 解绑外呼坐席(){
        Map<String,Object> params = new HashMap<>();
        params.put("sellerId",jjbSellerId);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_accountUnbind);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_accountUnbind,"解绑外呼坐席失败",response.body().asString()));
    }

    @Test(description = "申请离职",priority = 13)
    public void 申请离职(){
        Map<String,Object> params = new HashMap<>();
        params.put("id",jjbSellerId);
        params.put("leaveReason","自动化测试申请离职");
        long leaveTime = Calendar.getInstance().getTimeInMillis();
        params.put("leaveTime",leaveTime);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_auditLeave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_auditLeave,"申请离职失败",response.body().asString()));
    }

    @Test(description = "查看离职审批列表",priority = 14)
    public void 查看离职审批列表(){
        Map<String,Object> params = new HashMap<>();
        params.put("auditType",2);
        params.put("pageIndex",1);
        params.put("pageSize",50);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_auditList);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(params,BasicConfig.JiuJiuBao_auditList,"查看离职审批列表失败",response.body().asString()));

        //获取离职审批数目
        leaveTotalCount = response.jsonPath().getInt("data.totalCount");
        //获取离职审批的id
        leaveIsApproveId = response.jsonPath().getInt("data.list[0].id");

    }

    @Test(description = "离职审批驳回",priority = 15)
    public void 离职审批驳回(){
        Map<String,Object> params =new HashMap<>();
        params.put("auditFlag",0);
        params.put("id",leaveIsApproveId);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_auditIsApprove);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_auditIsApprove,"离职审批驳回失败",response.body().asString()));

        //检查销售在职状态
        params.clear();
        params.put("sellerId",jjbSellerId);
        Response diMissionRes = network.getResponse(params,BasicConfig.JiuJiuBao_auditSubmitDetail);
        int dimissionStatus = diMissionRes.jsonPath().getInt("data.dimissionStatus");
        Assert.assertTrue(dimissionStatus==0,network.message(params,BasicConfig.JiuJiuBao_auditSubmitDetail,"销售在职状态记录错误",diMissionRes.body().asString()));
    }

    @Test(description = "离职审批通过",priority = 16)
    public void 离职审批通过(){
        Map<String,Object> params = new HashMap<>();
        //提交离职审批
        params.put("id",jjbSellerId);
        params.put("leaveReason","自动化测试申请离职");
        long leaveTime = Calendar.getInstance().getTimeInMillis();
        params.put("leaveTime",leaveTime);
        Response response = network.postResponse(params,BasicConfig.JiuJiuBao_auditLeave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.JiuJiuBao_auditLeave,"申请离职失败",response.body().asString()));

        //获取离职审批id
        params.clear();
        params.put("auditType",2);
        params.put("pageIndex",1);
        params.put("pageSize",50);
        Response leaveRes = network.postResponse(params,BasicConfig.JiuJiuBao_auditList);
        leaveIsApproveId = leaveRes.jsonPath().getInt("data.list[0].id");
        Assert.assertNotNull(leaveIsApproveId,network.message(params,BasicConfig.JiuJiuBao_auditLeave,"申请离职失败",leaveRes.body().asString()));


        //离职审批通过
        params.clear();
        params.put("auditFlag",1);
        params.put("id",leaveIsApproveId);
        Response leaveTrueRes = network.postResponse(params,BasicConfig.JiuJiuBao_auditIsApprove);
        boolean leaveData = leaveTrueRes.jsonPath().getBoolean("data");
        Assert.assertTrue(leaveData,network.message(params,BasicConfig.JiuJiuBao_auditIsApprove,"离职审批通过失败",leaveTrueRes.body().asString()));

    }

    @Test(description = "查看在职状态",priority = 17)
    public void 查看在职状态(){
        Map<String,Object> params =new HashMap<>();
        params.put("sellerId",jjbSellerId);
        Response diMissionRes = network.getResponse(params,BasicConfig.JiuJiuBao_auditSubmitDetail);
        int dimissionStatus = diMissionRes.jsonPath().getInt("data.dimissionStatus");
        Assert.assertTrue(dimissionStatus==1,network.message(params,BasicConfig.JiuJiuBao_auditSubmitDetail,"销售在职状态记录错误",diMissionRes.body().asString()));
    }

    @Test(description = "退出登录",priority = 18)
    public void 退出登录(){
        Response response = network.postResponse(BasicConfig.JiuJiuBao_aloginOut);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.JiuJiuBao_aloginOut,"退出登录失败",response.body().asString()));
    }
}
