package com.oto.utils;

import org.java_websocket.client.WebSocketClient;
import org.java_websocket.enums.ReadyState;
import org.java_websocket.handshake.ServerHandshake;

import java.net.URI;

/**
 * WebSocket工具类
 * @author lizhi
 * @date 2021/4/19 4:00 下午
 */
public class MyWebSocketUtil {

    private static final String URL = "wss://ws.duibatest.com.cn/kws";

    private MyWebSocketUtil() {

    }

    public static void main(String[] args) {
        String authKey = "zFNkBc7JtvLPL6ifAfXbcgYH7WrugVmhv4CXQVq1CN1Y2C8pcBXoPvUPFbkWj7HbdkFpe4oX6SLjczK3ruYpQ8EaQ5";
        String liveId= "Kj21MjMzMTE";

        //连接
        MyWebSocketClient client = connect();
        //身份认证，识别用户信息
        auth(client, authKey);
        //进入直播间
        enter(client, liveId);
        //循环发送心跳，长时间不发消息，链接会断开
        for (int i = 0; i < 5; i++) {
            hb(client);
            ThreadSleepUtils.sleep(5000);
        }
        //退出直播间
        out(client, liveId);
        //无意义命令
        gt(client);
        //关闭连接
        close(client);
    }

    /**
     * 创建链接
     * @param url 需要链接的地址
     * @return WebSocket客户端
     */
    public static MyWebSocketClient connect(String url) {
        MyWebSocketClient client = new MyWebSocketClient(URI.create(url));
        client.connect();
        int maxCount = 10;
        int count = 0;
        // 判断是否连接成功，未成功后面发送消息时会报错
        while (!client.getReadyState().equals(ReadyState.OPEN)) {
            ThreadSleepUtils.sleep(500);
            count++;
            if (count >= maxCount) {
                System.out.println("WebSocketClient, connect, fail, url=" + url);
                return null;
            }
        }
        System.out.println("WebSocketClient, connect, url=" + url);
        return client;
    }

    public static MyWebSocketClient connect() {
        return connect(URL);
    }

    /**
     * 授权
     * @param client WebSocket客户端
     * @param authKey 用户加密信息
     */
    public static void auth(WebSocketClient client, String authKey) {
        sendTextMsg(client, WebSocketConstant.AUTH_OP + WebSocketConstant.MESSAGE_BODY_SPLIT + authKey);
    }

    /**
     * 进入直播间
     * @param client WebSocket客户端
     * @param liveId 加密的直播ID
     */
    public static void enter(WebSocketClient client, String liveId) {
        sendTextMsg(client, WebSocketConstant.ENTER_LIVE_OP + WebSocketConstant.MESSAGE_BODY_SPLIT + liveId + WebSocketConstant.MESSAGE_BODY_SPLIT + "2");
    }

    /**
     * 退出直播间
     * @param client WebSocket客户端
     * @param liveId 加密的直播ID
     */
    public static void out(WebSocketClient client, String liveId) {
        sendTextMsg(client, WebSocketConstant.OUT_LIVE_OP + WebSocketConstant.MESSAGE_BODY_SPLIT + liveId);
    }

    /**
     * 发送心跳
     * @param client WebSocket客户端
     */
    public static void hb(WebSocketClient client) {
        sendTextMsg(client, WebSocketConstant.HEART_BEAT);
    }

    /**
     * 无意义命令，用来判断链接是否还可用
     * @param client WebSocket客户端
     */
    public static void gt(WebSocketClient client) {
        sendTextMsg(client, WebSocketConstant.GREETING_OP);
    }

    /**
     * 关闭链接
     * @param client WebSocket客户端
     */
    public static void close(WebSocketClient client) {
        client.closeConnection(0, "ok");
    }

    /**
     * 发送消息
     * @param client WebSocket客户端
     * @param msg 要发送的消息
     */
    private static void sendTextMsg(WebSocketClient client, String msg) {
        client.send(msg);
        System.out.println("WebSocketClient, sendTextMsg, msg=" + msg);
    }

    static class WebSocketConstant {

        private WebSocketConstant() {}

        /**
         * websocket消息体的指令和body分隔符
         */
        public static final String MESSAGE_BODY_SPLIT = "\r\n";

        /**
         * websocket身份认证指令
         */
        public static final String AUTH_OP = "th";

        /**
         * ws进入直播指令
         */
        public static final String ENTER_LIVE_OP = "en";

        /**
         * ws退出直播指令
         */
        public static final String OUT_LIVE_OP = "out";

        /**
         * 前端验证通信指令，无意义
         */
        public static final String GREETING_OP = "gt";

        /**
         * 心跳
         */
        public static final String HEART_BEAT = "/hb";
    }

    static class MyWebSocketClient extends WebSocketClient {


        public MyWebSocketClient(URI serverUri) {
            super(serverUri);
        }

        @Override
        public void onOpen(ServerHandshake serverHandshake) {
            System.out.println("WebSocketClient, onOpen");
        }

        @Override
        public void onMessage(String s) {
            System.out.println("WebSocketClient, onMessage, s=" + s);
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
            System.out.println("WebSocketClient, onClose, code="+ code+", reason=" + reason + ", remote="+remote);
        }

        @Override
        public void onError(Exception e) {
            System.out.println("WebSocketClient, onError, e:"+ e.getMessage());
        }
    }
}