package com.oto.utils;

import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import io.restassured.response.Response;
import org.apache.commons.lang.StringUtils;
import org.testng.Assert;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by dugq on 2019-10-23.
 *
 * 把ID转换后通过base64编码得出来的值
 * 规律： 以Kj2 开头。第四位为base64结尾'='的个数。避免url encoding
 *       数字部分利用二进制左移3位，后三位补1 把数字变换掉，再base64转码。支持最大值为 2^(64-4)
 * 兼容：旧版本以kjj开头 第四位取原数字第一位补充。 加密已删除，揭秘通过kjj 和 kj2 区分
 * 修改原因： 旧版本太长， 且要处理URL编码问题导致多了一次转换16进制。 加密的主要方案在于 数字左移和补最高位，鉴于base64的高效，所以使用base64encode来美化ID
 *
 * base64加密效率： 加密 1 - 2千万  1s以内完成
 */

public class IdMakeUtil implements Authorization {

    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();

    private static final String PREFIX = "Kj2";

    private IdMakeUtil(){}

    public static String encodingId(Long id) {
        id = (id << 3) ^ 7;
        String encode = encoder.encodeToString(Long.toString(id).getBytes());
        String replace = encode.replace("=", "");
        return PREFIX + (encode.length() - replace.length()) + replace;
    }

    public static Long decodingId(String encode) {
        if (StringUtils.isBlank(encode)) {
            return null;
        }
        try {
            StringBuilder substring = new StringBuilder(encode.substring(4));

            String decode = new String(decoder.decode(substring.toString()));
            return Long.valueOf(decode) >> 3;
        } catch (Exception e) {
            return null;
        }
    }

    public static String managerEncodingId(long id) {
        BaseUtils.ssoLogin();
        Map<String, Object> ids = new HashMap<>();
        ids.put("code", id);
        Response encodeIdRes = network.getResponse(ids, BasicConfig.MANAGER_ID_ENCODE);
        String encodeId = encodeIdRes.jsonPath().getString("data");
        Assert.assertNotNull(encodeId, network.message(ids, BasicConfig.MANAGER_ID_ENCODE, "加密id失败", encodeIdRes.body().asString()));
        return encodeId;
    }
    
    public static long managerDecodeingId(String code) {
        BaseUtils.ssoLogin();
        Map<String, Object> decodePar = new HashMap<>();
        decodePar.put("code", code);
        Response decodeRes = network.getResponse(decodePar, BasicConfig.MANAGER_ID_DECODE);
        long decodeId = 0;
        try {
            decodeId = decodeRes.jsonPath().getLong("data");
        }catch (NullPointerException e){
            e.printStackTrace();
        }
        return decodeId;
    }

}
