package com.oto.cases.otoseller;

import com.oto.bean.Plan;
import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.utils.NetworkUtils;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.text.SimpleDateFormat;
import java.util.*;

import static com.oto.cases.otoseller.Invite.sceneId;
import static com.oto.cases.otoseller.Manager.cust_id;
import static com.oto.cases.otoseller.Manager.searchRole;
import static com.oto.cases.otoseller.Work.callling;
import static com.oto.config.BasicConfig.*;
import static com.oto.utils.ThreadSleepUtils.sleep;

public class CheckTask implements Authorization {
    private static final NetworkUtils network = NetworkUtils.getInstance();
    public String wxUserKey;    //外部联系人ID
    public static String planIds;    //计划ids
    public static int kycId;    //kycID
    public static String beginTime;    //周一日期
    public static int tomorrowWeek;    //明日周几
    public int strategyId;    //盘点策略ID

    @BeforeTest
    public void setUp(){
        otoLeaderAuth();
    }

    @Test(description = "获取场景类型",priority = 1)
    public void 获取场景类型(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sceneType", "1,2");
        Response response = network.getResponse(params,BasicConfig.WORK_getSceneTypes);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.WORK_getSceneTypes,"场景结果为空",response.body().asString()));
    }

    @Test(description = "查询直播场次",priority = 2)
    public void 查询直播场次(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("liveTitle", "测试直播03");
        Response response = network.postResponse(params,BasicConfig.WORK_liveSearch);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.WORK_liveSearch,"直播场次结果为空",response.body().asString()));
    }

    @Test(description = "查询销售或专家列表",priority = 3)
    public void 查询销售或专家列表(){
        sellerOeExpertList("带看",false,2);//查询销售-【仅查询当前部门及子部门】
        sellerOeExpertList("专家",true,2);//查询专家-【仅查询当前部门及子部门】
        sellerOeExpertList("自动化",false,2);//查询销售-【仅查询对应角色】
        sellerOeExpertList("自动化",true,3);//查询专家-【仅查询对应角色】
    }

    @Test(description = "查看可筛选标签列表",priority = 4)
    public void 查看可筛选标签列表(){
        Response response = network.getResponse(BasicConfig.WORK_customerTagList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,3,network.message(BasicConfig.WORK_customerTagList,"查看可筛选标签数量正确",response.body().asString()));
    }

    @Test(description = "标记和取消促单",priority = 5)
    public void 标记和取消促单(){
        otoLeaderAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("promotionType", 1);
        Response response = network.postResponse(params, BasicConfig.WORK_promotionUpdate);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_promotionUpdate,"标记促单成功",response.body().asString()));

        //查看客户的促单状态
        params.put("type", 2);
        response = network.getResponse(params,BasicConfig.WORK_header);
        int promotionType= response.jsonPath().getInt("data.promotionType");
        Assert.assertEquals(promotionType,1,network.message(params,BasicConfig.WORK_header,"客户的促单状态错误",response.body().asString()));


        params.put("promotionType", 0);
        response = network.postResponse(params,BasicConfig.WORK_promotionUpdate);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_promotionUpdate,"取消促单成功",response.body().asString()));

        //查看客户的促单状态
        params.put("type", 2);
        response = network.getResponse(params,BasicConfig.WORK_header);
        promotionType= response.jsonPath().getInt("data.promotionType");
        Assert.assertEquals(promotionType,0,network.message(params,BasicConfig.WORK_header,"客户的促单状态错误",response.body().asString()));

    }

    @Test(description = "总监标记客户星标成功",priority = 6)
    public void 总监标记客户星标成功(){
        otoLeaderAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.postResponse(params,BasicConfig.WORK_star);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_updateExpertRemark,"标记客户星标失败",response.body().asString()));

        params.clear();
        params.put("custId", cust_id);
        params.put("type", 2);
        response = network.getResponse(params,BasicConfig.WORK_header);
        int custStar= response.jsonPath().getInt("data.custStar");
        Assert.assertEquals(custStar,1,network.message(params,BasicConfig.WORK_header,"标记客户星标失败",response.body().asString()));
    }

    @Test(description = "特定销售可见团队",priority = 9)
    public void 特定销售可见团队(){
        otoManagerAuth();
        Response response = network.getResponse(BasicConfig.WORK_apolloSeller);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size >1,network.message(BasicConfig.WORK_apolloSeller,"查看销售在在库客户为空",response.body().asString()));
    }


    @Test(description = "查找企微外部联系人",priority = 10)
    public void 查找企微外部联系人(){
        otoManagerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("name", "吉吉");
        Response response = network.getResponse(params,BasicConfig.WORK_getWxCustByName);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.WORK_getWxCustByName,"名字查找外部联系人列表为空",response.body().asString()));
        wxUserKey = response.jsonPath().getString("data[0].externalUserKey");
    }

    @Test(description = "绑定客户企微",priority = 11)
    public void 绑定客户企微(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("externalUserKey", wxUserKey);
        Response response = network.postResponse(params,BasicConfig.WORK_bindWxCust);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_bindWxCust,"客户绑定企微失败",response.body().asString()));

        //查看客户已绑定吉吉
        params.put("type", 2);
        response = network.getResponse(params,BasicConfig.WORK_header);
        int bindWxWorkFlag= response.jsonPath().getInt("data.wxCustInfo.bindWxWorkFlag");
        String custWxName= response.jsonPath().getString("data.wxCustInfo.custWxName");
        Assert.assertEquals(bindWxWorkFlag,1,network.message(params,BasicConfig.WORK_header,"客户绑定标志非已绑定",response.body().asString()));
        Assert.assertEquals(custWxName,"吉吉",network.message(params,BasicConfig.WORK_header,"客户绑定的企微名称非吉吉",response.body().asString()));

        //查询外部联系人吉吉已绑定OTO客户
        params.put("name", "吉吉");
        response = network.getResponse(params,BasicConfig.WORK_getWxCustByName);
        int bindCustId = response.jsonPath().getInt("data[0].custId");
        Assert.assertEquals(bindCustId,cust_id,network.message(params,BasicConfig.WORK_getWxCustByName,"名字查找外部联系人列表为空",response.body().asString()));
    }

    @Test(description = "换绑客户企微",priority = 12)
    public void 换绑客户企微(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id+1);
        params.put("externalUserKey", wxUserKey);
        Response response = network.postResponse(params,BasicConfig.WORK_bindWxCust);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_bindWxCust,"客户绑定企微失败",response.body().asString()));

        params.put("type", 2);
        response = network.getResponse(params,BasicConfig.WORK_header);
        int bindWxWorkFlag= response.jsonPath().getInt("data.wxCustInfo.bindWxWorkFlag");
        String custWxName= response.jsonPath().getString("data.wxCustInfo.custWxName");
        Assert.assertEquals(bindWxWorkFlag,1,network.message(params,BasicConfig.WORK_header,"客户绑定标志非已绑定",response.body().asString()));
        Assert.assertEquals(custWxName,"吉吉",network.message(params,BasicConfig.WORK_header,"客户绑定的企微名称非吉吉",response.body().asString()));

        //绑定的老客户关系取消
        params.put("custId", cust_id);
        response = network.getResponse(params,BasicConfig.WORK_header);
        bindWxWorkFlag= response.jsonPath().getInt("data.wxCustInfo.bindWxWorkFlag");
        Assert.assertEquals(bindWxWorkFlag,0,network.message(params,BasicConfig.WORK_header,"客户绑定标志非未绑定",response.body().asString()));
    }

    @Test(description = "修改重点跟进人",priority = 13)
    public void 修改重点跟进人(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("followUp", 4);
        Response response = network.postResponse(params,BasicConfig.WORK_updateFollowUp);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_updateFollowUp,"修改重点跟进人失败",response.body().asString()));

        params.put("type", 2);
        response = network.getResponse(params,BasicConfig.WORK_header);
        int followUp= response.jsonPath().getInt("data.followUp");
        Assert.assertEquals(followUp,4,network.message(params,BasicConfig.WORK_header,"客户重点跟进人错误",response.body().asString()));
    }


    @Test(description = "重新分配搜索按照组织架构",priority = 15)
    public void 重新分配搜索按照组织架构(){
        //销售角色不可搜索到邀约成员
        searchRole("勿动-自动化测试邀约",6,0,"check");
        //销售角色成功搜索到销售成员
        searchRole("勿动-自动化测试带看",6,1,"check");
        //销售角色不可搜索到专家成员
        searchRole("勿动-自动化测试专家",6,0,"check");

        //专家角色不可搜索到邀约成员
        searchRole("勿动-自动化测试邀约",4,0,"check");
        //专家角色不可搜索到销售成员
        searchRole("勿动-自动化测试带看",4,0,"check");
        //专家角色成功搜索到专家成员
        searchRole("勿动-自动化测试专家",4,1,"check");

        //搜索区分组织架构
        searchRole("专家",4,2,"check");
    }

    @Test(description = "自建计划查找销售名下客户",priority = 16)
    public void 自建计划查找销售名下客户(){
        otoTakerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化激活用户");
        Response response = network.getResponse(params,BasicConfig.WORK_obtainCustBySellerId);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size , 1,network.message(params,BasicConfig.WORK_obtainCustBySellerId,"查看销售在在库客户为空",response.body().asString()));
    }


    @Test(description = "总监可看子部门策略",priority = 17)
    public void 总监可看子部门策略(){
        otoLeaderAuth();
        Response response = network.getResponse(BasicConfig.WORK_strategy_onAbleList);
        int size = response.jsonPath().getInt("data.size()");
        String strategyName = response.jsonPath().getString("data[0].strategyName");
        Assert.assertEquals(size,2,network.message(BasicConfig.WORK_strategy_onAbleList,"总监可看策略数量错误",response.body().asString()));
        Assert.assertEquals(strategyName,"自动化盘点策略",network.message(BasicConfig.WORK_strategy_onAbleList,"总监可看策略名称错误",response.body().asString()));
    }


    @Test(description = "不可新增同名策略",priority = 18)
    public void 不可新增同名策略(){
        otoManagerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("strategyName", "自动化盘点策略");
        params.put("strategyStatus", 0);
        params.put("deptIds", new int[]{29});
        Response response = network.postResponse(params,BasicConfig.WORK_strategy_saveOrUpdate);
        boolean data = response.jsonPath().getBoolean("success");
        Assert.assertFalse(data,network.message(params,BasicConfig.WORK_strategy_saveOrUpdate,"团队新增同名盘点策略成功",response.body().asString()));
    }


    @Test(description = "查看盘点策略列表",priority = 19)
    public void 查看盘点策略列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("strategyName", "自动化盘点策略");
        params.put("pageIndex", "1");
        params.put("pageSize", 50);
        Response response = network.getResponse(params,BasicConfig.WORK_strategy_list);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.WORK_strategy_list,"新增盘点策略失败",response.body().asString()));

        strategyId= response.jsonPath().getInt("data.list[0].id");
    }
    @Test(description = "移动策略",priority = 20)
    public void 移动策略(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", strategyId);
        params.put("strategyMove", "down");
        Response response = network.postResponse(params,BasicConfig.WORK_strategyMove);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_strategyMove,"移动策略失败",response.body().asString()));

        otoLeaderAuth();
        response = network.getResponse(BasicConfig.WORK_strategy_onAbleList);
        String strategyName = response.jsonPath().getString("data[1].strategyName");
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(strategyName,"自动化盘点策略",network.message(BasicConfig.WORK_strategy_searchParentSeller,"总监可看策略名称错误",response.body().asString()));
        Assert.assertEquals(size,2,network.message(BasicConfig.WORK_strategy_searchParentSeller,"总监可看策略数量错误",response.body().asString()));

        otoManagerAuth();
        params.put("strategyMove", "up");
        response = network.postResponse(params,BasicConfig.WORK_strategyMove);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_strategyMove,"移动策略失败",response.body().asString()));
    }

    @Test(description = "修改盘点策略",priority = 22)
    public void 修改盘点策略(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", strategyId);
        params.put("sellerIds", new int[]{LEADER_ID});
        params.put("strategyName", "自动化盘点可用策略");
        params.put("strategyStatus", 1);
        params.put("deptIds", new int[]{29});
        Response response = network.postResponse(params,BasicConfig.WORK_strategy_saveOrUpdate);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_strategy_saveOrUpdate,"修改盘点策略失败",response.body().asString()));

        otoLeaderAuth();
        response = network.getResponse(BasicConfig.WORK_strategy_onAbleList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2,network.message(BasicConfig.WORK_strategy_onAbleList,"总监可看策略数量错误",response.body().asString()));

        otoManagerAuth();
        HashMap<String,Object> params1 = new HashMap<>();
        params1.put("strategyName", "自动化盘点可用策略");
        params1.put("pageIndex", "1");
        params1.put("pageSize", 50);
        response = network.getResponse(params1,BasicConfig.WORK_strategy_list);
        size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.WORK_strategy_list,"修改盘点策略失败",response.body().asString()));

        params.put("strategyName", "自动化盘点策略");
        params.put("strategyStatus", 1);
        params.put("deptIds", new int[]{30});
        response = network.postResponse(params,BasicConfig.WORK_strategy_saveOrUpdate);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_strategy_saveOrUpdate,"修改盘点策略失败",response.body().asString()));
    }

    @Test(description = "修改盘点策略状态",priority = 23)
    public void 修改盘点策略状态(){
        //关闭状态
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", strategyId);
        params.put("strategyStatus", 0);
        Response response = network.postResponse(params,BasicConfig.WORK_strategy_updateStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_strategy_updateStatus,"团队新增同名盘点策略成功",response.body().asString()));

        otoLeaderAuth();
        response = network.getResponse(BasicConfig.WORK_strategy_onAbleList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,1,network.message(BasicConfig.WORK_strategy_onAbleList,"总监可看策略数量错误",response.body().asString()));

        //开启状态
        params.put("strategyStatus", 1);
        response = network.postResponse(params,BasicConfig.WORK_strategy_updateStatus);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_strategy_updateStatus,"团队新增同名盘点策略成功",response.body().asString()));
    }


    @Test(description = "创建转介绍客户",priority = 24)
    public void 创建转介绍客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("addType", 2);
        params.put("introducerId", cust_id);
        params.put("introducerName", "自动化测试用户7");
        params.put("custPhoneNum", "15136361307");
        params.put("custName", "自动化测试客户7");
        Response response = network.postResponse(params,BasicConfig.WORK_introduce_save);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_introduce_save,"创建转介绍客户失败",response.body().asString()));

        params.clear();
        sleep(10000);
        otoExpertAuth();
        params.put("pageIndex", 1);
        params.put("pageSize", 50);
        params.put("custName", "自动化测试客户7");
        response = network.postResponse(params,BasicConfig.WORK_SellerCustList);
        int customerId = response.jsonPath().getInt("data.list[0].custId");

        params.clear();
        params.put("custId", customerId);
        params.put("type", 1);
        response = network.getResponse(params,BasicConfig.WORK_header);
        String introducer = response.jsonPath().getString("data.introducer");
        String inviteName = response.jsonPath().getString("data.inviteName");
        String expertName = response.jsonPath().getString("data.expertName");
        String sellerName = response.jsonPath().getString("data.sellerName");
        Assert.assertEquals(introducer,"自动化激活用户",network.message(params,BasicConfig.WORK_header,"转介绍客户的介绍人错误",response.body().asString()));
        Assert.assertNull(inviteName,network.message(params,BasicConfig.WORK_header,"转介绍客户的当前邀约与介绍人不一致",response.body().asString()));
        Assert.assertEquals(expertName,"勿动-自动化测试专家",network.message(params,BasicConfig.WORK_header,"转介绍客户的当前销售与介绍人不一致",response.body().asString()));
        Assert.assertEquals(sellerName,"勿动-自动化测试带看",network.message(params,BasicConfig.WORK_header,"转介绍客户的当前专家与介绍人不一致",response.body().asString()));
    }


    @Test(description = "提交客户盘点",priority = 30)
    public void 提交客户盘点(){
        otoManagerAuth();
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String,Object> params = new HashMap<>();
        params.put("checkConclusion","客户盘点后的结论1");
        params.put("strategyId",strategyId);
        params.put("custId",cust_id);
        calendar.add(calendar.DATE,2);
        ArrayList<Plan> plans = new ArrayList<>();
        plans.add(new Plan("phone",simpleDateFormat.format(calendar.getTime()),"pm",6,null));//创建后日计划
        plans.add(new Plan("meet",simpleDateFormat.format(calendar.getTime()),"am",6, (int) sceneId));
        params.put("plans",plans);
        Response response =network.postResponse(params,BasicConfig.WORK_saveCheckRecord);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_saveCheckRecord,"提交客户盘点失败",response.body().asString()));

        plans.clear();
        sleep(2000);
        params.put("checkConclusion","客户盘点后的结论2");
        params.put("strategyId",strategyId);
        calendar.add(calendar.DATE,-1);
        plans.add(new Plan("phone",simpleDateFormat.format(calendar.getTime()),"pm",6,null));//创建明日计划
        plans.add(new Plan("meet",simpleDateFormat.format(calendar.getTime()),"am",6, (int) sceneId));
        params.put("plans",plans);
        response =network.postResponse(params,BasicConfig.WORK_saveCheckRecord);

        plans.clear();
        sleep(2000);
        params.put("checkConclusion","客户盘点后的结论");
        params.put("strategyId",strategyId);
        params.put("plans",plans);
        response =network.postResponse(params,BasicConfig.WORK_saveCheckRecord);

    }

    @Test(description = "查看历史盘点列表",priority = 31)
    public void 查看历史盘点列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",cust_id);
        Response response =network.getResponse(params,BasicConfig.WORK_checkList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,3,network.message(params,BasicConfig.WORK_checkList,"提交客户盘点失败",response.body().asString()));
        String checkConclusion = response.jsonPath().getString("data[0].checkConclusion");
        Assert.assertEquals(checkConclusion,"客户盘点后的结论",network.message(params,BasicConfig.WORK_checkList,"提交客户盘点失败",response.body().asString()));
    }

    @Test(description = "查看盘点客户列表",priority = 32)
    public void 查看盘点客户列表(){
        sleep(10000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName","自动化");
        params.put("todayCheck",1);
        params.put("pageIndex",1);
        params.put("pageSize",50);
        Response response =network.postResponse(params,BasicConfig.WORK_checkCustList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.WORK_checkCustList,"今日盘点客户不包含刚刚已经盘点的客户",response.body().asString()));


        params.put("custName","刘某");
        params.put("todayCheck",0);
        response =network.postResponse(params,BasicConfig.WORK_checkCustList);
        size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,0,network.message(params,BasicConfig.WORK_checkCustList,"盘点客户可搜索到非本团队的客户",response.body().asString()));
    }

    @Test(description = "查看盘点计划跟进数据",priority = 33)
    public void 查看盘点计划跟进数据(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_getFollowInfo);
        boolean hasFollowFlag = response.jsonPath().getBoolean("data.hasFollowFlag");
        int size = response.jsonPath().getInt("data.roleTypes.size()");
        Assert.assertTrue(hasFollowFlag,network.message(params,BasicConfig.WORK_getFollowInfo,"客户没有销售或专家跟进",response.body().asString()));
        Assert.assertEquals(size,2,network.message(params,BasicConfig.WORK_getFollowInfo,"客户的跟进角色错误",response.body().asString()));
    }


    @Test(description = "销售添加自建计划",priority = 34)
    public void 销售添加自建计划(){
        otoTakerAuth();

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar= Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(calendar.DATE,1);


        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("actionTime", simpleDateFormat.format(calendar.getTime()));//创建明日计划
        params.put("planActionType", "phone");
        params.put("timeRegion", "am");
        Response response = network.postResponse(params,BasicConfig.WORK_saveSelfPlan);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_saveSelfPlan,"创建自建计划失败",response.body().asString()));

        calendar.add(calendar.DATE,-1);
        tomorrowWeek = calendar.get(Calendar.DAY_OF_WEEK) ;//计算明日处于周几
        calendar.add(Calendar.DATE, -tomorrowWeek+2);
        beginTime = simpleDateFormat.format(calendar.getTime());
        tomorrowWeek= tomorrowWeek-1;


    }

    @Test(description = "销售查看个人工作计划",priority = 35)
    public void 销售查看个人工作计划(){
        sleep(1000);
        getSellerPlan(0,2,0,1,1,0);

    }


    @Test(description = "可看末级团队",priority = 36)
    public void 可看末级团队(){
        otoLeaderAuth();
        Response response = network.getResponse(BasicConfig.WORK_minimumDept);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,2,network.message(BasicConfig.WORK_minimumDept,"末级团队列表为空",response.body().asString()));
    }

    @Test(description = "总监查看团队工作计划",priority = 37)
    public void 总监查看团队工作计划(){
        otoLeaderAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("beginTime", beginTime);
        Response response = network.postResponse(params,BasicConfig.WORK_getDirectorPlanCalendarList);
        int size = response.jsonPath().getInt("data.size()");
        int flag = 0;
        for(int i =0;i<size;i++){
            if(response.jsonPath().getString("data["+i+"].sellerName").equals("勿动-自动化测试带看")){
                flag = 1;
                int plans = response.jsonPath().getInt("data["+i+"].vos["+ tomorrowWeek +"].ids.size()");
                int hasAllCheck = response.jsonPath().getInt("data["+i+"].vos["+ tomorrowWeek +"].hasAllCheck");
                Assert.assertEquals(plans,3,network.message(params,BasicConfig.WORK_getDirectorPlanCalendarList,"销售当天的计划数量错误",response.body().asString()));
                Assert.assertEquals(hasAllCheck,0,network.message(params,BasicConfig.WORK_getDirectorPlanCalendarList,"销售当天的盘点标记非[已盘完】",response.body().asString()));
            }
        }
        if (flag== 0){
            Assert.fail(network.message(params,BasicConfig.WORK_getDirectorPlanCalendarList,"团队计划中不包含总监名下销售",response.body().asString()));
        }
    }

    @Test(description = "查看计划详情",priority = 38)
    public void 查看计划详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("ids", planIds);
        Response response = network.getResponse(params,BasicConfig.WORK_getPlanDetail);
        int amSize = response.jsonPath().getInt("data.am.size()");
        int pmSize = response.jsonPath().getInt("data.pm.size()");
        int meetStatus = response.jsonPath().getInt("data.am[0].planStatus");
        int phoneStatus = response.jsonPath().getInt("data.pm[0].planStatus");
        int hasCheck_1 = response.jsonPath().getInt("data.am[0].hasCheck");
        int hasCheck_2 = response.jsonPath().getInt("data.pm[0].hasCheck");
        Assert.assertEquals(amSize,2,network.message(params,BasicConfig.WORK_getPlanDetail,"上午列表总数错误",response.body().asString()));
        Assert.assertEquals(pmSize,1,network.message(params,BasicConfig.WORK_getPlanDetail,"下午列表总数错误",response.body().asString()));
        Assert.assertEquals(meetStatus,1,network.message(params,BasicConfig.WORK_getPlanDetail,"上午完成计划状态错误",response.body().asString()));
        Assert.assertEquals(phoneStatus,1,network.message(params,BasicConfig.WORK_getPlanDetail,"下午完成计划状态错误",response.body().asString()));
        Assert.assertEquals(hasCheck_1,1,network.message(params,BasicConfig.WORK_getPlanDetail,"见面计划盘点状态错误非【已盘】",response.body().asString()));
        Assert.assertEquals(hasCheck_2,1,network.message(params,BasicConfig.WORK_getPlanDetail,"电话计划盘点状态错误非【已盘】",response.body().asString()));
    }

    @Test(description = "主动拨通客户电话计划完成",priority = 39)
    public void 主动拨通客户电话计划完成(){
        callling("17823123001","15136361301",10,"dealing");

        otoTakerAuth();
        sleep(1000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("ids", planIds);
        Response response = network.getResponse(params,BasicConfig.WORK_getPlanDetail);
        int phoneStatus = response.jsonPath().getInt("data.am[1].planStatus");
        Assert.assertEquals(phoneStatus,2,network.message(params,BasicConfig.WORK_getPlanDetail,"电话计划状态非已完成",response.body().asString()));

        params.clear();
        getSellerPlan(1,2,0,1,1,0);
    }

    @Test(description = "查看历史计划",priority = 40)
    public void 查看历史计划(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params,BasicConfig.WORK_getPlanList);
        int size = response.jsonPath().getInt("data.list.size()");
        String planStatusDesc1 = response.jsonPath().getString("data.list[2].planStatusDesc");
        String planStatusDesc2 = response.jsonPath().getString("data.list[0].planStatusDesc");
        Assert.assertEquals(planStatusDesc1,"进行中",network.message(params,BasicConfig.WORK_getPlanList,"已完成计划数量错误",response.body().asString()));
        Assert.assertEquals(planStatusDesc2,"已完成",network.message(params,BasicConfig.WORK_getPlanList,"已完成计划数量错误",response.body().asString()));
        Assert.assertEquals(size,5,network.message(params,BasicConfig.WORK_getPlanList,"总计划数量错误",response.body().asString()));
    }

    @Test(description = "查看新客户的方案进展模块",priority = 50)
    public void 查看新客户的方案进展模块(){
        getSchemeNum(0,0,0,null);
    }

    @Test(description = "上传KYC",priority = 51)
    public void 上传KYC(){
        //仅管理员/PM/内勤可上传kyc
        otoManagerAuth();
        saveKyc(true);
        otoPMAuth();
        saveKyc(true);
        otoAssistAuth();
        saveKyc(true);
        otoLeaderAuth();
        saveKyc(true);

        //其他角色不可上传kyc
        otoInviterAuth();
        saveKyc(false);
        otoTakerAuth();
        saveKyc(false);
        otoExpertAuth();
        saveKyc(false);
        otoAreaAuth();
        saveKyc(false);

        sleep(1000);
        getSchemeNum(4,0,0,null);
    }

    @Test(description = "上传客户方案",priority = 52)
    public void 上传客户方案(){
        //仅管理员/PM可上传方案
        otoManagerAuth();
        savePlanFile(true);
        otoPMAuth();
        savePlanFile(true);

        //其他角色不可上传方案
        otoAssistAuth();
        savePlanFile(false);
        otoInviterAuth();
        savePlanFile(false);
        otoTakerAuth();
        savePlanFile(false);
        otoExpertAuth();
        savePlanFile(false);
        otoLeaderAuth();
        savePlanFile(false);
        otoAreaAuth();
        savePlanFile(false);

        sleep(1000);
        getSchemeNum(4,2,0,null);
    }

    @Test(description = "查看kyc和方案上传历史列表",priority = 53)
    public void 查看kyc和方案上传历史列表(){
        //查看kys上传历史
        getSchemeList(1,4,null);

        //查看方案上传历史
        getSchemeList(2,2,null);

        //查看方案讲解历史
        getSchemeList(3,0,null);
    }

    @Test(description = "标记KYC合格状态",priority = 54)
    public void 标记KYC合格状态(){
        //仅管理员/PM可标记kyc
        otoManagerAuth();
        qualifiedKyc(1,true);
        sleep(1000);
        getSchemeNum(4,2,0,true);
        getSchemeList(1,4,1);

        otoPMAuth();
        qualifiedKyc(0,true);
        sleep(1000);
        getSchemeNum(4,2,0,false);
        getSchemeList(1,4,0);

        //其他角色不可标记kyc
        otoAssistAuth();
        qualifiedKyc(1,false);
        otoInviterAuth();
        qualifiedKyc(1,false);
        otoTakerAuth();
        qualifiedKyc(1,false);
        otoExpertAuth();
        qualifiedKyc(1,false);
        otoLeaderAuth();
        qualifiedKyc(1,false);
        otoAreaAuth();
        qualifiedKyc(1,false);

    }

    //获取销售个人工作计划
    public static void getSellerPlan(int amFinish,int amTotal,int pmFinish,int pmTotal,int pStatus,int unFinishTypes){
        HashMap<String, Object> params = new HashMap<>();
        params.put("beginTime", beginTime);
        Response response = network.postResponse(params,BasicConfig.WORK_getSellerPlanCalendarList);
        int amFinishNum = response.jsonPath().getInt("data["+ tomorrowWeek +"].amFinishNum");
        int amTotalNum = response.jsonPath().getInt("data["+ tomorrowWeek +"].amTotalNum");
        int pmFinishNum = response.jsonPath().getInt("data["+ tomorrowWeek +"].pmFinishNum");
        int pmTotalNum = response.jsonPath().getInt("data["+ tomorrowWeek +"].pmTotalNum");
        int planStatus = response.jsonPath().getInt("data["+ tomorrowWeek +"].planStatus");
        int unFinishPlanActionTypes = response.jsonPath().getInt("data["+ tomorrowWeek +"].unFinishPlanActionTypes.size()");
        Assert.assertEquals(amFinishNum,amFinish,network.message(params,BasicConfig.WORK_updateFollowUp,"上午完成数量错误",response.body().asString()));
        Assert.assertEquals(amTotalNum,amTotal,network.message(params,BasicConfig.WORK_updateFollowUp,"上午总数量错误",response.body().asString()));
        Assert.assertEquals(pmFinishNum,pmFinish,network.message(params,BasicConfig.WORK_updateFollowUp,"下午完成数量错误",response.body().asString()));
        Assert.assertEquals(pmTotalNum,pmTotal,network.message(params,BasicConfig.WORK_updateFollowUp,"下午总数量错误",response.body().asString()));
        Assert.assertEquals(planStatus,pStatus,network.message(params,BasicConfig.WORK_updateFollowUp,"今日总计划状态错误",response.body().asString()));
        Assert.assertEquals(unFinishPlanActionTypes,unFinishTypes,network.message(params,BasicConfig.WORK_updateFollowUp,"今日计划未完成动作类型数量错误",response.body().asString()));

        planIds = response.jsonPath().getString("data["+ tomorrowWeek +"].ids");
        planIds =planIds.replaceAll(" ","");
        planIds = planIds.substring(1,planIds.length()-1);
    }


    public void sellerOeExpertList(String name ,boolean expertFlag,int count){
        HashMap<String,Object> params = new HashMap<>();
        params.put("name", name);
        params.put("expertFlag",expertFlag); //false表示查询销售，true表示查询专家
        Response response = network.postResponse(params,BasicConfig.WORK_check_sellerList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,count,network.message(params,BasicConfig.WORK_check_sellerList,"结果列表错误",response.body().asString()));
    }

    public void saveKyc(boolean result){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("kycImages", new String[]{"//yun.dui88.com/kjy/image/20230113/523669708b5043f5bb4641252e125cb5.jpg","//yun.dui88.com/kjy/image/20230113/edd2e950a8aa4fb2a15ae7400b768fed.jpg"});
        Response response = network.postResponse(params,BasicConfig.WORK_scheme_saveKyc);
        if(result) {
            boolean data = response.jsonPath().getBoolean("data");
            Assert.assertEquals(data, result, network.message(params, BasicConfig.WORK_scheme_saveKyc, "上传KYC结果非" + result, response.body().asString()));
        }else{
            boolean success = response.jsonPath().getBoolean("success");
            Assert.assertEquals(success, result, network.message(params, BasicConfig.WORK_scheme_saveKyc, "上传KYC结果非" + result, response.body().asString()));
        }
    }

    public void savePlanFile(boolean result){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("planFiles",new String[]{"//yun.dui88.com/kjy/media/file/20230113/20230113145555/1.doc","//yun.dui88.com/kjy/media/file/20230131/20230131111229/4.ppt"} );
        Response response = network.postResponse(params,BasicConfig.WORK_scheme_savePlanFile);
        if(result) {
            boolean data = response.jsonPath().getBoolean("data");
            Assert.assertEquals(data, result, network.message(params, BasicConfig.WORK_scheme_savePlanFile, "上传方案结果非" + result, response.body().asString()));
        }else{
            boolean success = response.jsonPath().getBoolean("success");
            Assert.assertEquals(success, result, network.message(params, BasicConfig.WORK_scheme_savePlanFile, "上传方案结果非" + result, response.body().asString()));
        }
    }

    public void qualifiedKyc(int isQualified,boolean result){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", kycId);
        params.put("isQualified",isQualified);   //  0不合格 1合格
        Response response = network.postResponse(params,BasicConfig.WORK_scheme_qualified);
        if(result) {
            boolean data = response.jsonPath().getBoolean("data");
            Assert.assertEquals(data, result, network.message(params, BasicConfig.WORK_scheme_qualified, "标记KYC结果非" + result, response.body().asString()));
        }else{
            boolean success = response.jsonPath().getBoolean("success");
            Assert.assertEquals(success, result, network.message(params, BasicConfig.WORK_scheme_qualified, "标记KYC结果非" + result, response.body().asString()));
        }
    }

    public static void getSchemeNum(int kycNum,int schemeNum,int commitPlanNum,Object hasQualifiedKyc){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        Response response = network.getResponse(params,BasicConfig.WORK_scheme_getNum);
        int kyc = response.jsonPath().getInt("data.kycNum");
        int scheme = response.jsonPath().getInt("data.schemeNum");
        int commitPlan = response.jsonPath().getInt("data.commitPlanNum");
        Assert.assertEquals(kyc,kycNum,network.message(params,BasicConfig.WORK_scheme_getNum,"上传KYC次数非"+kycNum,response.body().asString()));
        Assert.assertEquals(scheme,schemeNum,network.message(params,BasicConfig.WORK_scheme_getNum,"上传方案次数非"+schemeNum,response.body().asString()));
        Assert.assertEquals(commitPlan,commitPlanNum,network.message(params,BasicConfig.WORK_scheme_getNum,"讲解方案次数非"+commitPlanNum,response.body().asString()));
        if (hasQualifiedKyc == null) {
            Object QualifiedKyc = response.jsonPath().getJsonObject("data.hasQualifiedKyc");
            Assert.assertNull(QualifiedKyc,network.message(params,BasicConfig.WORK_scheme_getNum,"KYC合格状态非"+hasQualifiedKyc,response.body().asString()));
        }else{
            boolean QualifiedKyc = response.jsonPath().getBoolean("data.hasQualifiedKyc");
            Assert.assertEquals(QualifiedKyc,hasQualifiedKyc,network.message(params,BasicConfig.WORK_scheme_getNum,"KYC合格状态非"+hasQualifiedKyc,response.body().asString()));
        }
    }

    public static void getSchemeList(int type,int count,Integer kycStatus){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", cust_id);
        params.put("type", type);
        params.put("pageIndex", 1);
        params.put("pageSize", 999);
        Response response = network.getResponse(params,BasicConfig.WORK_scheme_list);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,count,network.message(params,BasicConfig.WORK_scheme_list,"列表数量非"+count,response.body().asString()));
        if(type==1){//1-kyc上传历史，2-方案上传历史，3-方案讲解历史
            kycId =  response.jsonPath().getInt("data.list[0].id");
            //1表示合格,0表示不合格，null表示未评价
            if(kycStatus == null){
                Object isQualified = response.jsonPath().getJsonObject("data.list[0].isQualified");
                Assert.assertNull(isQualified, network.message(params, BasicConfig.WORK_scheme_list, "最新上传的kyc合格状态非" + count, response.body().asString()));
            }else {
                Integer isQualified = response.jsonPath().getInt("data.list[0].isQualified");
                Assert.assertEquals(isQualified, kycStatus, network.message(params, BasicConfig.WORK_scheme_list, "最新上传的kyc合格状态非" + count, response.body().asString()));
            }

        }

    }
}
