package com.oto.cases.otoseller;

import com.oto.cases.admin.Authorization;
import com.oto.config.BasicConfig;
import com.oto.utils.NetworkUtils;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.util.*;

import static com.oto.config.BasicConfig.*;
import static com.oto.utils.BaseUtils.*;
import static com.oto.utils.ThreadSleepUtils.sleep;

public class Work implements Authorization {
    private static final NetworkUtils network = NetworkUtils.getInstance();
    public int tagId;   //标签ID
    public int custId;    //客户ID
    public static String phone = "13705566425";    //客户手机号
    public int followTimes;    //跟进次数
    public static Map<String,Integer> header;
    public static Map<String,Integer> chart;

    @BeforeTest
    public void setUp(){
        header = new HashMap<>();
        chart = new HashMap<>();
        otoSellerLogin();
        otoLeaderLogin();
        otoManagerLogin();
        ssoLogin();
    }

    @Test(description = "公域引流_创建标签",priority = 1)
    public void 公域引流_创建标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("tagName", "勿动-自动化测试标签");
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_saveTag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_saveTag,"创建标签失败",response.body().asString()));

        //创建名称相同的标签失败
        response = network.postResponse(params,BasicConfig.MANAGER_oto_saveTag);
        data = response.jsonPath().getBoolean("success");
        Assert.assertFalse(data,network.message(params,BasicConfig.MANAGER_oto_saveTag,"创建同名的标签成功",response.body().asString()));
    }

    @Test(description = "公域引流_查看标签列表",priority = 2)
    public void 公域引流_查看标签列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params,BasicConfig.MANAGER_oto_tagList);
        int size = response.jsonPath().getInt("data.list.size()");
        String tagName = response.jsonPath().getString("data.list[0].tagName");
        int customerCount = response.jsonPath().getInt("data.list[0].customerCount");
        int tagStatus = response.jsonPath().getInt("data.list[0].tagStatus");
        Assert.assertTrue(size>0 ,network.message(BasicConfig.MANAGER_oto_tagList,"标签列表为空",response.body().asString()));
        Assert.assertEquals(tagName ,"勿动-自动化测试标签",network.message(params,BasicConfig.MANAGER_oto_tagList,"标签名称错误",response.body().asString()));
        Assert.assertEquals(customerCount ,0,network.message(params,BasicConfig.MANAGER_oto_tagList,"新标签的客户数不为0",response.body().asString()));
        Assert.assertEquals(tagStatus ,1,network.message(params,BasicConfig.MANAGER_oto_tagList,"新标签的状态不为打开",response.body().asString()));

        tagId = response.jsonPath().getInt("data.list[0].id");
    }

    @Test(description = "公域引流_修改标签",priority = 3)
    public void 公域引流_修改标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("tagName", "勿动-自动化更新标签");
        params.put("id", tagId);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_updateTag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_updateTag,"修改标签失败",response.body().asString()));
    }

    @Test(description = "公域引流_填写表单",priority = 4)
    public void 公域引流_填写表单(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("formId", "Kj20ODA3");
        params.put("phoneNum", phone);
        params.put("urlLink", "https://kjj-static.duibatest.com.cn/cpic-home/202111261430?formId=Kj20ODA3&channel=bd&agent=x");
        params.put("username", "自动化测试用户");
        params.put("uuid", "622d83e4-ca21-4ccd-94cb-182c0f2a6b60");
        Response response = network.postResponse(params,BasicConfig.FORM_submit);
        String recordId = response.jsonPath().getString("data.recordId");
        Assert.assertNotNull(recordId,network.message(params,BasicConfig.FORM_submit,"客户创建失败",response.body().asString()));

        params.clear();
        ArrayList<String> optionIds = new ArrayList<>();
        optionIds.add("Kj21NTY1OTE");
        params.put("optionIds", optionIds);
        params.put("questionId", "Kj21MjQ5Njc");
        params.put("recordId", recordId);
        response = network.postResponse(params,BasicConfig.FORM_submitQuestion);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.FORM_submitQuestion,"客户填写表单失败",response.body().asString()));
    }


    @Test(description = "公域引流_查找客户",priority = 5)
    public void 公域引流_查找客户(){
        HashMap<String,Object> params = new HashMap<String,Object>();
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        params.put("phoneNum", phone);
        Response response = network.getResponse(params,BasicConfig.MANAGER_oto_customerList);
        int totalCount = response.jsonPath().getInt("data.totalCount");
        Assert.assertTrue(totalCount == 1,network.message(params,BasicConfig.MANAGER_oto_customerList,"未查找到该客户",response.body().asString()));
        String custName = response.jsonPath().getString("data.list[0].custName");
        Assert.assertEquals(custName,"自动化测试用户",network.message(params,BasicConfig.MANAGER_oto_customerList,"未查找到该客户",response.body().asString()));

        custId = response.jsonPath().getInt("data.list[0].id");
    }

    @Test(description = "公域引流_分配客户",priority = 6)
    public void 公域引流_分配客户(){
        HashMap<String,Object> params = new HashMap<>();
        String str= String.valueOf(System.currentTimeMillis());
        params.put("customerId",custId);
        params.put("sellerId", SELLER_ID);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_assignSeller);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_assignSeller,"分配客户失败",response.body().asString()));
    }

    @Test(description = "工作台_销售信息",priority = 7)
    public void 客户分类_销售信息(){
        otosellerAuth();
        Response response = network.getResponse(BasicConfig.WORK_userInfo);
        String sellerName = response.jsonPath().getString("data.sellerName");
        Assert.assertEquals(sellerName,"勿动-自动化测试销售",network.message(BasicConfig.WORK_userInfo,"销售姓名错误",response.body().asString()));
    }

    @Test(description = "工作台_通知栏",priority = 8)
    public void 工作台_通知栏(){
        Response response = network.getResponse(BasicConfig.WORK_notifyList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,1,network.message(BasicConfig.WORK_notifyList,"通知栏不为空",response.body().asString()));
        int notifyType = response.jsonPath().getInt("data[0].notifyType");
        int custCount = response.jsonPath().getInt("data[0].custCount");
        Assert.assertEquals(custCount,1,network.message(BasicConfig.WORK_notifyList,"客户数量错误",response.body().asString()));
        Assert.assertEquals(notifyType,2,network.message(BasicConfig.WORK_notifyList,"通知栏类型错误",response.body().asString()));
    }

    @Test(description = "客户状态分类_数量总览",priority = 9)
    public void 客户状态分类_数量总览(){
        Response response = network.getResponse(BasicConfig.WORK_staticHeader);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(BasicConfig.WORK_staticHeader,"数量总览数据为空",response.body().asString()));
        int starNum = response.jsonPath().getInt("data.starNum");
        int totalNum = response.jsonPath().getInt("data.totalNum");
        int unContactNum = response.jsonPath().getInt("data.unContactNum");
        int unMeetNum = response.jsonPath().getInt("data.unMeetNum");
        int unRedialNum = response.jsonPath().getInt("data.unRedialNum");
        int willRecycleCustNum = response.jsonPath().getInt("data.willRecycleCustNum");
        header.put("starNum",starNum);
        header.put("totalNum",totalNum);
        header.put("unContactNum",unContactNum);
        header.put("unMeetNum",unMeetNum);
        header.put("unRedialNum",unRedialNum);
        header.put("willRecycleCustNum",willRecycleCustNum);
    }

    @Test(description = "客户流程组_表格总览",priority = 10)
    public void 客户流程组_表格总览(){
        Response response = network.getResponse(BasicConfig.WORK_staticChart);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(BasicConfig.WORK_staticChart,"流程组表格数量为空",response.body().asString()));
        chart.put("ondStep",response.jsonPath().getInt("data[0].custNum"));
        chart.put("twoStep",response.jsonPath().getInt("data[1].custNum"));
        chart.put("threeStep",response.jsonPath().getInt("data[2].custNum"));
        chart.put("fourStep",response.jsonPath().getInt("data[3].custNum"));
        chart.put("fiveStep",response.jsonPath().getInt("data[4].custNum"));
    }

    @Test(description = "工作台_标签列表",priority = 11)
    public void 工作台_标签列表(){
        Response response = network.getResponse(BasicConfig.WORK_tagList);
        String tagName = response.jsonPath().getString("data.find{it.tagId =="+tagId+"}.tagName");
        Assert.assertEquals(tagName,"勿动-自动化更新标签",network.message(BasicConfig.WORK_tagList,"跟进表格数量为空",response.body().asString()));
    }

    @Test(description = "需要联系客户列表",priority = 12)
    public void 需要联系客户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        params.put("custClassifyType", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_customerList);
        int customerId = response.jsonPath().getInt("data.list[0].custId");
        Assert.assertEquals(customerId,custId,network.message(params,BasicConfig.WORK_customerList,"需要联系列表中首位客户非新增客户",response.body().asString()));

        int custStar = response.jsonPath().getInt("data.list[0].custStar");
        followTimes = response.jsonPath().getInt("data.list[0].followTimes");
        Object custValue = response.jsonPath().getJsonObject("data.list[0].custValue");
        Object lastFollowTime = response.jsonPath().getJsonObject("data.list[0].lastFollowTime");
        Assert.assertEquals(custStar,0,network.message(params,BasicConfig.WORK_customerList,"新客户默认为星标客户",response.body().asString()));
        Assert.assertEquals(followTimes,0,network.message(params,BasicConfig.WORK_customerList,"新客户的默认跟进次数不为0",response.body().asString()));
        Assert.assertNull(custValue,network.message(params,BasicConfig.WORK_customerList,"新客户的默认客户价值不为null",response.body().asString()));
        Assert.assertNull(lastFollowTime,network.message(params,BasicConfig.WORK_customerList,"新客户的默认跟进时间不为null",response.body().asString()));
    }

    @Test(description = "查询客户手机号",priority = 13)
    public void 查询客户手机号(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        Response response = network.getResponse(params,BasicConfig.WORK_phone);
        String data = response.jsonPath().getString("data");
        Assert.assertEquals(data,phone,network.message(params,BasicConfig.WORK_phone,"手机号错误",response.body().asString()));
    }

    @Test(description = "查询新客户见面情况",priority = 14)
    public void 查询新客户见面情况(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        Response response = network.getResponse(params,BasicConfig.WORK_info);
        boolean todayMeetFlag = response.jsonPath().getBoolean("data.todayMeetFlag");
        boolean orderVisitFlag = response.jsonPath().getBoolean("data.orderVisitFlag");
        Object orderVisitDate = response.jsonPath().getJsonObject("data.orderVisitDate");
        Assert.assertFalse(todayMeetFlag,network.message(params,BasicConfig.WORK_info,"今日见面状态错误：为已见面",response.body().asString()));
        Assert.assertFalse(orderVisitFlag,network.message(params,BasicConfig.WORK_info,"预约参观状态错误：为已预约",response.body().asString()));
        Assert.assertNull(orderVisitDate,network.message(params,BasicConfig.WORK_info,"预约时间不为空",response.body().asString()));
    }

    @Test(description = "查询新客户头部信息",priority = 15)
    public void 查询新客户头部信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        Response response = network.getResponse(params,BasicConfig.WORK_header);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(params,BasicConfig.WORK_header,"头部信息为空",response.body().asString()));
    }

    @Test(description = "查询新客户详细信息",priority = 16)
    public void 查询新客户详细信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        Response response = network.getResponse(params,BasicConfig.WORK_detail);
        int custFlow = response.jsonPath().getInt("data.custInfo.custFlow");
        int commitInsure = response.jsonPath().getInt("data.custInfo.commitInsure");
        int commitPlanFlag = response.jsonPath().getInt("data.custInfo.commitPlanFlag");
        Assert.assertEquals(custFlow,1,network.message(params,BasicConfig.WORK_detail,"新客户流程组状态错误非1",response.body().asString()));
        Assert.assertEquals(commitInsure,0,network.message(params,BasicConfig.WORK_detail,"新客户提交计划书状态错误非0",response.body().asString()));
        Assert.assertEquals(commitPlanFlag,0,network.message(params,BasicConfig.WORK_detail,"新客户投保要素确认状态错误非0",response.body().asString()));
    }

    @Test(description = "查询客户电话表单回填状态",priority = 17)
    public void 查询客户电话表单回填状态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        Response response = network.getResponse(params,BasicConfig.WORK_showFeedback);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertFalse(data,network.message(params,BasicConfig.WORK_showFeedback,"电话表单回填状态错误：为需要回填",response.body().asString()));
    }

    @Test(description = "查询省市列表",priority = 18)
    public void 查询省市列表(){
        Response response = network.getResponse(BasicConfig.WORK_regionCity);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(BasicConfig.WORK_regionCity,"省市列表为空",response.body().asString()));
    }

    @Test(description = "查询历史通话",priority = 19)
    public void 查询历史通话(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        params.put("logDays", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_callLog);
        Object data = response.jsonPath().getJsonObject("data");
        Assert.assertNotNull(data,network.message(params,BasicConfig.WORK_callLog,"历史通话为空",response.body().asString()));
    }

    @Test(description = "修改客户跟进权重",priority = 24)
    public void 修改客户跟进权重(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        params.put("followWeight", 1);
        Response response = network.postResponse(params,BasicConfig.WORK_weight);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_weight,"修改客户跟进权重失败",response.body().asString()));
    }

    @Test(description = "修改客户标签",priority = 25)
    public void 修改客户标签(){
        HashMap<String,Object> params = new HashMap<>();
        ArrayList<Integer> tags = new ArrayList<>();
        tags.add(tagId);
        params.put("custId", custId);
        params.put("tagIds", tags);
        Response response = network.postResponse(params,BasicConfig.WORK_tag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_tag,"修改客户标签失败",response.body().asString()));

        //查询信息更新
        params.clear();
        params.put("custId", custId);
        response = network.getResponse(params,BasicConfig.WORK_detail);
        int tagSize = response.jsonPath().getInt("data.custInfo.tagIds.size()");
        Assert.assertEquals(tagSize,1,network.message(params,BasicConfig.WORK_detail,"标签数量错误",response.body().asString()));
        int tId = response.jsonPath().getInt("data.custInfo.tagIds[0]");
        Assert.assertEquals(tId,tagId,network.message(params,BasicConfig.WORK_detail,"标签Id错误",response.body().asString()));
    }

    @Test(description = "修改标签状态为关闭",priority = 26)
    public void 修改标签状态为关闭(){
        ssoLogin();
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", tagId);
        params.put("tagStatus", 0);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_switchStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_switchStatus,"关闭标签显示失败",response.body().asString()));
    }

    @Test(description = "查询更新的标签列表和客户标签",priority = 27)
    public void 查询更新的标签列表和客户标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        Response response = network.getResponse(params,BasicConfig.WORK_detail);
        Object tagIds = response.jsonPath().getJsonObject("data.custInfo.tagIds");
        Assert.assertNull(tagIds,network.message(params,BasicConfig.WORK_detail,"标签数量错误",response.body().asString()));

        response = network.getResponse(BasicConfig.WORK_tagList);
        int size = response.jsonPath().getInt("data.findAll{it.tagId =="+tagId+"}.size()");
        Assert.assertEquals(size,0,network.message(BasicConfig.WORK_tagList,"跟进表格数量为空",response.body().asString()));

        params.clear();
        sleep(1000);
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        response = network.getResponse(params,BasicConfig.MANAGER_oto_tagList);
        int customerCount = response.jsonPath().getInt("data.list[0].customerCount");
        Assert.assertEquals(customerCount ,1,network.message(params,BasicConfig.MANAGER_oto_tagList,"标签的客户数不为1",response.body().asString()));
    }

    @Test(description = "修改标签状态为开启",priority = 28)
    public void 修改标签状态为开启() {
        ssoLogin();
        HashMap<String, Object> params = new HashMap<>();
        params.put("id", tagId);
        params.put("tagStatus", 1);
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_switchStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_switchStatus,"修改客户标签失败",response.body().asString()));
    }

    @Test(description = "删除客户标签",priority = 29)
    public void 删除客户标签() {
        HashMap<String,Object> params = new HashMap<>();
        ArrayList<Integer> tags = new ArrayList<>();
        params.put("custId", custId);
        params.put("tagIds", tags);
        Response response = network.postResponse(params,BasicConfig.WORK_tag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_tag,"修改客户标签失败",response.body().asString()));

        //校验还原
        params.clear();
        params.put("custId", custId);
        response = network.getResponse(params,BasicConfig.WORK_detail);
        Object tagIds = response.jsonPath().getJsonObject("data.custInfo.tagIds");
        Assert.assertNull(tagIds,network.message(params,BasicConfig.WORK_detail,"标签数量错误",response.body().asString()));

        response = network.getResponse(BasicConfig.WORK_tagList);
        int size = response.jsonPath().getInt("data.findAll{it.tagId =="+tagId+"}.size()");
        Assert.assertEquals(size,1,network.message(BasicConfig.WORK_tagList,"跟进表格数量为空",response.body().asString()));
    }

    @Test(description = "修改客户基础信息",priority = 37)
    public void 修改客户基础信息(){
        HashMap<String,Object> params = new HashMap<>();
        ArrayList<Integer> array = new ArrayList<>();
        params.put("custId", custId);
        params.put("commitPlanFlag", 0);
        params.put("addWxStatus", 0);
        params.put("coreMaker", 1);
        params.put("ideaAgree", 1);
        params.put("insApplicant", 4);
        params.put("insByApplicant", 4);
        params.put("insMoney", 500);
        params.put("insPeriod", 20);
        params.put("custArea", "北京-北京市");
        params.put("custDescription", "客户的备注");
        params.put("custName", "自动化测试用户");
        params.put("dealFlag", 0);
        params.put("forWho", array);
        params.put("retireMoney", 0);
        params.put("roomerAge", 0);
        params.put("roomerCity", "");
        params.put("visitOrg", array);
        Response response = network.postResponse(params,BasicConfig.WORK_edit);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_edit,"修改客户基础信息失败",response.body().asString()));
    }

    @Test(description = "查看客户动态",priority = 39)
    public void 查看客户动态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        params.put("logDays", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_operation);
        int logSize = response.jsonPath().getInt("data.list[0].dayLog.size()");
        Assert.assertTrue(logSize>0,network.message(params,BasicConfig.WORK_operation,"客户动态条数错误",response.body().asString()));
    }

    @Test(description = "姓名模糊查找客户",priority = 40)
    public void 姓名模糊查找客户(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custName", "自动化");
        Response response = network.getResponse(params,BasicConfig.WORK_fuzzyCustName);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.WORK_fuzzyCustName,"客户动态条数错误",response.body().asString()));
    }

    @Test(description = "公域引流_删除标签",priority = 41)
    public void 公域引流_删除标签(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", tagId);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_deleteTag);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_deleteTag,"删除标签失败",response.body().asString()));

        params.clear();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        response = network.getResponse(params,BasicConfig.MANAGER_oto_tagList);
        int id = response.jsonPath().getInt("data.list[0].id");
        Assert.assertTrue(id!= tagId ,network.message(params,BasicConfig.MANAGER_oto_tagList,"新标签的状态不为打开",response.body().asString()));
    }

    @Test(description = "公域引流_关闭销售呼叫权限",priority = 42)
    public void 公域引流_关闭销售呼叫权限(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", SELLER_ID);
        params.put("callPermission", 0);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_switchCallPermissio);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_switchCallPermissio,"关闭呼叫权限失败",response.body().asString()));
    }

    @Test(description = "关闭呼叫权限_呼叫失败",priority = 43)
    public void 关闭呼叫权限_呼叫失败(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        Response response = network.postResponse(params,BasicConfig.WORK_call);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_call,"关闭呼叫权限后呼叫成功",response.body().asString()));

        params.clear();
        params.put("id", SELLER_ID);
        params.put("callPermission", 1);
        response = network.postResponse(params,BasicConfig.MANAGER_oto_switchCallPermissio);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_switchCallPermissio,"关闭呼叫权限失败",response.body().asString()));
    }

    @Test(description = "公域引流_禁用销售账号",priority = 44)
    public void 公域引流_禁用销售账号(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", SELLER_ID);
        params.put("sellerStatus", 0);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_switchSellerStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_switchSellerStatus,"禁用销售账号失败",response.body().asString()));
    }

    @Test(description = "关闭销售权限_访问失败",priority = 45)
    public void 关闭销售权限_访问失败(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        params.put("custClassifyType", 1);
        Response response = network.getResponse(params,BasicConfig.WORK_customerList);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.WORK_customerList,"关闭销售权限后访问成功",response.body().asString()));

        params.clear();
        params.put("id", SELLER_ID);
        params.put("sellerStatus", 1);
        response = network.postResponse(params,BasicConfig.MANAGER_oto_switchSellerStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_switchSellerStatus,"启用销售账号失败",response.body().asString()));
    }

    @Test(description = "公域引流_解密客户手机号",priority = 46)
    public void 公域引流_解密客户手机号(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", custId);
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        Response response = network.getResponse(params,BasicConfig.MANAGER_oto_customerPhone);
        String data = response.jsonPath().getString("data");
        Assert.assertEquals(data,phone,network.message(params,BasicConfig.MANAGER_oto_qaDetail,"解密手机号失败",response.body().asString()));
    }

    @Test(description = "公域引流_查询问题详情",priority = 47)
    public void 公域引流_查询问题详情(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("customerId", custId);
        Response response = network.getResponse(params,BasicConfig.MANAGER_oto_qaDetail);;
        int answer = response.jsonPath().getInt("data.list[0].optionTitles.size()");
        Assert.assertTrue(answer>0,network.message(params,BasicConfig.MANAGER_oto_customerPhone,"问题详情为空",response.body().asString()));
    }

    @Test(description = "放弃客户进入回收池",priority = 48)
    public void 放弃客户进入回收池(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        params.put("abandonReasonType", 3);
        params.put("abandonRemark", "放弃原因"+new Date());
        Response response = network.postResponse(params,BasicConfig.WORK_abandonCust);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_abandonCust,"放弃客户失败",response.body().asString()));
    }

    @Test(description = "查询投放池刷新配置",priority = 49)
    public void 查询投放池刷新配置(){
        Response response = network.getResponse(BasicConfig.WORK_leadsConfig);
        int dayAssignLimit = response.jsonPath().getInt("data.dayAssignLimit");
        Assert.assertNotNull(dayAssignLimit,network.message(BasicConfig.WORK_leadsConfig,"查询投放池刷新配置失败",response.body().asString()));
    }

    @Test(description = "查看投放池客户列表",priority = 50)
    public void 查看投放池客户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params,BasicConfig.WORK_freshList);
        Object list = response.jsonPath().getJsonObject("data.list");
        Assert.assertNotNull(list,network.message(params,BasicConfig.WORK_freshList,"查看投放池客户不为空",response.body().asString()));
    }

    @Test(description = "查看回收池客户列表",priority = 51)
    public void 查看回收池客户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params,BasicConfig.WORK_recycleList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.WORK_recycleList,"查看回收池客户列表为空",response.body().asString()));
        int result = response.jsonPath().getInt("data.list.findAll{it.custId == "+custId+"}.size()");
        Assert.assertEquals(result,1,network.message(params,BasicConfig.WORK_recycleList,"回收池客户列表不包含刚刚的回收客户",response.body().asString()));
    }

    @Test(description = "认领回收池客户",priority = 52)
    public void 认领回收池客户(){
        sleep(2000);
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        Response response = network.postResponse(params,BasicConfig.WORK_claim);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_claim,"删除客户失败",response.body().asString()));
    }

    @Test(description = "客户总数更新",priority = 53)
    public void 客户总数更新(){
        sleep(1000);
        Response response = network.getResponse(BasicConfig.WORK_staticHeader);
        int totalNum = response.jsonPath().getInt("data.totalNum");
        int num = header.get("totalNum");
        Assert.assertEquals(totalNum, num,network.message(BasicConfig.WORK_staticChart,"客户总数未更新",response.body().asString()));
    }

    @Test(description = "查询认领客户评价清空",priority = 54)
    public void 查询认领客户评价清空(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId", custId);
        Response response = network.getResponse(params,BasicConfig.WORK_header);
        Object custValue = response.jsonPath().getJsonObject("data.custValue");
        Object followWeight = response.jsonPath().getJsonObject("data.followWeight");
        Assert.assertNull(custValue,network.message(params,BasicConfig.WORK_header,"客户价值未清空",response.body().asString()));
        Assert.assertNull(followWeight,network.message(params,BasicConfig.WORK_header,"客户权重未清空",response.body().asString()));
    }

    @Test(description = "总监查看名下销售列表",priority = 55)
    public void 总监查看名下销售列表(){
        otoLeaderAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        Response response = network.getResponse(params, BasicConfig.WORK_attendanceList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.WORK_attendanceList,"总监名下销售列表为空",response.body().asString()));
    }

    @Test(description = "总监修改名下销售工作状态",priority = 56)
    public void 总监修改名下销售工作状态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerId", SELLER_ID);
        params.put("workStatus", 0);
        Response response = network.postResponse(params, BasicConfig.WORK_switchWorkStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.WORK_logout,"总监修改名下销售工作状态失败",response.body().asString()));
    }

    @Test(description = "总监修改非名下销售工作状态",priority = 57)
    public void 总监修改非名下销售工作状态(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerId", 1);
        params.put("workStatus", 0);
        Response response = network.postResponse(params, BasicConfig.WORK_switchWorkStatus);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(BasicConfig.WORK_logout,"总监修改非名下销售工作状态成功",response.body().asString()));
    }

    @Test(description = "销售间客户动态取消隔离",priority = 58)
    public void 销售间客户动态取消隔离(){
        //将客户重新分配给总监
        HashMap<String,Object> params = new HashMap<>();
        params.put("customerId",custId);
        params.put("sellerId",LEADER_ID);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_assignSeller);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.MANAGER_oto_assignSeller,"重新分配失败",response.body().asString()));

        //总监查看客户动态
        params.clear();
        params.put("custId",custId);
        params.put("logDays",1);
        Response logRes = network.getResponse(params,BasicConfig.WORK_operation);
        int logSize = logRes.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(logSize>0,network.message(BasicConfig.WORK_operation,"客户动态隔离失败",logRes.body().asString()));

        //还原
        params.clear();
        params.put("customerId",custId);
        params.put("sellerId",SELLER_ID);
        response = network.postResponse(params,BasicConfig.MANAGER_oto_assignSeller);
    }

    @Test(description = "关闭总监的新客户认领权限和回收客户认领权限",priority = 59)
    public void 关闭总监的新客户认领权限和回收客户认领权限(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", LEADER_ID);
        params.put("sellerStatus", 1);
        params.put("callPermission", 1);
        params.put("assignNewCustPermission", 0);
        params.put("assignRecycleCustPermission", 0);
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_updatePermission);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(BasicConfig.MANAGER_oto_updatePermission,"关闭总监的新客户认领权限和回收客户认领权限失败",response.body().asString()));
    }

    @Test(description = "无新客户认领权限不可查看新客户列表",priority = 60)
    public void 无新客户认领权限不可查看新客户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params,BasicConfig.WORK_freshList);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(BasicConfig.WORK_logout,"无新客户认领权限可查看新客户列表",response.body().asString()));
    }

    @Test(description = "无回收客户认领权限不可查看回收客户列表",priority = 61)
    public void 无回收客户认领权限不可查看回收客户列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params,BasicConfig.WORK_recycleList);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(BasicConfig.WORK_logout,"无回收客户认领权限可查看回收客户列表",response.body().asString()));
    }

    @Test(description = "开启总监的新客户认领权限和回收客户认领权限",priority = 62)
    public void 开启总监的新客户认领权限和回收客户认领权限(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", LEADER_ID);
        params.put("sellerStatus", 1);
        params.put("callPermission", 1);
        params.put("assignNewCustPermission", 1);
        params.put("assignRecycleCustPermission", 1);
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_updatePermission);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertTrue(success,network.message(BasicConfig.MANAGER_oto_updatePermission,"开启总监的新客户认领权限和回收客户认领权限失败",response.body().asString()));
    }


    @Test(description = "新建日程",priority = 63)
    public void 新建日程(){
        //获取日程提醒数量
        Response listRes = network.getResponse(BasicConfig.WORK_notifyList);
        int size = listRes.jsonPath().getInt("data.size()");

        //新建日程
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",custId);
        params.put("notifyTime",System.currentTimeMillis()+3600000);
        params.put("type","phone");
        Response scheduleRes =network.postResponse(params,BasicConfig.WORK_saveOrModifySchedule);
        boolean success = scheduleRes.jsonPath().getBoolean("data");
        Assert.assertTrue(success,network.message(BasicConfig.WORK_saveOrModifySchedule,"新建日程失败",scheduleRes.body().asString()));

        //日程通知数量增加
        Response listRes2 = network.getResponse(BasicConfig.WORK_notifyList);
        int size2 = listRes2.jsonPath().getInt("data.size()");
        Assert.assertTrue(size<size2,network.message(BasicConfig.WORK_notifyList,"日程通知未展示新建日程",listRes.body().asString()));
    }

    @Test(description = "取消日程",priority = 64)
    public void 取消日程(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("custId",custId);
        Response response =network.postResponse(params,BasicConfig.WORK_cancelSchedule);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(BasicConfig.WORK_cancelSchedule,"取消日程失败",response.body().asString()));
    }

    @Test(description = "普通销售不可查看审批管理",priority = 65)
    public void 普通销售不可查看审批管理(){
        otosellerAuth();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response =network.getResponse(params,BasicConfig.WORK_interviewAuditList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(size,0,network.message(BasicConfig.WORK_interviewAuditList,"查看审批列表不为空",response.body().asString()));
    }

    @Test(description ="获取任务管理列表",priority = 66)
    public void 获取任务管理列表(){
        otoManagerAuth();
        Response response = network.getResponse(BasicConfig.WORK_taskConfList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size==3,network.message(BasicConfig.WORK_taskConfList,"获取任务配置数量错误",response.body().asString()));
    }

    @Test(description = "修改任务配置",priority = 67)
    public void 修改任务配置(){
        HashMap<String,Object> params = new HashMap<>();
        List list = new ArrayList();
        list.add(3);
        list.add(4);
        list.add(2);
        params.put("custSourceList",list);//客户来源：1:缘故客户 2:转介绍客户 3:投放客户 4.直播客户 5.助手客户
        params.put("custType",1); //1:全部客户；2:新客户；3:老客户
        params.put("id",4);
        params.put("limitGoalFlag",0);
        params.put("taskUsable",0); //0:任务状态关闭；1:任务状态开启
        Response response = network.postResponse(params,BasicConfig.WORK_modifyTaskConf);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.WORK_modifyTaskConf,"修改任务失败",response.body().asString()));

        //获取任务列表验证修改是否成功
        Response listRes = network.getResponse(BasicConfig.WORK_taskConfList);
        int custType = listRes.jsonPath().getInt("data[0].custType");
        Assert.assertEquals(custType,1,network.message(BasicConfig.WORK_taskConfList,"修改任务配置失败",listRes.body().asString()));

        //恢复默认配置
        params.clear();
        List acqList = new ArrayList();
        acqList.add(3);
        acqList.add(4);
        params.put("custSourceList",list);//客户来源：1:缘故客户 2:转介绍客户 3:投放客户 4.直播客户 5.助手客户
        params.put("custType",2); //1:全部客户；2:新客户；3:老客户
        params.put("id",4);
        params.put("limitGoalFlag",0);
        params.put("taskUsable",1); //0:任务状态关闭；1:任务状态开启
        Response acqRes = network.postResponse(params,BasicConfig.WORK_modifyTaskConf);
        boolean acqData = acqRes.jsonPath().getBoolean("data");
        Assert.assertTrue(acqData,network.message(params,BasicConfig.WORK_modifyTaskConf,"修改任务失败",acqRes.body().asString()));
    }

    @Test(description = "客户总览_销售查看任务",priority = 68)
    public void 销售查看任务(){
        otosellerAuth();
        sleep(2000);
        Response response = network.getResponse(BasicConfig.WORK_statisticHeader);
        int finishCustNum = response.jsonPath().getInt("data[0].finishCustNum");
        System.out.println(finishCustNum);
        Assert.assertEquals(finishCustNum,0,network.message(BasicConfig.WORK_statisticHeader,"销售任务统计错误",response.body().asString()));
    }

    @Test(description = "查看联系新客户任务明细",priority = 69)
    public void 查看联系新客户任务明细(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("taskConfId",4); //任务配置id，4:联系未跟进的客户，5:复拨未接通的客户，6:超过N天未跟进的客户
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response = network.getResponse(params,BasicConfig.WORK_taskDetailsList);
        int finishCustNum = response.jsonPath().getInt("data.finishCustNum");
        int listSize = response.jsonPath().getInt("data.list.size()");
        Assert.assertEquals(finishCustNum,0,network.message(params,BasicConfig.WORK_taskDetailsList,"已完成数量记录错误",response.body().asString()));
        Assert.assertTrue(listSize>0,network.message(params,BasicConfig.WORK_taskDetailsList,"待完成客户数统计错误",response.body().asString()));
    }

    @Test(description = "查看我的预约列表",priority = 70)
    public void 查看我的预约列表(){
        agent2Tku();
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex",1);
        params.put("pageSize",20);
        Response response =network.getResponse(params,BasicConfig.PHONE_getReservationList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertEquals(size,1,network.message(BasicConfig.PHONE_getReservationList,"查看预约列表不为空",response.body().asString()));

        int bookingStatus = response.jsonPath().getInt("data[0].bookingStatus");
        Assert.assertEquals(bookingStatus,0,network.message(BasicConfig.PHONE_getReservationList,"预约状态错误：非待参观",response.body().asString()));
    }

}
