package com.oto.cases.otoseller;

import com.oto.config.BasicConfig;
import com.oto.utils.NetworkUtils;
import io.restassured.response.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;

import static com.oto.config.BasicConfig.LEADER_ID;
import static com.oto.utils.BaseUtils.ssoLogin;
import static com.oto.utils.ThreadSleepUtils.sleep;

public class Manager {

    private static final NetworkUtils network = NetworkUtils.getInstance();
    private int sellerId;        //销售ID
    @BeforeTest
    public void setUp(){
        ssoLogin();
    }

    @Test(description = "分页查看销售列表",priority = 1)
    public void 分页查看销售列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", "1");
        params.put("pageSize", "20");
        Response response = network.getResponse(params, BasicConfig.MANAGER_oto_sellerList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.MANAGER_oto_sellerList,"销售列表为空",response.body().asString()));

        int workStatus = response.jsonPath().getInt("data.list.find{it.id == "+ 42+"}.workStatus");
        int assignNewCustPermission = response.jsonPath().getInt("data.list.find{it.id == "+ 42+"}.assignNewCustPermission");
        int assignRecycleCustPermission = response.jsonPath().getInt("data.list.find{it.id == "+ 42+"}.assignRecycleCustPermission");
        int callPermission = response.jsonPath().getInt("data.list.find{it.id == "+ 42+"}.callPermission");
        Assert.assertEquals(workStatus,1,network.message(params,BasicConfig.MANAGER_oto_searchSeller,"工作状态错误",response.body().asString()));
        Assert.assertEquals(assignNewCustPermission,1,network.message(params,BasicConfig.MANAGER_oto_searchSeller,"认领新客户及强制分配权限错误",response.body().asString()));
        Assert.assertEquals(assignRecycleCustPermission,1,network.message(params,BasicConfig.MANAGER_oto_searchSeller,"认领回收客户权限错误",response.body().asString()));
        Assert.assertEquals(callPermission,1,network.message(params,BasicConfig.MANAGER_oto_searchSeller,"呼叫权限错误",response.body().asString()));
    }

    @Test(description = "通过销售名称查找销售",priority = 2)
    public void 通过销售名称查找销售(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerName", "勿动-自动化测试销售");
        Response response = network.getResponse(params, BasicConfig.MANAGER_oto_searchSeller);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.MANAGER_oto_searchSeller,"查找结果为空",response.body().asString()));

        sellerId = response.jsonPath().getInt("data[0].id");
    }

    @Test(description = "修改销售信息",priority = 3)
    public void 修改销售信息(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", sellerId);
        params.put("sellerName", "勿动-自动化更新销售");
        params.put("phoneNumber", "18248405155");
        params.put("roleType", 1);
        params.put("callPermission", 0);
        params.put("sellerStatus", 0);
        params.put("companyId", 1);
        params.put("companyName", "勿动-自动化测试公司");
        params.put("sellerLevel", 2);
        params.put("workStatus", 1);
        params.put("parentId", 28);
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_updateSeller);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_updateSeller,"修改客户失败",response.body().asString()));

        sleep(1000);
        HashMap<String,Object> selectParam = new HashMap<>();
        selectParam.put("sellerName", "勿动-自动化更新销售");
        selectParam.put("phoneNumber", "18248405155");
        selectParam.put("pageIndex", "1");
        selectParam.put("pageSize", "10");
        response = network.getResponse(selectParam, BasicConfig.MANAGER_oto_sellerList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(selectParam,BasicConfig.MANAGER_oto_sellerList,"查找结果为空",response.body().asString()));

        //还原
        params.put("callPermission", 1);
        params.put("sellerStatus", 1);
        params.put("companyId", 5);
        params.put("sellerLevel", 1);
        params.put("parentId", LEADER_ID);
        params.put("sellerName", "勿动-自动化测试销售");
        response = network.postResponse(params, BasicConfig.MANAGER_oto_updateSeller);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_updateSeller,"修改客户失败",response.body().asString()));
    }

    @Test(description = "查询渠道列表",priority = 4)
    public void 查询渠道列表(){
        Response response = network.getResponse(BasicConfig.MANAGER_oto_channelList);
        int size = response.jsonPath().getInt("data.size");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_oto_channelList,"渠道列表为空",response.body().asString()));
    }

    @Test(description = "不可新增同一手机号销售",priority = 5)
    public void 不可新增同一手机号销售(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerName", "勿动-自动化销售");
        params.put("phoneNumber", "18248405155");
        params.put("roleType", 1);
        params.put("callPermission", 1);
        params.put("sellerStatus", 1);
        params.put("companyId", 1);
        params.put("sellerLevel", 1);
        params.put("workStatus", 1);
        params.put("assignNewCustPermission", 1);
        params.put("assignRecycleCustPermission", 1);
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_saveSeller);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.MANAGER_oto_saveSeller,"新增同一手机号销售成功",response.body().asString()));
    }

    //接口对此场景做校验，仅前端做了限制
//    @Test(description = "不可修改总监为普通",priority = 6)
//    public void 不可修改总监为普通(){
//        HashMap<String,Object> params = new HashMap<>();
//        params.put("id", LEADER_ID);
//        params.put("sellerName", "勿动-自动化测试总监");
//        params.put("phoneNumber", "18248405155");
//        params.put("roleType", 1);
//        params.put("callPermission", 1);
//        params.put("sellerStatus", 1);
//        params.put("companyId", 3);
//        params.put("sellerLevel", 1);
//        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_updateSeller);
//        boolean success = response.jsonPath().getBoolean("success");
//        Assert.assertFalse(success,network.message(params,BasicConfig.MANAGER_oto_updateSeller,"修改总监为普通销售成功",response.body().asString()));
//    }

    @Test(description = "不可新增同名公司",priority = 7)
    public void 不可新增同名公司(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("companyName", "勿动-自动化测试公司");
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_saveCompany);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.MANAGER_oto_saveCompany,"新增同名公司成功",response.body().asString()));
    }

    @Test(description = "修改公司名称",priority = 8)
    public void 修改公司名称(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 5);
        params.put("companyName", "勿动-自动化测试公司更新");
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_updateCompany);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_updateCompany,"修改客户失败",response.body().asString()));
    }

    @Test(description = "分页查看公司列表",priority = 9)
    public void 分页查看公司列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 20);
        Response response = network.getResponse(params, BasicConfig.MANAGER_oto_listCompany);
        int size = response.jsonPath().getInt("data.list.findAll{it.companyName == \""+"勿动-自动化测试公司更新"+"\"}.size()");
        Assert.assertEquals(size,1,network.message(params,BasicConfig.MANAGER_oto_listCompany,"查询更新的公司名称失败",response.body().asString()));

        //还原
        params.clear();
        params.put("id", 5);
        params.put("companyName", "勿动-自动化测试公司");
        response = network.postResponse(params, BasicConfig.MANAGER_oto_updateCompany);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_updateCompany,"修改客户失败",response.body().asString()));
    }

    @Test(description = "查看所有公司列表",priority = 10)
    public void 查看所有公司列表(){
        Response response = network.getResponse(BasicConfig.MANAGER_oto_listAllCompany);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_oto_listAllCompany,"查看所有公司列表为空",response.body().asString()));
    }

    @Test(description = "查看所有总监列表",priority = 11)
    public void 查看所有总监列表(){
        Response response = network.getResponse(BasicConfig.MANAGER_oto_directorList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_oto_directorList,"查看所有总监列表为空",response.body().asString()));
    }

    @Test(description = "修改工作状态为请假中",priority = 12)
    public void 修改工作状态为请假中(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerId", LEADER_ID);
        params.put("workStatus", 0);
        Response response = network.postResponse(params, BasicConfig.MANAGER_oto_switchWorkStatus);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_updateCompany,"修改工作状态为请假中失败",response.body().asString()));
    }

    @Test(description = "总监下有销售离职失败",priority = 13)
    public void 总监下有销售离职失败(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 43);
        params.put("dimissionStatus", 1);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_switchDimissionStatus);
        boolean success = response.jsonPath().getBoolean("success");
        Assert.assertFalse(success,network.message(params,BasicConfig.MANAGER_oto_switchDimissionStatus,"总监名下存在销售但离职成功",response.body().asString()));
    }

    @Test(description = "修改公司产品",priority = 14)
    public void 修改公司产品(){
        ArrayList companyIds = new ArrayList();
        companyIds.add(5);
        ArrayList costOptions = new ArrayList();
        costOptions.add(0);
        costOptions.add(1);
        costOptions.add(2);
        ArrayList moneyOptions = new ArrayList();
        moneyOptions.add(1);
        moneyOptions.add(2);
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 19);
        params.put("prodName", "勿动-自动化专用产品更新");
        params.put("companyIds", companyIds);
        params.put("costOptions", costOptions);
        params.put("moneyOptions", moneyOptions);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_productSave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_productSave,"修改公司产品失败",response.body().asString()));
    }

    @Test(description = "查看产品列表",priority = 15)
    public void 查看产品列表(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("pageIndex", 1);
        params.put("pageSize", 10);
        params.put("companyIds", 5);
        params.put("prodStatus", 1);
        Response response = network.getResponse(params,BasicConfig.MANAGER_oto_productList);
        int size = response.jsonPath().getInt("data.list.size()");
        Assert.assertTrue(size>0,network.message(params,BasicConfig.MANAGER_oto_productList,"查询公司产品为空",response.body().asString()));
        int id = response.jsonPath().getInt("data.list[0].id");
        Assert.assertEquals(id,19,network.message(params,BasicConfig.MANAGER_oto_productList,"查询公司产品错误",response.body().asString()));
        int costOptionsSize = response.jsonPath().getInt("data.list[0].costOptions.size()");
        String prodName = response.jsonPath().getString("data.list[0].prodName");
        Assert.assertEquals(costOptionsSize,3,network.message(params,BasicConfig.MANAGER_oto_productList,"产品的缴费期未更新",response.body().asString()));
        Assert.assertEquals(prodName,"勿动-自动化专用产品更新",network.message(params,BasicConfig.MANAGER_oto_productList,"产品的名称未更新",response.body().asString()));
    }

    @Test(description = "还原公司产品",priority = 16)
    public void 还原公司产品(){
        ArrayList companyIds = new ArrayList();
        companyIds.add(5);
        ArrayList costOptions = new ArrayList();
        costOptions.add(0);
        costOptions.add(1);
        costOptions.add(2);
        costOptions.add(3);
        ArrayList moneyOptions = new ArrayList();
        moneyOptions.add(1);
        moneyOptions.add(2);
        moneyOptions.add(3);
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", 19);
        params.put("prodName", "勿动-自动化专用产品");
        params.put("companyIds", companyIds);
        params.put("costOptions", costOptions);
        params.put("moneyOptions", moneyOptions);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_productSave);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_productSave,"修改公司产品失败",response.body().asString()));
    }

    @Test(description = "查看第三方账号列表",priority = 17)
    public void 查看第三方账号列表(){
        Response response = network.getResponse(BasicConfig.MANAGER_oto_accountList);
        int size = response.jsonPath().getInt("data.size()");
        Assert.assertTrue(size>0,network.message(BasicConfig.MANAGER_oto_accountList,"查询第三方账号列表为空",response.body().asString()));
    }

    @Test(description = "绑定第三方坐席",priority = 18)
    public void 绑定第三方坐席(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerId", sellerId);
        params.put("accountName", "8060@fhpcs");
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_accountBind);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_accountBind,"绑定第三方账号失败",response.body().asString()));
    }

    @Test(description = "解绑第三方坐席",priority = 19)
    public void 解绑第三方坐席(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("sellerId", sellerId);
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_accountUnbind);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_accountUnbind,"解绑坐席账号失败",response.body().asString()));
    }

    @Test(description = "换绑手机并还原",priority = 20)
    public void 换绑手机并还原(){
        HashMap<String,Object> params = new HashMap<>();
        params.put("id", sellerId);
        params.put("newPhoneNum", "14783743847");
        Response response = network.postResponse(params,BasicConfig.MANAGER_oto_change);
        boolean data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_change,"解绑坐席账号失败",response.body().asString()));

        params.clear();
        params.put("phoneNumber", "14783743847");
        params.put("pageIndex", "1");
        params.put("pageSize", "20");
        response = network.getResponse(params, BasicConfig.MANAGER_oto_sellerList);
        int id = response.jsonPath().getInt("data.list[0].id");
        Assert.assertEquals(id,sellerId,network.message(params,BasicConfig.MANAGER_oto_sellerList,"销售列表为空",response.body().asString()));

        params.clear();
        params.put("id", sellerId);
        params.put("newPhoneNum", "18248405155");
        response = network.postResponse(params,BasicConfig.MANAGER_oto_change);
        data = response.jsonPath().getBoolean("data");
        Assert.assertTrue(data,network.message(params,BasicConfig.MANAGER_oto_change,"解绑坐席账号失败",response.body().asString()));
    }

}
