/**
 * index.jsx
 * Created by 还有醋v on 2022/10/10 下午3:03.
 * Copyright © 2022 haiyoucuv. All rights reserved.
 */

import React, { CSSProperties, MouseEventHandler, ReactElement, useState } from "react";


interface IButtonProps {
    className?: string;
    onClick?: MouseEventHandler;
    children?: ReactElement,
    style?: CSSProperties,
}

/**
 * @return ReactElement
 * @constructor
 * @param props
 */
export const Button = (props: IButtonProps): ReactElement => {

    const {
        children,
        className,
        onClick = () => void 0,
        style = {}
    } = props;

    const [scale, setScale] = useState("unset");

    const onTouchStart = () => {
        setScale("scale(0.9,0.9)");
    };

    const onTouchEnd = () => {
        setScale("unset");
    };

    const onTouchCancel = onTouchEnd;

    return React.createElement("div", {
        className, onTouchStart, onTouchEnd, onTouchCancel, onClick, style: {
            transitionDuration: 0.5, transform: scale, ...style
        }
    }, children);
};
