import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import legacy from '@vitejs/plugin-legacy'

import autoprefixer from "autoprefixer"
import postcsspxtorem from "postcss-pxtorem"
import { viteMockServe } from "vite-plugin-mock";
import DuibaPublish from "./plugins/DuibaPublish/DuibaPublish.ts";

const isProd = process.env.NODE_ENV == "production";

const versionStamp = Date.now();

const origin = "//yun.duiba.com.cn";

const uploadDir = `db_games/spark_template/${versionStamp}`;

const prodBase = `${origin}/${uploadDir}/`;

// https://vitejs.dev/config/
export default defineConfig({
  base: isProd ? prodBase : "",
  plugins: [
    react({
      babel: {
        plugins: [
          ["@babel/plugin-proposal-decorators", {legacy: true}],
          ["@babel/plugin-proposal-class-properties", {loose: true}],
        ],
      },
    }),
    legacy({
      targets: ['defaults', 'not IE 11'],
    }),
    viteMockServe({
      // default
      mockPath: 'mock',
      enable: true,
    }),
    isProd && DuibaPublish({
      buildVersion: versionStamp,
      uploadDir: uploadDir,
      region: "oss-cn-hangzhou",
      bucket: "duiba-credits-test",
      accessKeyId: "LTAI5tPUSSxgkEmKPAfVXUQQ",
      accessKeySecret: "6sk3EDd1BYrXlAUoh8maMuN7hOMkh1",
    }),
  ],
  css: {
    postcss: {
      plugins: [
        autoprefixer({
          overrideBrowserslist: [
            "Android 4.1",
            "iOS 7.1",
            "Chrome > 31",
            "ff > 31",
            "ie >= 8",
            "last 10 versions", // 所有主流浏览器最近10版本用
          ],
          grid: true
        }),
        postcsspxtorem({
          rootValue: 100,
          propList: ["*", "!border"], // 除 border 外所有px 转 rem
          selectorBlackList: [".el-"], // 过滤掉.el-开头的class，不进行rem转换
        }),
      ],
    },
    preprocessorOptions: {
      less: {
        javascriptEnabled: true,
      },
    },
    modules: {
      localsConvention: 'camelCase'
    }
  }
})
