import MD from "@/built-in/md";

import { logClick, logExposure } from "@spark/utils/src-js/md";

const appId = CFG.appID;
const dcm = "202." + CFG.projectId + ".0.0";
const domain = "//embedlog.duiba.com.cn";
const dom = `${CFG.channel}.0.0.0`
const MDList = new Array(50).fill("").map((v, i) => {
  return {
    ele: `.md${i + 1}`,
    data: {
      dpm: `${appId}.110.${i + 1}.0`,
      dcm,
      domain,
      appId,
      dom,
    },
    once: false,
  };
});

export default () =>
  MD({
    show: MDList, // 曝光
    click: MDList, // 点击
  });

export function handleLogExposure(id, id2 = 0) {
  logExposure({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
    dom
  });
}
export function handleLogClick(id, id2 = 0) {
  logClick({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
    dom
  });
}
