import * as utils from "./utils.js";
import "./intersection-observer.polyfill.js";
import "intersection-observer";

const showedMapper = {};

function split(str, seprator) {
    return str.split(seprator);
}

/**
 *
 * @return {} pass
 * @param param
 */
function validateParam(param) {
    if (!param) {
        console.warn("参数MO不能为空，当前的参数为：", param);
        return false;
    }

    if (!param.dcm) {
        console.warn("dcm 必填。当前的参数为：", param);
        return false;
    }

    if (!param.dpm && !param.dom) {
        console.warn("dpm 和 dom 至少有一个。当前的参数为：", param);
        return false;
    }
    if (param.dpm && split(param.dpm, ".").length !== 4) {
        console.warn("dpm格式不正确。 当前的参数为：", param);
        return false;
    }
    if (param.dom && split(param.dom, ".").length !== 4) {
        console.warn("dom格式不正确。 当前的参数为：", param);
        return false;
    }
    if (split(param.dcm, ".").length !== 4) {
        console.warn("dcm格式不正确。 当前的参数为：", param);
        return false;
    }
    return true;
}

function doClickLog(data) {
    if (!validateParam(data)) {
        return;
    }
    const net = {
        name: "clickLog",
        uri: "/log/click",
        type: "get",
        dataType: "json",
        param: data,
        callback: null,
        hideMsg: true,
    };
    doAjax(net);
}

const intersectionObservers: IntersectionObserver[] = []

function registryIntersectionObserver(items) {
    for (const observer of intersectionObservers) {
        observer.disconnect()
    }
    intersectionObservers.splice(0)

    items.forEach((item) => {
        if (typeof item.ele === "string") {
            generatorShow(item);
        } else {
            item.ele.map((eleChild) => generatorShow({ ...item, ele: eleChild }));
        }
        // // 目标元素在dom中则处理
        // if (!!utils.getReference(item.ele)) {
        //   // 参数校验
        //   if (!item || !validateParam(item.data)) {
        //     return;
        //   }

        //   var observer = new IntersectionObserver(function (changes) {
        //     const { once = true, ele, data = {} } = item;
        //     changes.forEach((change) => {
        //       // 如果出现在页面中
        //       if (change.intersectionRatio > 0) {
        //         // 已经曝光过了
        //         if (showedMapper[ele]) {
        //           return;
        //         }

        //         showedMapper[ele] = true;

        //         observer.unobserve(change.target);
        //         const net = {
        //           name: "showLog",
        //           uri: data.domain + "/exposure/standard",
        //           type: "get",
        //           dataType: "jsonp",
        //           param: data,
        //           callback: null,
        //           hideMsg: true,
        //         };
        //         doAjax(net);
        //       } else {
        //         // 消失在视口
        //         if (!once) {
        //           // 如果需要曝光多次就移除
        //           showedMapper[ele] = false;
        //         }
        //       }
        //     });
        //   }, {});
        //   // 为目标元素注册IntersectionObserver
        //   let element = utils.getReference(item.ele);
        //   element && observer.observe(element);
        // }
    });
}

const generatorShow = (item) => {
    // 目标元素在dom中则处理
    if (utils.getReference(item.ele)) {
        // 参数校验
        if (!item || !validateParam(item.data)) {
            return;
        }

        const observer = new IntersectionObserver(function (changes) {
            const { once = true, ele, data = {} } = item;
            changes.forEach((change) => {
                // 如果出现在页面中
                if (change.intersectionRatio > 0) {
                    // 已经曝光过了
                    if (showedMapper[ele]) {
                        return;
                    }

                    showedMapper[ele] = true;

                    observer.unobserve(change.target);
                    const net = {
                        name: "showLog",
                        uri: data.domain + "/exposure/standard",
                        type: "get",
                        dataType: "jsonp",
                        param: data,
                        callback: null,
                        hideMsg: true,
                    };
                    doAjax(net);
                } else {
                    // 消失在视口
                    if (!once) {
                        // 如果需要曝光多次就移除
                        showedMapper[ele] = false;
                    }
                }
            });
        }, {});
        // 为目标元素注册IntersectionObserver
        const element = utils.getReference(item.ele);
        element && observer.observe(element);

        intersectionObservers.push(observer)
    }
};

function doShowLog(items) {
    // 先注册一次
    registryIntersectionObserver(items);

    // 每次dom 插入节点的时候重新检测
    const observer = new MutationObserver(function () {
        registryIntersectionObserver(items);
    });
    observer.observe(document, { childList: true, subtree: true });
}

/**
 * 发送请求
 * @param net
 */
export const doAjax = (net) => {
    let realUrl = net.uri;
    //url加参数等特殊需求（例如再玩一次需要在dostart接口的url上加埋点）
    if (net.addUrl) {
        realUrl += net.addUrl;
    }
    window["$"].ajax({
        type: net.type,
        url: realUrl,
        dataType: net.dataType,
        data: net.param,
        async: true,
        success: (result) => {
            console.log(`完成${net.name}${net.param}`);
        },
        error: (message) => {
            console.info(message)
        },
    });
};

const MD = {
    doClickLog: (data) => doClickLog(data),
    doShowLog: (items) => doShowLog(items),
};

export default MD;
