import MD from "./main";
import * as utils from "./utils";

// 如果点击埋点和跳转埋点只能添加一个的话，两个mapper可以合并成为一个mapper
const clickMapper = new Map();

const handleClick = (click: any[]) => {
    click.forEach((item) => {
        // 元素在文档， 并且没有绑定点击埋点
        // 那么需要绑定点击埋点
        if (typeof item.ele === "string") {
            generatorClick(item);
        } else {
            item.ele.map((eleChild) => generatorClick({ ...item, ele: eleChild }));
        }
    });
};

const generatorClick = (item) => {
    const ele = utils.getReference(item.ele);
    if (!!ele && !clickMapper.get(item.ele)) {
        const handler = MD.doClickLog.bind(null, item.data);
        clickMapper.set(item.ele, {
            ele,
            handler,
        });
        ele.addEventListener("click", handler);
    }
    // 元素不在文档，绑定了点击埋点(其实不是不在文档，而是比如class改变导致选择器无法再选中而已)
    // 那么需要将点击埋点移除
    if (!ele && clickMapper.get(item.ele)) {
        console.log("元素不在文档");
        clickMapper.get(item.ele).ele.removeEventListener("click", clickMapper.get(item.ele).handler);
        clickMapper.set(item.ele, null);
    }
}

const MaiDianConnector = (config) => {
    const { show, click } = config;
    MD.doShowLog(show);
    if (click && click.length) {
        handleClick(click);

        // 每次dom 插入节点的时候重新检测
        const observer = new MutationObserver(function () {
            handleClick(click);
        });
        observer.observe(document, {
            attributes: true,
            childList: true,
            subtree: true,
        });
    }
}

export default MaiDianConnector;
