import * as utils from "./utils.js";
import "./intersection-observer.polyfill.js";
import "intersection-observer";
import { jsonp } from "../net/jsonp.ts";

import axios from "axios";

const showedMapper = {};

function split(str, seprator) {
    return str.split(seprator);
}

/**
 *
 * @return {} pass
 * @param param
 */
function validateParam(param) {
    if (!param) {
        console.warn("参数MO不能为空，当前的参数为：", param);
        return false;
    }

    if (!param.dcm) {
        console.warn("dcm 必填。当前的参数为：", param);
        return false;
    }

    if (!param.dpm && !param.dom) {
        console.warn("dpm 和 dom 至少有一个。当前的参数为：", param);
        return false;
    }
    if (param.dpm && split(param.dpm, ".").length !== 4) {
        console.warn("dpm格式不正确。 当前的参数为：", param);
        return false;
    }
    if (param.dom && split(param.dom, ".").length !== 4) {
        console.warn("dom格式不正确。 当前的参数为：", param);
        return false;
    }
    if (split(param.dcm, ".").length !== 4) {
        console.warn("dcm格式不正确。 当前的参数为：", param);
        return false;
    }
    return true;
}

function doClickLog(data) {
    if (!validateParam(data)) {
        return;
    }
    axios.get(`/log/click?${new URLSearchParams(data).toString()}`);

}

const intersectionObservers: IntersectionObserver[] = []

function registryIntersectionObserver(items: any[]) {
    for (const observer of intersectionObservers) {
        observer.disconnect()
    }
    intersectionObservers.splice(0)

    items.forEach((item) => {
        if (typeof item.ele === "string") {
            generatorShow(item);
        } else {
            item.ele.map((eleChild) => generatorShow({ ...item, ele: eleChild }));
        }
        // // 目标元素在dom中则处理
        // if (!!utils.getReference(item.ele)) {
        //   // 参数校验
        //   if (!item || !validateParam(item.data)) {
        //     return;
        //   }

        //   var observer = new IntersectionObserver(function (changes) {
        //     const { once = true, ele, data = {} } = item;
        //     changes.forEach((change) => {
        //       // 如果出现在页面中
        //       if (change.intersectionRatio > 0) {
        //         // 已经曝光过了
        //         if (showedMapper[ele]) {
        //           return;
        //         }

        //         showedMapper[ele] = true;

        //         observer.unobserve(change.target);
        //         const net = {
        //           name: "showLog",
        //           uri: data.domain + "/exposure/standard",
        //           type: "get",
        //           dataType: "jsonp",
        //           param: data,
        //           callback: null,
        //           hideMsg: true,
        //         };
        //         doAjax(net);
        //       } else {
        //         // 消失在视口
        //         if (!once) {
        //           // 如果需要曝光多次就移除
        //           showedMapper[ele] = false;
        //         }
        //       }
        //     });
        //   }, {});
        //   // 为目标元素注册IntersectionObserver
        //   let element = utils.getReference(item.ele);
        //   element && observer.observe(element);
        // }
    });
}

const generatorShow = (item: { ele: any; data: any; once?: any; }) => {
    // 目标元素在dom中则处理
    if (utils.getReference(item.ele)) {
        // 参数校验
        if (!item || !validateParam(item.data)) {
            return;
        }

        const observer = new IntersectionObserver(function (changes) {
            const { once = true, ele, data = {} } = item;
            changes.forEach((change) => {
                // 如果出现在页面中
                if (change.intersectionRatio > 0) {
                    // 已经曝光过了
                    if (showedMapper[ele]) {
                        return;
                    }

                    showedMapper[ele] = true;

                    observer.unobserve(change.target);

                    jsonp(`${data.domain}/exposure/standard?${new URLSearchParams(data).toString()}`);

                } else {
                    // 消失在视口
                    if (!once) {
                        // 如果需要曝光多次就移除
                        showedMapper[ele] = false;
                    }
                }
            });
        }, {});
        // 为目标元素注册IntersectionObserver
        const element = utils.getReference(item.ele);
        element && observer.observe(element);

        intersectionObservers.push(observer)
    }
};

function doShowLog(items) {
    // 先注册一次
    registryIntersectionObserver(items);

    // 每次dom 插入节点的时候重新检测
    const observer = new MutationObserver(function () {
        registryIntersectionObserver(items);
    });
    observer.observe(document, { childList: true, subtree: true });
}

const MD = {
    doClickLog: (data: any) => doClickLog(data),
    doShowLog: (items: any) => doShowLog(items),
};

export default MD;
