import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import legacy from '@vitejs/plugin-legacy'

import autoprefixer from "autoprefixer"
import postcsspxtorem from "postcss-pxtorem"
import { viteMockServe } from "vite-plugin-mock";

const isProd = process.env.NODE_ENV == "production";

// https://vitejs.dev/config/
export default defineConfig({
  base: isProd ? '//yun.duiba.com.cn/db_games/qx/testSparkVite/' : "",
  plugins: [
    react({
      babel: {
        plugins: [
          ["@babel/plugin-proposal-decorators", {legacy: true}],
          ["@babel/plugin-proposal-class-properties", {loose: true}],
        ],
      },
    }),
    legacy({
      targets: ['defaults', 'not IE 11'],
    }),
    viteMockServe({
      // default
      mockPath: 'mock',
      enable: true,
    }),
  ],
  css: {
    postcss: {
      plugins: [
        autoprefixer({
          overrideBrowserslist: [
            "Android 4.1",
            "iOS 7.1",
            "Chrome > 31",
            "ff > 31",
            "ie >= 8",
            "last 10 versions", // 所有主流浏览器最近10版本用
          ],
          grid: true
        }),
        postcsspxtorem({
          rootValue: 100,
          propList: ["*", "!border"], // 除 border 外所有px 转 rem
          selectorBlackList: [".el-"], // 过滤掉.el-开头的class，不进行rem转换
        }),
      ],
    },
    preprocessorOptions: {
      less: {
        javascriptEnabled: true,
      },
    },
    modules: {
      localsConvention: 'camelCase'
    }
  }
})
