import React, { Component, StrictMode } from 'react'
import { observer } from "mobx-react";
import { createRoot } from "react-dom/client";
import store from "./store/store";

import "./utils/checkwebp";

import '@csstools/normalize.css';

import './App.less'
import { PAGE_MAP } from "./utils/constants";
import LoadingDemo from "./pages/LoadingDemo/LoadingDemo";
import HomeDemo from "./pages/HomeDemo/HomeDemo";
import Modal from "./modal/modal";

const pageMap = {
  [PAGE_MAP.LOADING_PAGE]: <LoadingDemo />,
  [PAGE_MAP.HOME_PAGE]: <HomeDemo />,
};

@observer
class App extends Component {

  async componentDidMount() {
    await store.getFrontVariable();
  }

  render() {
    const {curPage, pageData} = store;
    return (
      <>
        {{...pageMap[curPage], props: {...pageData}}}
        <Modal/>
      </>
    );
  }
}

createRoot(document.getElementById('root')!).render(
  <App />
);
