import chalk from "chalk";

import AutoUpload from "../Uploader/Uploader.ts";
import * as path from "path";

interface IDuibaPublishOptions {
  buildVersion: string | number,
  uploadDir: string,
  accessKeySecret: string,
  accessKeyId: string,
  bucket: string,
  region: string,
}

export default function DuibaPublish(options: IDuibaPublishOptions) {

  const {
    buildVersion,
    uploadDir,
    accessKeySecret,
    accessKeyId,
    bucket,
    region,
  } = options;

  return {
    name: 'duiba-publish',

    async closeBundle() {
      const autoUpload = new AutoUpload({
        dir: path.resolve("dist"),
        originDir: `/${uploadDir}/`,
        accessKeySecret, accessKeyId, bucket, region,
      });

      await autoUpload.start();

      console.log(`${chalk.green(`上传成功: ${buildVersion}`)}`);

    }
  }
}
