import { FC, lazy, ReactNode } from 'react'
import React from 'react'

import styles from './Toast.module.less';

const classPrefix = '__com_toast_';

export interface ToastProps {
  afterClose?: () => void
  visible?: boolean
  mask?: boolean
  content?: ReactNode
  duration?: number
}

export const InternalToast: FC<ToastProps> = (props) => {
  const { mask, content, visible } = props;

  return <div
      className={styles.ToastRoot}
      style={{
        pointerEvents: mask ? 'auto' : 'none',
        display: visible ? "flex" : "none",
      }}
  >
    <div className={styles.ToastContent}>
      {content}
    </div>
  </div>
}
