import React, { Component } from 'react'
import { observer } from "mobx-react";
import { createRoot } from "react-dom/client";
import store from "./store/store";

import "./utils/checkwebp";

import "./MD";

import { PAGE_MAP } from "./utils/constants";
import LoadingDemo from "./pages/LoadingDemo/LoadingDemo";
import HomeDemo from "./pages/HomeDemo/HomeDemo";
import Modal from "./modal/modal";

import './App.less'
import '@csstools/normalize.css';
import API from "./api";


const pageMap = {
  [PAGE_MAP.LOADING_PAGE]: <LoadingDemo />,
  [PAGE_MAP.HOME_PAGE]: <HomeDemo />,
};

@observer
class App extends Component {

  async componentDidMount() {
    await store.getFrontVariable();
    store.initRule();
    API.index({aaaa: "啊实打实"});
  }

  render() {
    const { curPage, pageData } = store;
    return (
      <>
        {{ ...pageMap[curPage], props: { ...pageData } }}
        <Modal />
      </>
    );
  }
}

createRoot(document.getElementById('root')!).render(
  <App />
);
