import { obj2query, urlJoin } from "../utils";

export function jsonp(url: string, params: any = {}) {
  return new Promise<void>((resolve, reject) => {
    const src = urlJoin(url, obj2query(params));
    const scriptEl = document.createElement('script');

    scriptEl.src = src;
    scriptEl.onload = function () {
      resolve();
      document.body.removeChild(scriptEl);
    };
    scriptEl.onerror = function () {
      reject();
      document.body.removeChild(scriptEl);
    };
    /*const callbackFuncName = '__zeroing_jsonp_callback__' + Math.random();
    window[callbackFuncName] = function () {
      callback(result);
    };*/
    document.body.appendChild(scriptEl);
  })
}
