import { defineConfig, UserConfig } from 'vite'
import react from '@vitejs/plugin-react'

import dts from 'vite-plugin-dts';

// https://vite.dev/config/
export default defineConfig(({ mode }): UserConfig => {

    const isDev = mode == "development";

    return {
        build: {
            sourcemap: isDev,
            lib: {
                entry: "./src/main.tsx",
                name: 'builtIn',
                fileName: 'index',
            },
            cssTarget: 'chrome61',
            rollupOptions: {
                // 确保外部化处理那些你不想打包进库的依赖
                external: [],
                output: {
                    // 在 UMD 构建模式下为这些外部化的依赖提供一个全局变量
                    globals: {
                    },
                },
            },
        },
        plugins: [
            react(),
            dts({ rollupTypes: true, tsconfigPath: './tsconfig.app.json' })
        ],
        css: {
            preprocessorOptions: {
                less: {
                    javascriptEnabled: true,
                },
            },
            modules: {
                localsConvention: 'camelCase'
            }
        }
    }
})
