import { logClick, logExposure, MDAuto } from "@grace/built-in";

const appId = CFG.appID;
const dcm = "202." + CFG.projectId + ".0.0";
const domain = "https://embedlog.duiba.com.cn";
const MDList = new Array(2).fill("").map((v, i) => {
  return {
    ele: `.md${i + 1}`,
    data: {
      dpm: `${appId}.110.${i + 1}.0`,
      dcm,
      domain,
      appId,
    },
    once: false,
  };
});

export default () =>
  MDAuto({
    show: MDList, // 曝光
    click: MDList, // 点击
  });

export function handleLogExposure(id, id2 = 0) {
  logExposure({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
  });
}

export function handleLogClick(id, id2 = 0) {
  logClick({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
  });
}
