import { SvgaPlayer, SvgaPlayerRef } from "@grace/svgaplayer";

import styles from "./App.module.less";

import svga from "./assets/svga/1红色标题.svga";
import svga2 from "./assets/svga/2输出加载页氛围.svga";
import icon from "./assets/react.svg";

import { useEffect, useRef } from "react";

function App() {


    const svgaRef = useRef<SvgaPlayerRef>(null);

    useEffect(() => {
        console.log(svgaRef.current.getPlayer());
    });

    const clickPlay = () => {
        svgaRef.current?.start();
    }
    const clickStop = () => {
        svgaRef.current?.stop();
    }

    const clickReplaceImage = () => {
        svgaRef.current?.addImage("img_3929", "5555", icon, 200, 200);
    }

    const clickRemoveImage = () => {
        svgaRef.current?.removeImage("5555");
    }


    return <>
        <SvgaPlayer
            ref={svgaRef}
            className={styles.svgaTest}
            src={svga}
        />
        <SvgaPlayer
            className={styles.svgaTest2}
            src={svga2}
        />
        <SvgaPlayer
            className={styles.svgaTest3}
            src={svga2}
        />
        <div className={styles.container}>
            <div className={styles.button} onClick={clickPlay}>play</div>
            <div className={styles.button} onClick={clickStop}>stop</div>
            <div className={styles.button} onClick={clickReplaceImage}>replaceImage</div>
            <div className={styles.button} onClick={clickRemoveImage}>removeImage</div>
        </div>
    </>
}

export default App
